/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

public class HtmlUtils {
    public static String[] specials = new String[]{"\"", "quot", "<", "lt", "&", "amp", ">", "gt"};
    public static String[] tagExamples = new String[]{"<head>", "<title>", "<html", "<meta", "<br>", "<p>", "</p>", "<b>", "</b>", "<font", "</font>", "</a>", "<ol>", "<ul>", "<li>", "<img ", "</table>", "<tr>", "</tr>", "<td>", "</td>", "<strong>", "<h1>", "<h2>", "<h3>", "<h4>", "<h5>", "<h6>", "<em>", "<div>", "<span>"};

    public static boolean detectHtml(String s) {
        int i;
        if (s.length() > 1024) {
            s = s.substring(0, 1024);
        }
        s = s.toLowerCase();
        for (i = 1; i < specials.length; i += 2) {
            if (s.indexOf("&" + specials[i] + ";") == -1) continue;
            return true;
        }
        for (i = 0; i < tagExamples.length; ++i) {
            if (s.indexOf(tagExamples[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static String string2html(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            boolean special = false;
            for (int j = 0; j < specials.length; ++j) {
                if (s.charAt(i) != specials[j++].charAt(0)) continue;
                sb.append('&');
                sb.append(specials[j] + ";");
                special = true;
            }
            if (special) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static int maxLineLength(String s) {
        int r = 0;
        while (true) {
            int i;
            if ((i = s.indexOf(10)) == -1) {
                if (r > s.length()) {
                    return r;
                }
                return s.length();
            }
            if (i > r) {
                r = i;
            }
            if (i + 1 >= s.length()) break;
            s = s.substring(i + 1);
        }
        return r;
    }

    public static String text2html(String s, String startSeparator, String endSeparator) {
        s = HtmlUtils.string2html(s);
        String formatted = startSeparator;
        while (true) {
            int i;
            if ((i = s.indexOf(10)) == -1) {
                return formatted + s + endSeparator;
            }
            if (i > 0) {
                formatted = formatted + s.substring(0, i) + endSeparator + startSeparator;
            }
            if (i + 1 >= s.length()) break;
            s = s.substring(i + 1);
        }
        return formatted + endSeparator;
    }
}

