/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.makumba.InvalidValueException;
import org.makumba.NullObject;

public class Pointer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int MASK_ORDER = 24;
    protected long n;
    protected String type;
    public static Object Null = new NullObject("null");
    public static Object NullInteger = new NullObject("null integer");
    public static Object NullReal = new NullObject("null real");
    public static Object NullString = new NullObject("null char");
    public static Object NullText = new NullObject("null text");
    public static Object NullDate = new NullObject("null date");
    public static Object NullSet = new NullObject("null set");
    private static final List<Object> NullTypes = Arrays.asList(Null, NullDate, NullInteger, NullReal, NullSet, NullString, NullText);

    protected Pointer() {
    }

    public int getDbsv() {
        return (int)(this.n >> 24);
    }

    public int getUid() {
        return (int)(this.n & 0xFFFFFFL);
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getType() + "[" + this.getDbsv() + ":" + this.getUid() + "]";
    }

    public static boolean isNullObject(Object o) {
        return NullTypes.contains(o);
    }

    static long crc(long v) {
        long r = 0L;
        for (int i = 0; i < 32; ++i) {
            if ((v & 1L) == 1L) {
                ++r;
            }
            v >>= 1;
        }
        return r;
    }

    public String toExternalForm() {
        long hc = (long)this.type.hashCode() & 0xFFFFFFFFL;
        return Long.toString((Pointer.crc(this.n) & 0xFL) << 32 | this.n ^ hc, 36);
    }

    public Pointer(String type, String externalForm) {
        this.type = type;
        long hc = (long)type.hashCode() & 0xFFFFFFFFL;
        long l = 0L;
        try {
            l = Long.parseLong(externalForm, 36);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidValueException("invalid pointer value: " + externalForm);
        }
        this.n = l & 0xFFFFFFFFL;
        this.n ^= hc;
        if (l >> 32 != (Pointer.crc(this.n) & 0xFL)) {
            throw new InvalidValueException("invalid external pointer for type " + type + " : " + externalForm);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Pointer)) {
            return false;
        }
        Pointer p = (Pointer)o;
        if (!p.getType().equals(this.getType())) {
            System.err.println("warning: " + new InvalidValueException(this, p));
            return false;
        }
        return p.getDbsv() == this.getDbsv() && p.getUid() == this.getUid();
    }

    public int hashCode() {
        return ("" + this.longValue()).hashCode() * this.getType().hashCode();
    }

    public long longValue() {
        return this.n;
    }
}

