/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser;

import java.io.IOException;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.makumba.CompositeValidationException;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.analyser.interfaces.JspAnalyzer;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.RuntimeWrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysableTag
extends TagSupport {
    public static final String TYPES = "org.makumba.types";
    public static ThreadLocal<TagData> analyzedTag = new ThreadLocal();
    public static ThreadLocal<TagData> runningTag = new ThreadLocal();
    static ThreadLocal<Stack<TagData>> tagStack = new ThreadLocal();
    public TagData tagData;
    public MultipleKey tagKey;

    public static TagData getRunningTag() {
        return runningTag.get();
    }

    public static TagData getAnalyzedTag() {
        return analyzedTag.get();
    }

    public static TagData getCurrentBodyTag() {
        if (AnalysableTag.getThreadTagStack().isEmpty()) {
            return null;
        }
        return AnalysableTag.getThreadTagStack().peek();
    }

    public static void initializeThread() {
        AnalysableTag.getThreadTagStack().clear();
        runningTag.set(null);
        analyzedTag.set(null);
    }

    public static Stack<TagData> getThreadTagStack() {
        Stack<TagData> s = tagStack.get();
        if (s == null) {
            s = new Stack();
            tagStack.set(s);
        }
        return s;
    }

    public static PageCache getPageCache(PageContext pageContext, JspAnalyzer analyzer) {
        PageCache pageCache = (PageCache)pageContext.getAttribute("makumba.parse.cache");
        if (pageCache == null) {
            Object result = JspParseData.getParseData(pageContext.getServletConfig().getServletContext().getRealPath("/"), TomcatJsp.getJspURI((HttpServletRequest)pageContext.getRequest()), analyzer).getAnalysisResult(null);
            if (result instanceof Throwable) {
                if (result instanceof MakumbaError) {
                    throw (MakumbaError)result;
                }
                if (result instanceof RuntimeException) {
                    throw (RuntimeException)result;
                }
                throw new RuntimeException((Throwable)result);
            }
            pageCache = (PageCache)result;
            pageContext.setAttribute("makumba.parse.cache", (Object)pageCache);
        }
        return pageCache;
    }

    public void setTagDataAtAnalysis(TagData tagData) {
        this.tagData = tagData;
    }

    public void addTagText(StringBuffer sb) {
        JspParseData.tagDataLine(this.tagData, sb);
    }

    public String getTagText() {
        StringBuffer sb = new StringBuffer();
        this.addTagText(sb);
        return sb.toString();
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setTagKey(PageCache pageCache) {
    }

    public void doStartAnalyze(PageCache pageCache) {
    }

    public void doEndAnalyze(PageCache pageCache) {
    }

    public String getPageTextInfo() {
        if (this.tagData == null) {
            return "";
        }
        try {
            return this.tagData.getStart().getFile().getCanonicalPath() + ":" + this.tagData.getStart().getLine() + ":" + this.tagData.getStart().getColumn() + ":" + this.tagData.getEnd().getLine() + ":" + this.tagData.getEnd().getColumn();
        }
        catch (IOException e) {
            throw new MakumbaError(e.toString());
        }
    }

    public int doAnalyzedStartTag(PageCache pageCache) throws LogicException, JspException {
        return 0;
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws LogicException, JspException {
        return 6;
    }

    protected boolean needPageCache() {
        return true;
    }

    public int doStartTag() throws JspException {
        int n;
        PageCache pageCache = null;
        if (this.pageContext.getAttribute("javax.servlet.jsp.jspException", 2) != null && !(this.pageContext.getAttribute("javax.servlet.jsp.jspException", 2) instanceof CompositeValidationException)) {
            this.getRequest().setAttribute("org.makumba.wasException", (Object)"yes");
        }
        if ("yes".equals(this.getRequest().getAttribute("org.makumba.wasException")) && !(this.pageContext.getAttribute("javax.servlet.jsp.jspException", 2) instanceof CompositeValidationException)) {
            return 5;
        }
        if (this.needPageCache()) {
            pageCache = AnalysableTag.getPageCache(this.pageContext, MakumbaJspAnalyzer.getInstance());
        }
        this.setTagKey(pageCache);
        if (pageCache != null) {
            this.tagData = (TagData)pageCache.retrieve("org.makumba.tagData", this.tagKey);
            runningTag.set(this.tagData);
        }
        try {
            n = this.doAnalyzedStartTag(pageCache);
        }
        catch (LogicException e) {
            throw new RuntimeWrappedException(e);
        }
        if (this.tagData != null) {
            runningTag.set(null);
            AnalysableTag.getThreadTagStack().push(this.tagData);
        }
        return n;
    }

    public int doEndTag() throws JspException {
        try {
            if ("yes".equals(this.getRequest().getAttribute("org.makumba.wasException"))) {
                int n = 5;
                return n;
            }
            PageCache pageCache = null;
            if (this.needPageCache()) {
                pageCache = AnalysableTag.getPageCache(this.pageContext, MakumbaJspAnalyzer.getInstance());
            }
            if (this.tagData != null) {
                runningTag.set(this.tagData);
                AnalysableTag.getThreadTagStack().pop();
            }
            int n = this.doAnalyzedEndTag(pageCache);
            return n;
        }
        catch (LogicException e) {
            throw new RuntimeWrappedException(e);
        }
        finally {
            runningTag.set(null);
            this.tagKey = null;
        }
    }

    public MultipleKey getTagKey() {
        return this.tagKey;
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    public boolean allowsIdenticalKey() {
        return true;
    }

    public boolean canHaveBody() {
        return false;
    }
}

