/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.analyser.engine.SyntaxPoint;
import org.makumba.analyser.interfaces.JavaAnalyzer;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaParseData
implements SourceSyntaxPoints.PreprocessorClient {
    public static int analyzedPages = NamedResources.makeStaticCache("Java page analyses", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        public Object getHashObject(Object o) {
            Object[] o1 = (Object[])o;
            return (String)o1[0] + o1[1].getClass().getName();
        }

        public Object makeResource(Object o, Object hashName) throws Throwable {
            Object[] o1 = (Object[])o;
            return new JavaParseData((String)o1[0], (JavaAnalyzer)o1[1], (String)o1[2]);
        }
    }, true);
    private static String[] JavaCommentPatternNames = new String[]{"JavaBlockComment", "JavaDocComment", "JavaLineComment"};
    private static Pattern[] JavaCommentPatterns;
    private static String[] JavaClassUsagePatternNames;
    private static Pattern[] JavaClassUsagePatterns;
    private static Pattern JavaDocCommentPattern;
    private static Pattern JavaBlockCommentPattern;
    private static Pattern JavaLineCommentPattern;
    private static Pattern JavaModifierPattern;
    private static Pattern JavaReservedWordPattern;
    private static Pattern JavaStringLiteral;
    private static Pattern JavaVariableDefinition;
    private static Pattern JavaNewInstance;
    private static Pattern JavaParameter;
    private static Pattern JavaClassCast;
    private static Pattern JavaMethodReturn;
    private static Pattern JavaThrows;
    private static Pattern JavaCatch;
    private static Pattern JavaExtends;
    private static Pattern JavaImportPackage;
    private static Pattern JavaMethodInvocation;
    private static Pattern MakumbaFormHandler;
    private static List primitiveTypes;
    JavaAnalyzer analyzer;
    File file;
    Object holder;
    SourceSyntaxPoints syntaxPoints;
    String uri;
    HashSet<String> importedPackages = new HashSet();
    private Hashtable<String, String> importedClasses = new Hashtable();
    private String viewedClass = null;
    private String superClass = null;
    private Hashtable<String, ArrayList<DefinitionPoint>> definedObjects = new Hashtable();

    public static boolean isCommentSyntaxPoint(String type) {
        return Arrays.asList(JavaCommentPatternNames).contains(type);
    }

    public static boolean isClassUsageSyntaxPoint(String type) {
        return Arrays.asList(JavaClassUsagePatternNames).contains(type);
    }

    public static boolean isPrimitiveType(String type) {
        return primitiveTypes.contains(type);
    }

    private static void initPatterns() {
        String identifier = "\\w[\\w|\\d]*";
        String spaces = "[\\s]*";
        String minOneSpaces = "\\s" + spaces;
        JavaDocCommentPattern = Pattern.compile("/\\*\\*.*?[^\\*]\\*/", 32);
        JavaBlockCommentPattern = Pattern.compile("/\\*[^\\*]*\\*/", 32);
        JavaLineCommentPattern = Pattern.compile("//.*$", 8);
        JavaModifierPattern = Pattern.compile("(public )|(private )|(protected )|(transient )|(static )|(void )");
        JavaReservedWordPattern = Pattern.compile("(class )|(int )|(boolean )|(double )|(float )|(short )|(long )|(byte )|(for )|(for\\()|(do )|(do\\{)|(while )|(while\\()|(switch )|(case )|(return )|(if )|(if\\()|(else )|(import\\s)|(package\\s)|(super\\.)|(super \\()|(super )|(inner\\.)|(outer\\.)|(extends )|(throws )");
        JavaImportPackage = Pattern.compile("(package" + minOneSpaces + "\\w[\\w\\d\\.]*" + spaces + ";)|(import" + minOneSpaces + "\\w[\\w\\d\\.]*" + "[\\.\\*]?" + spaces + ";)");
        JavaStringLiteral = Pattern.compile("\"[^\"]*\"");
        JavaNewInstance = Pattern.compile("new" + minOneSpaces + identifier + "[(| ]");
        JavaVariableDefinition = Pattern.compile("[" + identifier + "\\.]*" + identifier + minOneSpaces + identifier + spaces + "[;|=]");
        JavaParameter = Pattern.compile("[(|,]" + spaces + identifier + minOneSpaces + identifier);
        JavaClassCast = Pattern.compile("\\(" + spaces + identifier + spaces + "\\)" + spaces + identifier);
        JavaMethodReturn = Pattern.compile(spaces + identifier + minOneSpaces + identifier + spaces + "\\(");
        JavaThrows = Pattern.compile("throws" + spaces + identifier);
        JavaCatch = Pattern.compile("catch" + spaces + identifier);
        JavaExtends = Pattern.compile("extends" + spaces + identifier);
        JavaMethodInvocation = Pattern.compile(identifier + spaces + "\\." + spaces + identifier + "\\(");
        MakumbaFormHandler = Pattern.compile("on_(new|add|edit|delete)\\w+\\(");
        JavaCommentPatterns = new Pattern[]{JavaBlockCommentPattern, JavaDocCommentPattern, JavaLineCommentPattern};
        JavaClassUsagePatterns = new Pattern[]{JavaVariableDefinition, JavaNewInstance, JavaParameter, JavaClassCast, JavaMethodReturn, JavaThrows, JavaCatch, JavaExtends};
    }

    public static JavaParseData getParseData(String webappRoot, String path, JavaAnalyzer an) {
        Object[] arg = new Object[]{webappRoot + path, an, path};
        return (JavaParseData)NamedResources.getStaticCache(analyzedPages).getResource(arg);
    }

    protected JavaParseData(String path, JavaAnalyzer an, String uri) {
        this.file = new File(path);
        this.uri = uri;
        this.analyzer = an;
    }

    public synchronized Object getAnalysisResult(Object initStatus) {
        if (this.getSyntaxPoints() == null || !this.getSyntaxPoints().unchanged()) {
            try {
                this.parse(initStatus);
            }
            catch (Error e) {
                this.holder = e;
                throw e;
            }
            catch (RuntimeException re) {
                this.holder = re;
                throw re;
            }
        }
        return this.holder;
    }

    public HashSet<String> getImportedPackages() {
        return this.importedPackages;
    }

    public Hashtable<String, String> getImportedClasses() {
        return this.importedClasses;
    }

    @Override
    public String[] getCommentPatternNames() {
        return JavaCommentPatternNames;
    }

    @Override
    public Pattern[] getCommentPatterns() {
        return JavaCommentPatterns;
    }

    @Override
    public String[] getLiteralPatternNames() {
        return new String[]{"JavaStringLiteral"};
    }

    @Override
    public Pattern[] getLiteralPatterns() {
        return new Pattern[]{JavaStringLiteral};
    }

    @Override
    public Pattern getIncludePattern() {
        return null;
    }

    @Override
    public String getIncludePatternName() {
        return null;
    }

    public String getDefinedObjectClassName(String objectName, int position) {
        ArrayList<DefinitionPoint> points = this.definedObjects.get(objectName);
        DefinitionPoint maxPoint = null;
        if (points != null) {
            for (int i = 0; i < points.size(); ++i) {
                DefinitionPoint current = points.get(i);
                if (current.position >= position) break;
                maxPoint = current;
            }
            if (maxPoint != null) {
                return maxPoint.className;
            }
        }
        return null;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String getViewedClass() {
        return this.viewedClass;
    }

    public SourceSyntaxPoints getSyntaxPoints() {
        return this.syntaxPoints;
    }

    void parse(Object initStatus) {
        long start = new Date().getTime();
        this.syntaxPoints = new SourceSyntaxPoints(this.file, this);
        this.holder = this.analyzer.makeStatusHolder(initStatus);
        this.treatJavaImports(this.syntaxPoints.getContent(), this.analyzer);
        this.treatJavaStringLiterals(this.syntaxPoints.getContent(), this.analyzer);
        this.treatJavaModifiers(this.syntaxPoints.getContent(), this.analyzer);
        this.treatReservedWords(this.syntaxPoints.getContent(), this.analyzer);
        this.treatClassUsage(this.syntaxPoints.getContent(), this.analyzer);
        this.treatMethodUsage(this.syntaxPoints.getContent(), this.analyzer);
        this.treatMakumbaHandler(this.syntaxPoints.getContent(), this.analyzer);
        this.holder = this.analyzer.endPage(this.holder);
        Logger.getLogger("org.makumba.javaparser.time").info("analysis of " + this.uri + " took " + (new Date().getTime() - start) + " ms");
    }

    @Override
    public void treatInclude(int position, String includeDirective, SourceSyntaxPoints host) {
    }

    void treatJavaImports(String content, JavaAnalyzer an) {
        Matcher m = JavaImportPackage.matcher(content);
        while (m.find()) {
            this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), "JavaImport", null);
            String sub = content.substring(m.start(), m.end() - 1).trim();
            String importedPackage = sub.split("\\s")[1];
            if (sub.endsWith(".*") || content.substring(m.start(), m.end()).trim().startsWith("package")) {
                if (importedPackage.startsWith("package")) {
                    importedPackage = importedPackage.substring("package".length()).trim();
                }
                if (importedPackage.endsWith(".*")) {
                    importedPackage = importedPackage.substring(0, importedPackage.length() - 2);
                }
                this.importedPackages.add(importedPackage + ".");
                continue;
            }
            String className = sub.substring(sub.lastIndexOf(".") + 1);
            this.importedClasses.put(className, importedPackage);
        }
    }

    void treatReservedWords(String content, JavaAnalyzer an) {
        Matcher m = JavaReservedWordPattern.matcher(content);
        while (m.find()) {
            String c;
            this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), "JavaReservedWord", null);
            String s = content.substring(m.start(), m.end()).trim();
            if (s.equals("class") && this.viewedClass == null) {
                c = content.substring(m.start()).trim();
                c = c.substring(c.indexOf(" ")).trim();
                this.viewedClass = c = c.substring(0, c.indexOf(" "));
                continue;
            }
            if (!s.equals("extends") || this.superClass != null) continue;
            c = content.substring(m.start()).trim();
            c = c.substring(c.indexOf(" ")).trim();
            this.superClass = c = c.substring(0, c.indexOf(" "));
        }
    }

    void treatClassUsage(String content, JavaAnalyzer an) {
        for (int i = 0; i < JavaClassUsagePatterns.length; ++i) {
            Matcher m = JavaClassUsagePatterns[i].matcher(content);
            while (m.find()) {
                int endIndex;
                String className;
                int beginIndex;
                String s;
                String substring = content.substring(m.start(), m.end());
                if (JavaClassUsagePatterns[i] == JavaMethodReturn && substring.trim().startsWith("new") || JavaParseData.isPrimitiveType(s = content.substring(beginIndex = content.indexOf(className = JavaParseData.extractClassName(substring, JavaClassUsagePatterns[i]), m.start()), endIndex = beginIndex + className.length()))) continue;
                SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(beginIndex, endIndex, JavaClassUsagePatternNames[i], null);
                if (JavaClassUsagePatterns[i] != JavaVariableDefinition && JavaClassUsagePatterns[i] != JavaParameter || substring.trim().indexOf("new ") != -1) continue;
                String objectName = substring.trim().substring(substring.indexOf(className) + className.length()).replace('=', ' ').replace(';', ' ').trim();
                ArrayList<DefinitionPoint> currentContent = this.definedObjects.get(objectName);
                if (currentContent == null) {
                    currentContent = new ArrayList();
                }
                currentContent.add(new DefinitionPoint(className, end.getPosition()));
                Collections.sort(currentContent);
                this.definedObjects.put(objectName, currentContent);
                Logger.getLogger("org.makumba.javaparser").finest("Put defined object: " + objectName + ", values: " + currentContent);
            }
        }
    }

    private static String extractClassName(String code, Pattern pattern) {
        code = code.replace('(', ' ').trim();
        code = code.replace(')', ' ').trim();
        code = code.replace(',', ' ').trim();
        StringTokenizer t = new StringTokenizer(code);
        ArrayList<String> s = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            s.add(t.nextToken());
        }
        String[] parts = s.toArray(new String[s.size()]);
        if (pattern == JavaVariableDefinition || pattern == JavaParameter || pattern == JavaMethodReturn || pattern == JavaClassCast) {
            return parts[0];
        }
        if (pattern == JavaNewInstance || pattern == JavaThrows || pattern == JavaCatch || pattern == JavaExtends) {
            return parts[1];
        }
        return "";
    }

    void treatJavaStringLiterals(String content, JavaAnalyzer an) {
        this.treatSimplePattern(content, an, JavaStringLiteral, "JavaStringLiteral");
    }

    void treatJavaModifiers(String content, JavaAnalyzer an) {
        this.treatSimplePattern(content, an, JavaModifierPattern, "JavaModifier");
    }

    void treatMethodUsage(String content, JavaAnalyzer an) {
        this.treatSimplePattern(content, an, JavaMethodInvocation, "JavaMethodInvocation");
    }

    void treatMakumbaHandler(String content, JavaAnalyzer an) {
        this.treatSimplePattern(content, an, MakumbaFormHandler, "MakumbaFormHandler");
    }

    private void treatSimplePattern(String content, JavaAnalyzer an, Pattern pattern, String SyntaxPointName) {
        Matcher m = pattern.matcher(content);
        while (m.find()) {
            this.syntaxPoints.addSyntaxPoints(m.start(), m.end() - 1, SyntaxPointName, null);
        }
    }

    static {
        JavaClassUsagePatternNames = new String[]{"JavaVariableDefinition", "JavaNewInstance", "JavaParameter", "JavaClassCast", "JavaMethodReturn", "JavaThrows", "JavaCatch", "JavaExtends"};
        primitiveTypes = Arrays.asList("char", "byte", "short", "int", "long", "boolean", "float", "double", "void");
        JavaParseData.initPatterns();
    }

    private class DefinitionPoint
    implements Comparable {
        String className;
        int position;

        public DefinitionPoint(String className, int position) {
            this.className = className;
            this.position = position;
        }

        public int compareTo(Object arg0) {
            return new Integer(this.position).compareTo(new Integer(((DefinitionPoint)arg0).position));
        }

        public String toString() {
            return this.position + ":" + this.className;
        }
    }
}

