/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser.engine;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.analyser.engine.SyntaxPoint;
import org.makumba.analyser.interfaces.JspAnalyzer;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspParseData
implements SourceSyntaxPoints.PreprocessorClient {
    File file;
    JspAnalyzer analyzer;
    SourceSyntaxPoints syntaxPoints;
    Object holder;
    String uri;
    private boolean usingHibernate = false;
    private String root;
    private static Pattern JspSystemTagPattern;
    private static Pattern JspTagPattern;
    private static Pattern JspCommentPattern;
    private static Pattern JspScriptletPattern;
    private static Pattern JspIncludePattern;
    private static Pattern JspTagAttributePattern;
    private static Pattern JspExpressionLanguagePattern;
    private static Pattern Word;
    private static Pattern TagName;
    private static String[] JspCommentPatternNames;
    private static Pattern[] JspCommentPatterns;
    static int analyzedPages;

    static String attribute(String attName) {
        return "(" + JspParseData.attribute(attName, "\"") + "|" + JspParseData.attribute(attName, "'") + ")";
    }

    static String attribute(String attName, String quote) {
        String bs = "\\";
        String q = bs + quote;
        String backslash = bs + bs;
        return bs + "s*" + attName + bs + "s*=" + bs + "s*" + q + "(" + backslash + ".|[^" + q + backslash + "])*?" + q;
    }

    public synchronized Object getAnalysisResult(Object initStatus) {
        if (this.getSyntaxPoints() == null || !this.getSyntaxPoints().unchanged()) {
            try {
                this.parse(initStatus);
            }
            catch (Error e) {
                this.holder = e;
                throw e;
            }
            catch (RuntimeException re) {
                this.holder = re;
                throw re;
            }
        }
        return this.holder;
    }

    public static JspParseData getParseData(String webappRoot, String path, JspAnalyzer an) {
        Object[] arg = new Object[]{webappRoot, an, path};
        return (JspParseData)NamedResources.getStaticCache(analyzedPages).getResource(arg);
    }

    public SourceSyntaxPoints getSyntaxPoints() {
        return this.syntaxPoints;
    }

    private JspParseData(String path, JspAnalyzer an, String uri) {
        this.root = path;
        this.file = new File(this.root + uri);
        this.uri = uri;
        this.analyzer = an;
    }

    void parse(Object initStatus) {
        long start = new Date().getTime();
        this.syntaxPoints = new SourceSyntaxPoints(this.file, this);
        this.holder = this.analyzer.makeStatusHolder(initStatus);
        this.treatEL(this.syntaxPoints.getContent(), this.analyzer);
        this.treatTags(this.syntaxPoints.getContent(), this.analyzer);
        this.holder = this.analyzer.endPage(this.holder);
        Logger.getLogger("org.makumba.jspparser.time").info("analysis of " + this.uri + " took " + (new Date().getTime() - start) + " ms");
    }

    Map<String, String> parseAttributes(String s, int origin) {
        HashMap<String, String> attributes = new HashMap<String, String>(13);
        Matcher m = JspTagAttributePattern.matcher(s);
        while (m.find()) {
            String attr = s.substring(m.start(), m.end());
            int n = attr.indexOf(61);
            String attName = attr.substring(0, n).trim();
            String attValQuoted = attr.substring(n + 1).trim();
            char chQuote = attValQuoted.charAt(0);
            if (attValQuoted.charAt(0) != attValQuoted.charAt(attValQuoted.length() - 1)) {
                throw new RuntimeException("Properly quoted string expected, found " + attValQuoted);
            }
            if (chQuote == '\"') {
                attValQuoted = attValQuoted.replaceAll("\\\\\"", "\"");
            } else if (chQuote == '\'') {
                attValQuoted = attValQuoted.replaceAll("\\\\'", "'");
            }
            attValQuoted = attValQuoted.replaceAll("(\\\\){2}", "\\\\");
            String attValue = attValQuoted.substring(1, attValQuoted.length() - 1);
            attributes.put(attName, attValue);
            if (origin != -1) {
                this.syntaxPoints.addSyntaxPoints(origin, origin + n, "JSPTagAttributeName", null);
                this.syntaxPoints.addSyntaxPoints(origin + n, origin + n + 1, "JSPTagAttributeEquals", null);
                this.syntaxPoints.addSyntaxPoints(origin + n + 1, origin + s.length(), "JSPTagAttributeValue", null);
            }
            Logger log = Logger.getLogger("org.makumba.jspparser.tags.attribute");
            log.finest("< Attribute : " + attr);
            log.finest("> AttrParse : " + attName + " = " + attValue);
        }
        return attributes;
    }

    @Override
    public void treatInclude(int position, String includeDirective, SourceSyntaxPoints host) {
        Map<String, String> m = this.parseAttributes(includeDirective, -1);
        String fileName = m.get("file");
        String dir = fileName.startsWith("/") ? this.root : host.file.getParent();
        host.include(new File(dir, fileName), position, includeDirective);
    }

    @Override
    public Pattern[] getCommentPatterns() {
        return JspCommentPatterns;
    }

    @Override
    public String[] getCommentPatternNames() {
        return JspCommentPatternNames;
    }

    @Override
    public Pattern getIncludePattern() {
        return JspIncludePattern;
    }

    @Override
    public String getIncludePatternName() {
        return "JspInclude";
    }

    void treatEL(String content, JspAnalyzer an) {
        Matcher m = JspExpressionLanguagePattern.matcher(content);
        while (m.find()) {
            SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), "ExpressionLanguage", null);
            SyntaxPoint start = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        }
    }

    void treatTags(String content, JspAnalyzer an) {
        Matcher tags = JspTagPattern.matcher(content);
        Matcher systemTags = JspSystemTagPattern.matcher(content);
        int tagStart = Integer.MAX_VALUE;
        if (tags.find()) {
            tagStart = tags.start();
        }
        int systemStart = Integer.MAX_VALUE;
        if (systemTags.find()) {
            systemStart = systemTags.start();
        }
        do {
            if (tagStart < systemStart) {
                this.treatTag(tags, content, an);
                tagStart = Integer.MAX_VALUE;
                if (!tags.find()) continue;
                tagStart = tags.start();
                continue;
            }
            if (systemStart >= tagStart) continue;
            this.treatSystemTag(systemTags, content, an);
            systemStart = Integer.MAX_VALUE;
            if (!systemTags.find()) continue;
            systemStart = systemTags.start();
        } while (tagStart != Integer.MAX_VALUE || systemStart != Integer.MAX_VALUE);
    }

    void treatTag(Matcher m, String content, JspAnalyzer an) {
        Logger log;
        String tag = content.substring(m.start(), m.end());
        boolean tagEnd = tag.startsWith("</");
        boolean tagClosed = tag.endsWith("/>");
        Matcher m1 = TagName.matcher(tag);
        m1.find();
        this.syntaxPoints.addSyntaxPoints(m.start() + m1.start(), m.start() + m1.end(), "JSPTagName", null);
        String type = tagEnd ? "JspTagEnd" : (tagClosed ? "JspTagSimple" : "JspTagBegin");
        SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), type, null);
        SyntaxPoint start = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        String tagName = tag.substring(m1.start(), m1.end());
        TagData td = null;
        td = new TagData();
        td.name = tagName;
        td.parseData = this;
        td.start = start;
        td.end = end;
        if (!tagEnd) {
            td.attributes = this.parseAttributes(tag, m.start());
        }
        if ((log = Logger.getLogger("org.makumba.jspparser.tags")).isLoggable(Level.FINE)) {
            log.fine(this.uri + ":" + start.line + ":" + start.column + ": " + (tagEnd ? "/" + tagName : td.name + " " + td.attributes));
        }
        if (tagEnd) {
            an.endTag(td, this.holder);
            return;
        }
        if (tagClosed) {
            an.simpleTag(td, this.holder);
        } else {
            an.startTag(td, this.holder);
        }
    }

    void treatSystemTag(Matcher m, String content, JspAnalyzer an) {
        Logger log;
        String tag = content.substring(m.start(), m.end());
        SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(m.start(), m.end(), "JSPSystemTag", null);
        Matcher m1 = Word.matcher(tag);
        m1.find();
        this.syntaxPoints.addSyntaxPoints(m.start() + m1.start(), m.start() + m1.end(), "JSPSystemTagName", null);
        SyntaxPoint start = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        TagData td = new TagData();
        td.name = tag.substring(m1.start(), m1.end());
        td.parseData = this;
        td.attributes = this.parseAttributes(tag, m.start());
        td.start = start;
        td.end = end;
        if (td.name.equals("taglib") && td.attributes.get("uri") != null && td.attributes.get("uri").toString().startsWith("http://www.makumba.org/") && !td.attributes.get("uri").equals("http://www.makumba.org/presentation")) {
            this.usingHibernate = true;
        }
        if ((log = Logger.getLogger("org.makumba.jspparser.tags")).isLoggable(Level.FINE)) {
            log.fine(this.uri + ":" + start.line + ":" + start.column + ": " + td.name + " " + td.attributes);
        }
        an.systemTag(td, this.holder);
    }

    public static void tagDataLine(TagData td, StringBuffer sb) {
        sb.append("\n").append(td.start.sourceFile.getLineText(td.start.getLine())).append('\n');
        for (int i = 1; i < td.start.getColumn(); ++i) {
            sb.append(' ');
        }
        sb.append('^');
    }

    public static void fill(Tag t, Map attributes) {
        Class<?> c = t.getClass();
        Class[] argTypes = new Class[]{String.class};
        Object[] args = new Object[1];
        for (Map.Entry me : attributes.entrySet()) {
            String s = (String)me.getKey();
            String methodName = "set" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
            try {
                Method m = c.getMethod(methodName, argTypes);
                args[0] = me.getValue();
                m.invoke((Object)t, args);
            }
            catch (InvocationTargetException ite) {
                System.out.println("error invoking method " + methodName + " on object of class " + c.getName() + " with argument " + args[0]);
                throw new RuntimeWrappedException(ite.getTargetException());
            }
            catch (Throwable thr) {
                System.out.println("error invoking method " + methodName + " on object of class " + c.getName() + " with argument " + args[0]);
                throw new RuntimeWrappedException(thr);
            }
        }
    }

    public boolean isUsingHibernate() {
        return this.usingHibernate;
    }

    @Override
    public String[] getLiteralPatternNames() {
        return null;
    }

    @Override
    public Pattern[] getLiteralPatterns() {
        return null;
    }

    static {
        JspCommentPatternNames = new String[]{"JspComment", "JspScriptlet"};
        analyzedPages = NamedResources.makeStaticCache("JSP page analyses", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object getHashObject(Object o) {
                Object[] o1 = (Object[])o;
                return (String)o1[0] + o1[2] + o1[1].getClass().getName();
            }

            public Object makeResource(Object o, Object hashName) throws Throwable {
                Object[] o1 = (Object[])o;
                return new JspParseData((String)o1[0], (JspAnalyzer)o1[1], (String)o1[2]);
            }
        }, true);
        String attribute = JspParseData.attribute("\\w+");
        try {
            JspTagAttributePattern = Pattern.compile(attribute);
            JspSystemTagPattern = Pattern.compile("<%@\\s*\\w+(" + attribute + ")*\\s*%>");
            JspIncludePattern = Pattern.compile("<%@\\s*include" + JspParseData.attribute("file") + "\\s*%>");
            JspTagPattern = Pattern.compile("<((\\s*\\w+:\\w+(" + attribute + ")*\\s*)/?|(/\\w+:\\w+\\s*))>");
            JspCommentPattern = Pattern.compile("<%--.*?[^-]--%>", 32);
            JspScriptletPattern = Pattern.compile("<%[^@].*?%>", 32);
            JspExpressionLanguagePattern = Pattern.compile("\\$\\{[^\\}]*\\}");
            Pattern[] cp = new Pattern[]{JspCommentPattern, JspScriptletPattern};
            JspCommentPatterns = cp;
            Word = Pattern.compile("\\w+");
            TagName = Pattern.compile("\\w+:\\w+");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

