/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser.engine;

import java.io.File;
import org.makumba.analyser.engine.SourceSyntaxPoints;

public abstract class SyntaxPoint
implements Comparable {
    int position;
    int offset = 0;
    boolean begin;
    int line;
    int column;
    SourceSyntaxPoints sourceFile;

    public SyntaxPoint(int position, boolean begin) {
        this.position = position;
        this.begin = begin;
    }

    public SyntaxPoint(int position) {
        this.position = position;
        this.begin = true;
    }

    public int getPosition() {
        return this.position;
    }

    public int getIncludeOffset() {
        return this.offset;
    }

    public int getOriginalPosition() {
        return this.getPosition() - this.getIncludeOffset();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOriginalColumn(int lineLength) {
        if (this.getColumn() > lineLength + 1) {
            return this.getColumn() - this.getIncludeOffset();
        }
        return this.getColumn();
    }

    public boolean isBegin() {
        return this.begin;
    }

    public abstract String getType();

    public Object getOtherInfo() {
        return null;
    }

    public File getFile() {
        return this.sourceFile.file;
    }

    public static SyntaxPoint makeEnd(SyntaxPoint begin, int position) {
        return new End(begin, position);
    }

    void moveByInclude(int delta) {
        this.position += delta;
        this.offset += delta;
    }

    public int compareTo(Object o) {
        SyntaxPoint sp = (SyntaxPoint)o;
        int n = this.position - sp.position;
        if (n != 0) {
            return n;
        }
        if (this.begin == sp.begin) {
            if (sp.getType().equals("TextLine")) {
                return sp.begin ? 1 : -1;
            }
            if (this.getType().equals("TextLine")) {
                return this.begin ? -1 : 1;
            }
            return this.getType().compareTo(sp.getType());
        }
        return this.begin ? 1 : -1;
    }

    public boolean equals(Object o) {
        SyntaxPoint sp = (SyntaxPoint)o;
        return sp != null && this.position == sp.position && this.begin == sp.begin && this.getType() == sp.getType();
    }

    public int hashCode() {
        return this.position * this.getType().hashCode() * (this.begin ? 1 : -1);
    }

    public String toString() {
        return "" + this.position + ":" + (this.begin ? "<" + this.getType() : this.getType() + ">");
    }

    public static class End
    extends SyntaxPoint {
        SyntaxPoint _begin;

        public End(SyntaxPoint begin, int position) {
            super(position, false);
            this._begin = begin;
        }

        public Object getOtherInfo() {
            return this._begin;
        }

        public String getType() {
            return this._begin.getType();
        }
    }
}

