/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.ProgrammerError;
import org.makumba.analyser.AnalysableTag;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.analyser.interfaces.JspAnalyzer;
import org.makumba.commons.GraphTS;

public class MakumbaJspAnalyzer
implements JspAnalyzer {
    static String[] listTags;
    static String[] oldFormTags;
    static String[] formTags;
    static String[] formTagNames;
    static final Map<String, Class> tagClasses;
    static final List<String> formTagNamesList;
    public static final String TAG_CACHE = "org.makumba.tags";
    public static final String DEPENDENCY_CACHE = "org.makumba.dependency";
    public static final String QUERY_LANGUAGE = "org.makumba.queryLanguage";

    private MakumbaJspAnalyzer() {
    }

    public static JspAnalyzer getInstance() {
        return SingletonHolder.singleton;
    }

    public void systemTag(TagData td, Object status) {
        if (td.name.equals("taglib") && td.attributes.get("uri") != null && td.attributes.get("uri").toString().startsWith("http://www.makumba.org/")) {
            String prefix = td.attributes.get("prefix");
            String URI2 = td.attributes.get("uri");
            if (URI2.equals("http://www.makumba.org/presentation") || URI2.equals("http://www.makumba.org/list")) {
                ((ParseStatus)status).makumbaPrefix = prefix;
                ((ParseStatus)status).makumbaURI = URI2;
                ((ParseStatus)status).pageCache.cache(QUERY_LANGUAGE, QUERY_LANGUAGE, "oql");
            } else if (URI2.equals("http://www.makumba.org/view-hql") || URI2.equals("http://www.makumba.org/hibernate") || URI2.equals("http://www.makumba.org/list-hql")) {
                ((ParseStatus)status).makumbaPrefix = prefix;
                ((ParseStatus)status).makumbaURI = URI2;
                ((ParseStatus)status).pageCache.cache(QUERY_LANGUAGE, QUERY_LANGUAGE, "hql");
            } else if (URI2.equals("http://www.makumba.org/forms")) {
                ((ParseStatus)status).formPrefix = prefix;
                ((ParseStatus)status).formMakumbaURI = URI2;
                if (((ParseStatus)status).pageCache.retrieve(QUERY_LANGUAGE, QUERY_LANGUAGE) == null) {
                    ((ParseStatus)status).pageCache.cache(QUERY_LANGUAGE, QUERY_LANGUAGE, "oql");
                }
            }
        }
    }

    public void simpleTag(TagData td, Object status) {
        String makumbaPrefix = ((ParseStatus)status).makumbaPrefix + ":";
        String formsPrefix = ((ParseStatus)status).formPrefix + ":";
        if (!td.name.startsWith(makumbaPrefix) && !td.name.startsWith(formsPrefix)) {
            return;
        }
        String tagName = "";
        if (td.name.startsWith(makumbaPrefix)) {
            tagName = td.name.substring(makumbaPrefix.length());
        } else if (td.name.startsWith(formsPrefix)) {
            tagName = td.name.substring(formsPrefix.length());
        }
        Class c = tagClasses.get(tagName);
        if (c == null) {
            return;
        }
        AnalysableTag.analyzedTag.set(td);
        AnalysableTag t = null;
        try {
            t = (AnalysableTag)((Object)c.newInstance());
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        td.tagObject = t;
        t.setTagDataAtAnalysis(td);
        ((ParseStatus)status).addTag(t, td);
        AnalysableTag.analyzedTag.set(null);
    }

    public void startTag(TagData td, Object status) {
        this.simpleTag(td, status);
        ((ParseStatus)status).start((AnalysableTag)((Object)td.tagObject));
    }

    public void endTag(TagData td, Object status) {
        AnalysableTag.analyzedTag.set(td);
        ((ParseStatus)status).end(td);
        AnalysableTag.analyzedTag.set(null);
    }

    public Object makeStatusHolder(Object initialStatus) {
        return new ParseStatus();
    }

    public Object endPage(Object status) {
        ((ParseStatus)status).endPage();
        return ((ParseStatus)status).pageCache;
    }

    static {
        int i;
        listTags = new String[]{"value", "org.makumba.list.tags.ValueTag", "list", "org.makumba.list.tags.QueryTag", "object", "org.makumba.list.tags.ObjectTag", "if", "org.makumba.list.tags.IfTag", "resultList", "org.makumba.list.tags.ResultListTag"};
        oldFormTags = new String[]{"form", "org.makumba.forms.tags.FormTagBase", "newForm", "org.makumba.forms.tags.NewTag", "addForm", "org.makumba.forms.tags.AddTag", "editForm", "org.makumba.forms.tags.EditTag", "deleteLink", "org.makumba.forms.tags.DeleteTag", "delete", "org.makumba.forms.tags.DeleteTag", "input", "org.makumba.forms.tags.InputTag", "action", "org.makumba.forms.tags.ActionTag", "option", "org.makumba.forms.tags.OptionTag", "searchForm", "org.makumba.forms.tags.SearchTag", "criterion", "org.makumba.forms.tags.CriterionTag", "searchField", "org.makumba.forms.tags.SearchFieldTag", "matchMode", "org.makumba.forms.tags.MatchModeTag"};
        formTags = new String[]{"form", "org.makumba.forms.tags.FormTagBase", "new", "org.makumba.forms.tags.NewTag", "add", "org.makumba.forms.tags.AddTag", "edit", "org.makumba.forms.tags.EditTag", "deleteLink", "org.makumba.forms.tags.DeleteTag", "delete", "org.makumba.forms.tags.DeleteTag", "input", "org.makumba.forms.tags.InputTag", "action", "org.makumba.forms.tags.ActionTag", "option", "org.makumba.forms.tags.OptionTag"};
        formTagNames = new String[]{"form", "newForm", "addForm", "editForm", "deleteLink", "delete", "new", "add", "edit"};
        tagClasses = new HashMap<String, Class>();
        formTagNamesList = Arrays.asList(formTagNames);
        for (i = 0; i < listTags.length; i += 2) {
            try {
                tagClasses.put(listTags[i], Class.forName(listTags[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        for (i = 0; i < oldFormTags.length; i += 2) {
            try {
                tagClasses.put(oldFormTags[i], Class.forName(oldFormTags[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        for (i = 0; i < formTags.length; i += 2) {
            try {
                tagClasses.put(formTags[i], Class.forName(formTags[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static final class SingletonHolder {
        static final JspAnalyzer singleton = new MakumbaJspAnalyzer();

        private SingletonHolder() {
        }
    }

    class ParseStatus {
        String makumbaPrefix = new String("dummy_prefix");
        String formPrefix = new String("dummy_prefix");
        String makumbaURI;
        String formMakumbaURI;
        List<AnalysableTag> tags = new ArrayList<AnalysableTag>();
        List<AnalysableTag> parents = new ArrayList<AnalysableTag>();
        PageCache pageCache = new PageCache();
        GraphTS formGraph = new GraphTS();

        ParseStatus() {
        }

        void addTag(AnalysableTag t, TagData td) {
            if (!this.parents.isEmpty()) {
                t.setParent((Tag)this.parents.get(this.parents.size() - 1));
            } else {
                t.setParent(null);
            }
            JspParseData.fill((Tag)t, td.attributes);
            t.setTagKey(this.pageCache);
            if (t.getTagKey() != null && !t.allowsIdenticalKey()) {
                AnalysableTag sameKey = (AnalysableTag)((Object)this.pageCache.retrieve(MakumbaJspAnalyzer.TAG_CACHE, t.getTagKey()));
                if (sameKey != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Due to limitations of the JSP standard, Makumba cannot make\n").append("a difference between the following two tags: \n");
                    sameKey.addTagText(sb);
                    sb.append("\n");
                    t.addTagText(sb);
                    sb.append("\nTo address this, add an id= attribute to one of the tags, and make sure that id is unique within the page.");
                    throw new ProgrammerError(sb.toString());
                }
                this.pageCache.cache(MakumbaJspAnalyzer.TAG_CACHE, t.getTagKey(), (Object)t);
            }
            if (formTagNamesList.contains(this.getTagName(t.tagData.name))) {
                if (t.getParent() instanceof AnalysableTag) {
                    AnalysableTag parent = (AnalysableTag)t.getParent();
                    if (formTagNamesList.contains(this.getTagName(parent.tagData.name))) {
                        td.nodeNumber = this.formGraph.addVertex(t.getTagKey());
                        this.formGraph.addEdge(td.nodeNumber, parent.tagData.nodeNumber);
                    } else {
                        td.nodeNumber = this.formGraph.addVertex(t.getTagKey());
                    }
                } else if (t.getParent() == null) {
                    td.nodeNumber = this.formGraph.addVertex(t.getTagKey());
                }
            }
            this.pageCache.cache("org.makumba.tagData", t.getTagKey(), td);
            t.doStartAnalyze(this.pageCache);
            this.tags.add(t);
        }

        public void start(AnalysableTag t) {
            if (t == null) {
                return;
            }
            if (!(t instanceof BodyTag) && !t.canHaveBody()) {
                throw new ProgrammerError("This type of tag cannot have a body:\n " + t.getTagText());
            }
            this.parents.add(t);
        }

        public void end(TagData td) {
            String tagName = td.name;
            if (!tagName.startsWith(this.makumbaPrefix) && !tagName.startsWith(this.formPrefix)) {
                return;
            }
            if (this.parents.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Error: Closing tag never opened:\ntag \"").append(td.name).append("\" at line ");
                JspParseData.tagDataLine(td, sb);
                throw new ProgrammerError(sb.toString());
            }
            tagName = this.getTagName(tagName);
            AnalysableTag t = this.parents.get(this.parents.size() - 1);
            if (!((Object)((Object)t)).getClass().equals(tagClasses.get(tagName))) {
                StringBuffer sb = new StringBuffer();
                sb.append("Body tag nesting error:\ntag \"").append(td.name).append("\" at line ");
                JspParseData.tagDataLine(td, sb);
                sb.append("\n\ngot incorrect closing \"").append(td.name).append("\" at line ");
                JspParseData.tagDataLine(td, sb);
                throw new ProgrammerError(sb.toString());
            }
            this.parents.remove(this.parents.size() - 1);
        }

        private String getTagName(String tagName) {
            if (tagName.startsWith(this.makumbaPrefix)) {
                tagName = tagName.substring(this.makumbaPrefix.length() + 1);
            } else if (tagName.startsWith(this.formPrefix)) {
                tagName = tagName.substring(this.formPrefix.length() + 1);
            }
            return tagName;
        }

        public void endPage() {
            for (AnalysableTag t : this.tags) {
                AnalysableTag.analyzedTag.set(t.tagData);
                t.doEndAnalyze(this.pageCache);
                AnalysableTag.analyzedTag.set(null);
            }
            this.formGraph.topo();
            this.pageCache.cache(MakumbaJspAnalyzer.DEPENDENCY_CACHE, MakumbaJspAnalyzer.DEPENDENCY_CACHE, this.formGraph.getSortedKeys());
        }
    }
}

