/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.SourceViewServlet;

public class MakumbaResourceServlet
extends HttpServlet {
    public static final String resourceDirectory = "makumbaResources";
    private static final long serialVersionUID = 1L;
    public static final String RESOURCE_PATH_JAVASCRIPT = "javaScript/";
    public static final String RESOURCE_PATH_CSS = "css/";
    public static final SimpleDateFormat dfLastModified = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static int makumbaResources = NamedResources.makeStaticCache("Makumba resources", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        public Object getHashObject(Object o) {
            return ClassResource.get(MakumbaResourceServlet.resourceDirectory + o);
        }

        public Object makeResource(Object o, Object hashName) throws Throwable {
            byte c;
            if (hashName == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            URL url = (URL)hashName;
            BufferedReader bis = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((c = (byte)bis.read()) != -1) {
                sb.append(String.valueOf((char)c));
            }
            return sb;
        }
    }, true);
    public static final String[] imageContentTypes = new String[]{"jpg", "jpeg", "png", "gif", "pjpeg", "tiff", "bmp", "x-emf", "x-wmf", "x-xbitmap"};

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter writer = resp.getWriter();
        String servletPath = req.getServletPath();
        String requestURI = req.getRequestURI();
        String resource = requestURI.substring(requestURI.indexOf(servletPath) + servletPath.length());
        URL url = ClassResource.get(resourceDirectory + resource);
        try {
            File file = new File(url.toURI());
            if (file.isDirectory()) {
                resp.setContentType("text/html");
                DevelUtils.writePageBegin(writer);
                DevelUtils.writeTitleAndHeaderEnd(writer, "Makumba resources");
                if (SourceViewServlet.redirected(req, resp, servletPath)) {
                    return;
                }
                String relativeDirectory = file.getName();
                if (file.getAbsolutePath().indexOf(resourceDirectory) != -1) {
                    relativeDirectory = file.getAbsolutePath().substring(file.getAbsolutePath().indexOf(resourceDirectory));
                }
                SourceViewServlet.printDirlistingHeader(writer, file, relativeDirectory);
                if (!relativeDirectory.equals(resourceDirectory)) {
                    writer.println("<b><a href=\"../\">../</a></b> (up one level)");
                }
                SourceViewServlet.processDirectory(writer, file, null);
                Object[] list = file.list();
                Arrays.sort(list);
                for (int i = 0; i < list.length; ++i) {
                    Object s = list[i];
                    File f = new File(file.getAbsolutePath() + File.separator + (String)s);
                    if (!f.isFile()) continue;
                    writer.println("<b><a href=\"" + (String)s + "\">" + (String)s + "</a></b>");
                }
                writer.println("</pre>");
                DevelUtils.writePageEnd(writer);
                return;
            }
            resp.setHeader("Last-Modified", dfLastModified.format(new Date(file.lastModified())));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        resp.setContentType(MakumbaResourceServlet.getContentType(url));
        writer.print(NamedResources.getStaticCache(makumbaResources).getResource(resource));
    }

    public static String getContentType(URL url) {
        for (int i = 0; i < imageContentTypes.length; ++i) {
            if (!url.getFile().endsWith("." + imageContentTypes[i])) continue;
            return "image / " + imageContentTypes[i];
        }
        return "text/html";
    }

    public static boolean isImageType(URL url) {
        for (int i = 0; i < imageContentTypes.length; ++i) {
            if (!url.getFile().endsWith("." + imageContentTypes[i])) continue;
            return true;
        }
        return false;
    }
}

