/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.TimeZone;

public class ReadableFormatter {
    public static String readableBytes(String byteSize) {
        try {
            return ReadableFormatter.readableBytes(new Long(byteSize.toString()));
        }
        catch (NumberFormatException nfe) {
            return "N/A";
        }
        catch (NullPointerException npe) {
            return "";
        }
    }

    public static String readableBytes(long byteSize) {
        if (byteSize < 0L) {
            return "invalid";
        }
        if (byteSize < 1L) {
            return "empty";
        }
        float byteSizeF = new Float(byteSize).floatValue();
        String unit = "bytes";
        float factor = 1.0f;
        String[] desc = new String[]{"B", "kB", "MB", "GB", "TB"};
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.setGroupingUsed(true);
        String value = nf.format(byteSizeF);
        int i = 0;
        while (i + 1 < desc.length && (value.length() > 4 || value.length() > 3 && value.indexOf(46) < 0)) {
            ++i;
            value = nf.format(byteSizeF / (factor *= 1024.0f));
        }
        if (value.charAt(0) == '0' && i > 0) {
            value = nf.format(Math.round(1024.0f * byteSizeF / factor));
            --i;
        }
        if (value.length() > 3 && value.indexOf(46) > 0) {
            value = value.substring(0, value.indexOf(46));
        }
        unit = desc[i];
        return value + " " + unit;
    }

    public static String readableAge(long milis) {
        int i;
        long secs = milis / 1000L;
        if (secs < 2L) {
            return "1 second";
        }
        if (secs == 2L) {
            return "2 seconds";
        }
        long value = secs;
        String unit = "seconds";
        Long s = new Long(secs);
        long[] breaks = new long[]{31536000L, 2628000L, 604800L, 86400L, 3600L, 60L, 1L};
        String[] desc = new String[]{"year", "month", "week", "day", "hour", "minute", "second"};
        for (i = 0; i <= breaks.length && secs <= 2L * breaks[i]; ++i) {
        }
        value = secs / breaks[i];
        unit = desc[i];
        if (value >= 2L) {
            unit = unit + "s";
        }
        String retval = value + " " + unit;
        return retval;
    }

    public static String readableDate(Date date) {
        DateFormat df = DateFormat.getInstance();
        df.setTimeZone(TimeZone.getTimeZone("CET"));
        return df.format(date);
    }
}

