/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.collections.EnumerationUtils;

public class StringUtils {
    private static final String DEFAULT_DELIMETER = ", ";

    public static String lowerCaseBeginning(String s) {
        return String.valueOf(s.charAt(0)).toLowerCase() + s.substring(1);
    }

    public static String upperCaseBeginning(String s) {
        return String.valueOf(s.charAt(0)).toUpperCase() + s.substring(1);
    }

    public static boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean notEmpty(Object o) {
        return o != null && o instanceof String && o.toString().length() > 0;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(Object o) {
        return o == null || o instanceof String && StringUtils.isEmpty((String)o);
    }

    public static String toString(Object[] array) {
        return StringUtils.toString(array, true);
    }

    public static String toString(Object[] array, String delimeter) {
        return StringUtils.toString(array, true, delimeter);
    }

    public static String toString(Object[] array, boolean frame) {
        return StringUtils.toString(array, frame, DEFAULT_DELIMETER);
    }

    public static String toString(Object[] array, boolean frame, String delimeter) {
        StringBuffer b = new StringBuffer();
        if (frame) {
            b.append('[');
        }
        for (int i = 0; i < array.length; ++i) {
            b.append(array[i]);
            if (i >= array.length - 1) continue;
            b.append(delimeter);
        }
        if (frame) {
            b.append(']');
        }
        return b.toString();
    }

    public static String toString(Collection collection, boolean frame, String delimeter) {
        return StringUtils.toString(collection.toArray(new Object[collection.size()]), frame, delimeter);
    }

    public static String toString(Collection collection, boolean frame) {
        return StringUtils.toString(collection, frame, DEFAULT_DELIMETER);
    }

    public static String toString(Collection collection) {
        return StringUtils.toString(collection, true);
    }

    public static String concatAsString(Object[] array) {
        return StringUtils.concatAsString(array, "_");
    }

    public static String concatAsString(Object[] array, String delim) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            b.append(array[i]);
            if (i >= array.length - 1) continue;
            b.append(delim);
        }
        return b.toString();
    }

    public static boolean equals(String s, String s2) {
        return s != null && s.equals(s2);
    }

    public static boolean equals(String s, Object o) {
        return o instanceof String && StringUtils.equals(s, (String)o);
    }

    public static boolean equals(Object o, String s) {
        return StringUtils.equals(s, o);
    }

    public static boolean equals(Object o, String[] options) {
        return o instanceof String && StringUtils.equals((String)o, options);
    }

    public static boolean equals(String s, String[] options) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < options.length; ++i) {
            if (!s.equals(options[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String s, String[] options) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < options.length; ++i) {
            if (!s.startsWith(options[i])) continue;
            return true;
        }
        return false;
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String toString(Enumeration enumeration) {
        return StringUtils.toString(EnumerationUtils.toList((Enumeration)enumeration));
    }
}

