/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.makumba.Attributes;
import org.makumba.CompositeValidationException;
import org.makumba.Database;
import org.makumba.LogicException;
import org.makumba.LogicInvocationError;
import org.makumba.LogicNotFoundException;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.Transaction;
import org.makumba.commons.ClassResource;
import org.makumba.commons.DbConnectionProvider;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;

public class Logic {
    static Properties controllerConfig;
    static URL controllerURL;
    static HashMap<String, Object> nameToObject;
    private static final String HANDLER_METHOD_HEAD = "public void ";
    private static final String HANDLER_METHOD_END = " throws LogicException {}";
    static int logix;
    static String[] separators;
    static Class[] argDb;
    static Class[] editArgs;
    static Class[] opArgs;
    static Class[] noClassArgs;
    static Object[] noObjectArgs;
    static Class[] deleteArgs;
    static Class[] newArgs;

    public static String getSearchMessage(String cls) {
        return (String)((Hashtable)NamedResources.getStaticCache(logix).getSupplementary()).get(cls);
    }

    public static Object getController(String className) {
        if (nameToObject.get(className) == null) {
            try {
                Object controller = Class.forName(className).newInstance();
                nameToObject.put(className, controller);
                return controller;
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to load controller class " + className, e);
            }
            catch (InstantiationException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to load controller class " + className, e);
            }
            catch (IllegalAccessException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to load controller class " + className, e);
            }
        }
        return nameToObject.get(className);
    }

    public static String findPackageName(String directory) {
        String packageName = "";
        String defaultPackage = "";
        String longestKey = "";
        if (controllerConfig != null) {
            Enumeration<Object> e = controllerConfig.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (k.equals("default") && longestKey.length() == 0) {
                    defaultPackage = controllerConfig.getProperty(k);
                    continue;
                }
                if (!directory.startsWith(k) || k.length() <= longestKey.length()) continue;
                longestKey = k;
                packageName = controllerConfig.getProperty(k);
            }
            if (longestKey.length() == 0 && defaultPackage.length() > 0) {
                packageName = defaultPackage;
            }
        }
        return packageName;
    }

    public static String upperCase(String a) {
        String ret = "";
        while (true) {
            int minimum = a.length();
            int imin = -1;
            for (int i = 0; i < separators.length; ++i) {
                int j = a.indexOf(separators[i]);
                if (j == -1 || j >= minimum) continue;
                minimum = j;
                imin = i;
            }
            ret = ret + Logic.firstUpper(a.substring(0, minimum));
            if (imin == -1) {
                return ret;
            }
            a = a.substring(minimum + separators[imin].length());
        }
    }

    static String firstUpper(String a) {
        char f = Character.toUpperCase(a.charAt(0));
        if (a.length() > 1) {
            return f + a.substring(1);
        }
        return "" + f;
    }

    public static Object getLogic(String path) {
        return NamedResources.getStaticCache(logix).getResource(path);
    }

    public static Object getAttribute(Object controller, String attname, Attributes a, String db, DbConnectionProvider dbcp) throws NoSuchMethodException, LogicException {
        if (controller instanceof LogicNotFoundException) {
            throw new NoSuchMethodException("no controller=> no attribute method");
        }
        Method m = controller.getClass().getMethod("find" + Logic.firstUpper(attname), argDb);
        Transaction d = dbcp.getConnectionTo(db);
        Object[] args = new Object[]{a, d};
        try {
            return m.invoke(controller, args);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchMethodException(e.getMessage());
        }
        catch (InvocationTargetException f) {
            d.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static String getControllerFile(Object controller) {
        String ctrlClass = controller.getClass().getName();
        URL u = ClassResource.get(ctrlClass.replace('.', '/') + ".java");
        if (u != null) {
            return Logic.getFilePath(u);
        }
        return ClassResource.get(ctrlClass.replace('.', '/') + ".class").toString();
    }

    public static String getFilePath(URL u) {
        try {
            return new File(u.getFile()).getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new RuntimeWrappedException(ioe);
        }
    }

    public static Method getMethod(String name, Class[] args, Object controller) {
        try {
            Method m = controller.getClass().getMethod(name, args);
            if (!Modifier.isPublic(m.getModifiers())) {
                return null;
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void doInit(Object controller, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        if (controller instanceof LogicNotFoundException) {
            return;
        }
        Transaction db = dbcp.getConnectionTo(dbName);
        Method init = Logic.getMethod("checkAttributes", argDb, controller);
        Method oldInit = Logic.getMethod("requiredAttributes", noClassArgs, controller);
        if (init == null && oldInit == null) {
            return;
        }
        if (init != null) {
            Object[] args = new Object[]{a, db};
            try {
                init.invoke(controller, args);
            }
            catch (IllegalAccessException g) {
                throw new LogicInvocationError(g);
            }
            catch (InvocationTargetException f) {
                db.rollback();
                Throwable g = f.getTargetException();
                if (g instanceof LogicException) {
                    throw (LogicException)g;
                }
                throw new LogicInvocationError(g);
            }
        }
        Logger.getLogger("org.makumba.controller").warning("requiredAttributes() is deprecated. Use checkAttributes(Attributes a, Database db) instead");
        Object attrs = null;
        try {
            attrs = oldInit.invoke(controller, noObjectArgs);
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
        if (attrs == null) {
            return;
        }
        if (attrs instanceof String) {
            a.getAttribute((String)attrs);
            return;
        }
        if (attrs instanceof String[]) {
            for (int i = 0; i < ((String[])attrs).length; ++i) {
                a.getAttribute(((String[])attrs)[i]);
            }
            return;
        }
        return;
    }

    public static Object doOp(Object controller, String opName, Dictionary data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        if (opName == null) {
            return null;
        }
        if (controller instanceof LogicNotFoundException) {
            throw new ProgrammerError("there is no controller object to look for the Form handler method " + opName);
        }
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] editArg = new Object[]{data, a, db};
        Method op = null;
        op = Logic.getMethod(opName, opArgs, controller);
        if (op == null) {
            throw new ProgrammerError("Class " + controller.getClass().getName() + " (" + Logic.getControllerFile(controller) + ")\n" + "does not define the method\n" + HANDLER_METHOD_HEAD + opName + "(Dictionary d, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + "The method is declared as a makumba form handler, so it has to be defined");
        }
        try {
            return op.invoke(controller, editArg);
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            if (g instanceof CompositeValidationException) {
                throw (CompositeValidationException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doEdit(Object controller, String handlerName, String afterHandlerName, String typename, Pointer p, Dictionary data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] editArg = new Object[]{p, data, a, db};
        Method edit = null;
        Method afterEdit = null;
        if (!(controller instanceof LogicNotFoundException)) {
            edit = Logic.getMethod(handlerName, editArgs, controller);
            afterEdit = Logic.getMethod(afterHandlerName, editArgs, controller);
            if (edit == null) {
                throw new ProgrammerError("Class " + controller.getClass().getName() + " (" + Logic.getControllerFile(controller) + ")\n" + "does not define the method\n" + HANDLER_METHOD_HEAD + handlerName + "(Pointer p, Dictionary d, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + "so it does not allow EDIT operations on the type " + typename + "\nDefine that method (even with an empty body) to allow such operations.");
            }
        }
        try {
            if (edit != null) {
                edit.invoke(controller, editArg);
            }
            db.update(p, data);
            if (afterEdit != null) {
                afterEdit.invoke(controller, editArg);
            }
            return p;
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doDelete(Object controller, String typename, Pointer p, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] deleteArg = new Object[]{p, a, db};
        Method delete2 = null;
        Method afterDelete = null;
        String upper = Logic.upperCase(typename);
        if (!(controller instanceof LogicNotFoundException)) {
            delete2 = Logic.getMethod("on_delete" + upper, deleteArgs, controller);
            afterDelete = Logic.getMethod("after_delete" + upper, deleteArgs, controller);
            if (delete2 == null) {
                throw new ProgrammerError("Class " + controller.getClass().getName() + " (" + Logic.getControllerFile(controller) + ")\n" + "does not define any of the methods\n" + HANDLER_METHOD_HEAD + "on_delete" + upper + "(Pointer p, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + "after_delete" + upper + "(Pointer p, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + "so it does not allow DELETE operations on the type " + typename + "\nDefine that method (even with an empty body) to allow such operations.");
            }
        }
        try {
            if (delete2 != null) {
                delete2.invoke(controller, deleteArg);
            }
            db.delete(p);
            if (afterDelete != null) {
                afterDelete.invoke(controller, deleteArg);
            }
            return null;
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doAdd(Object controller, String handlerName, String afterHandlerName, String typename, Pointer p, Dictionary data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] addArg = new Object[]{p, data, a, db};
        Method on = null;
        Method after = null;
        int n = typename.lastIndexOf("->");
        String field = typename.substring(n + 2);
        typename = typename.substring(0, n);
        if (!(controller instanceof LogicNotFoundException)) {
            on = Logic.getMethod(handlerName, editArgs, controller);
            after = Logic.getMethod(afterHandlerName, editArgs, controller);
            if (on == null && after == null) {
                throw new ProgrammerError("Class " + controller.getClass().getName() + " (" + Logic.getControllerFile(controller) + ")\n" + "does not define neither of the methods\n" + HANDLER_METHOD_HEAD + handlerName + "(Pointer p, Dictionary d, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + HANDLER_METHOD_HEAD + afterHandlerName + "(Pointer p, Dictionary d, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + "so it does not allow ADD operations on the type " + typename + ", field " + field + "\nDefine any of the methods (even with an empty body) to allow such operations.");
            }
        }
        try {
            if (on != null) {
                on.invoke(controller, addArg);
            }
            addArg[0] = db.insert(p, field, data);
            if (after != null) {
                after.invoke(controller, addArg);
            }
            return (Pointer)addArg[0];
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    public static Pointer doNew(Object controller, String handlerName, String afterHandlerName, String typename, Dictionary data, Attributes a, String dbName, DbConnectionProvider dbcp) throws LogicException {
        Transaction db = dbcp.getConnectionTo(dbName);
        Object[] onArgs = new Object[]{data, a, db};
        Object[] afterArgs = new Object[]{null, data, a, db};
        Method on = null;
        Method after = null;
        if (!(controller instanceof LogicNotFoundException)) {
            on = Logic.getMethod(handlerName, newArgs, controller);
            after = Logic.getMethod(afterHandlerName, editArgs, controller);
            if (on == null && after == null) {
                throw new ProgrammerError("Class " + controller.getClass().getName() + " (" + Logic.getControllerFile(controller) + ")\n" + "does not define neither of the methods\n" + HANDLER_METHOD_HEAD + handlerName + "(Dictionary d, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + HANDLER_METHOD_HEAD + afterHandlerName + "(Pointer p, Dictionary d, Attributes a, Database db)" + HANDLER_METHOD_END + "\n" + "so it does not allow NEW operations on the type " + typename + ".\nDefine any of the methods (even with an empty body) to allow such operations.");
            }
        }
        try {
            if (on != null) {
                on.invoke(controller, onArgs);
            }
            afterArgs[0] = db.insert(typename, data);
            if (after != null) {
                after.invoke(controller, afterArgs);
            }
            return (Pointer)afterArgs[0];
        }
        catch (IllegalAccessException g) {
            throw new LogicInvocationError(g);
        }
        catch (InvocationTargetException f) {
            db.rollback();
            Throwable g = f.getTargetException();
            if (g instanceof LogicException) {
                throw (LogicException)g;
            }
            throw new LogicInvocationError(g);
        }
    }

    static {
        nameToObject = new HashMap();
        controllerConfig = new Properties();
        try {
            controllerURL = ClassResource.get("MakumbaController.properties");
            controllerConfig.load(controllerURL.openStream());
        }
        catch (Exception e) {
            controllerConfig = null;
        }
        logix = NamedResources.makeStaticCache("Business logic classes", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;
            {
                this.supplementary = new Hashtable();
            }

            protected Object makeResource(Object p) {
                String path = (String)p;
                String msg = "Searching for business logic for " + path + ":";
                String className = "";
                int n = path.lastIndexOf(".");
                if (n != -1) {
                    path = path.substring(0, n);
                }
                String defa = "";
                String maxKey = "";
                if (controllerConfig != null) {
                    msg = msg + "\nfollowing rules from MakumbaController.properties found at:\n\t" + Logic.getFilePath(controllerURL);
                    Enumeration<Object> e = controllerConfig.keys();
                    while (e.hasMoreElements()) {
                        String k = (String)e.nextElement();
                        if (k.equals("default") && maxKey.length() == 0) {
                            defa = controllerConfig.getProperty(k);
                            continue;
                        }
                        if (!path.startsWith(k) || k.length() <= maxKey.length()) continue;
                        maxKey = k;
                        className = controllerConfig.getProperty(k);
                        if (className.length() <= 0 || className.lastIndexOf(".") == className.length() - 1) continue;
                        className = className + ".";
                    }
                    if (maxKey.length() == 0 && defa.length() > 0) {
                        msg = msg + "\nfollowing default rule from MakumbaController.properties";
                        className = defa + ".";
                    } else if (maxKey.length() > 0) {
                        msg = msg + "\nfollowing rule based on longest matching key from MakumbaController.properties\n\tkey is: \"" + maxKey + "\"";
                    }
                    path = path.substring(maxKey.length());
                } else {
                    msg = msg + "\ncould not find MakumbaController.properties in CLASSPATH";
                }
                msg = msg + "\ndetermined base: \"" + className + "\"";
                StringTokenizer st = new StringTokenizer(path, "/");
                Object lastFound = null;
                String dir = " ";
                block5: while (true) {
                    String base = className;
                    for (int i = 1; i <= dir.length(); ++i) {
                        if (i != dir.length() && !Character.isUpperCase(dir.charAt(i))) continue;
                        className = base + dir.substring(0, i).trim();
                        try {
                            msg = msg + "\ntrying \"" + className + "Logic\"";
                            lastFound = Class.forName(className + "Logic").newInstance();
                            msg = msg + "... found.";
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            msg = msg + "... not found";
                            continue;
                        }
                        catch (IllegalAccessException f) {
                            msg = msg + "... no public constructor";
                            continue;
                        }
                        catch (InstantiationException f) {
                            msg = msg + "... abstract class";
                        }
                    }
                    while (st.hasMoreTokens()) {
                        dir = st.nextToken();
                        if (dir.length() == 0) continue;
                        dir = Logic.firstUpper(dir);
                        continue block5;
                    }
                    break;
                }
                if (lastFound == null) {
                    msg = msg + "\nNo matching class found for " + p + "!";
                    lastFound = new LogicNotFoundException(msg);
                } else {
                    msg = msg + "\nFound class " + lastFound.getClass().getName();
                }
                Logger.getLogger("org.makumba.controller").info(msg);
                ((Hashtable)this.supplementary).put(p, msg);
                Object foundClass = nameToObject.get(lastFound.getClass().getName());
                if (foundClass != null) {
                    return foundClass;
                }
                return lastFound;
            }
        }, true);
        separators = new String[]{".", "->"};
        argDb = new Class[]{Attributes.class, Database.class};
        editArgs = new Class[]{Pointer.class, Dictionary.class, Attributes.class, Database.class};
        opArgs = new Class[]{Dictionary.class, Attributes.class, Database.class};
        noClassArgs = new Class[0];
        noObjectArgs = new Object[0];
        deleteArgs = new Class[]{Pointer.class, Attributes.class, Database.class};
        newArgs = new Class[]{Dictionary.class, Attributes.class, Database.class};
    }
}

