/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.hibernate.exception.ConstraintViolationException;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.MakumbaError;
import org.makumba.NoSuchFieldException;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.Transaction;
import org.makumba.db.DataHolder;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.TransactionProviderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionImplementation
implements Transaction {
    protected DataDefinitionProvider ddp;
    protected QueryProvider qp;
    protected TransactionProviderInterface tp;

    public TransactionImplementation(TransactionProviderInterface tp) {
        this.tp = tp;
        this.ddp = new DataDefinitionProvider();
    }

    @Override
    public abstract void close();

    @Override
    public abstract void commit();

    @Override
    public abstract void rollback();

    @Override
    public abstract String getName();

    @Override
    public abstract void lock(String var1);

    @Override
    public abstract void unlock(String var1);

    protected abstract int executeUpdate(String var1, String var2, String var3, Object var4);

    @Override
    public void delete(Pointer ptr) {
        DataDefinition ri = this.ddp.getDataDefinition(ptr.getType());
        FieldDefinition fi = ri.getParentField();
        if (fi != null && fi.getType().equals("ptrOne")) {
            this.executeUpdate(this.transformTypeName(fi.getDataDefinition().getName()) + " this", "this." + fi.getName() + "=" + this.getNullConstant(), "this." + fi.getName() + this.getPrimaryKeyName() + "=" + this.getParameterName(), ptr);
        }
        try {
            this.delete1(ptr);
        }
        catch (ConstraintViolationException e) {
            throw new DBError(e);
        }
    }

    @Override
    public int delete(String from, String where, Object parameters) {
        return this.executeUpdate(from, null, where, parameters);
    }

    @Override
    public abstract Vector executeQuery(String var1, Object var2, int var3, int var4);

    @Override
    public abstract Vector executeQuery(String var1, Object var2);

    @Override
    public TransactionProviderInterface getTransactionProvider() {
        return this.tp;
    }

    @Override
    public Pointer insert(String type, Dictionary data) {
        DataHolder dh = new DataHolder(this, data, type);
        dh.checkInsert();
        return dh.insert();
    }

    @Override
    public Pointer insert(Pointer base, String field, Dictionary data) {
        FieldDefinition fi = this.ddp.getDataDefinition(base.getType()).getFieldDefinition(field);
        if (fi == null) {
            throw new NoSuchFieldException(this.ddp.getDataDefinition(base.getType()), field);
        }
        if (fi.getType().equals("setComplex")) {
            data.put(fi.getSubtable().getSetOwnerFieldName(), base);
            return this.insert(fi.getSubtable().getName(), data);
        }
        throw new InvalidFieldTypeException(fi, "subset");
    }

    @Override
    public abstract int insertFromQuery(String var1, String var2, Object var3);

    protected abstract StringBuffer writeReadQuery(Pointer var1, Enumeration var2);

    @Override
    public void update(Pointer ptr, Dictionary fieldsToChange) {
        DataHolder dh = new DataHolder(this, fieldsToChange, ptr.getType());
        dh.checkUpdate(ptr);
        dh.update(ptr);
    }

    @Override
    public int update(String from, String set, String where, Object parameters) {
        return this.executeUpdate(from, set, where, parameters);
    }

    @Override
    public Dictionary read(Pointer p, Object flds) {
        Enumeration e = this.extractReadFields(p, flds);
        StringBuffer sb = this.writeReadQuery(p, e);
        Vector v = this.executeReadQuery(p, sb);
        if (v.size() == 0) {
            return null;
        }
        if (v.size() > 1) {
            throw new MakumbaError("MAKUMBA DATABASE INCOSISTENT: Pointer not unique: " + p);
        }
        Dictionary d = (Dictionary)v.elementAt(0);
        Hashtable h = new Hashtable(13);
        Enumeration en = d.keys();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            h.put(o, d.get(o));
        }
        return h;
    }

    protected Enumeration extractReadFields(Pointer p, Object flds) throws ProgrammerError {
        Enumeration e = null;
        if (flds == null) {
            DataDefinition ri = this.ddp.getDataDefinition(p.getType());
            Vector<String> v = new Vector<String>();
            Enumeration f = ri.getFieldNames().elements();
            while (f.hasMoreElements()) {
                String s = (String)f.nextElement();
                if (ri.getFieldDefinition(s).getType().startsWith("set")) continue;
                v.addElement(s);
            }
            e = v.elements();
        } else if (flds instanceof Vector) {
            e = ((Vector)flds).elements();
        } else if (flds instanceof Enumeration) {
            e = (Enumeration)flds;
        } else if (flds instanceof String[]) {
            Vector<String> v = new Vector<String>();
            String[] fl = (String[])flds;
            for (int i = 0; i < fl.length; ++i) {
                v.addElement(fl[i]);
            }
            e = v.elements();
        } else if (flds instanceof String) {
            Vector<String> v = new Vector<String>();
            v.add((String)flds);
            e = v.elements();
        } else {
            throw new ProgrammerError("read() argument must be Enumeration, Vector, String[], String or null");
        }
        return e;
    }

    protected abstract Vector executeReadQuery(Pointer var1, StringBuffer var2);

    public void delete1(Pointer ptr) {
        String ptrDD = ptr.getType();
        DataDefinition ri = this.ddp.getDataDefinition(ptrDD);
        Object[] param = new Object[]{ptr};
        Vector<String> ptrOnes = new Vector<String>();
        Enumeration e = ri.getFieldNames().elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!ri.getFieldDefinition(s).getType().equals("ptrOne")) continue;
            ptrOnes.addElement(s);
        }
        if (ptrOnes.size() > 0) {
            Dictionary d = this.read(ptr, ptrOnes);
            Enumeration e2 = d.elements();
            while (e2.hasMoreElements()) {
                this.delete((Pointer)e2.nextElement());
            }
        }
        e = ri.getFieldNames().elements();
        while (e.hasMoreElements()) {
            FieldDefinition fi = ri.getFieldDefinition((String)e.nextElement());
            if (!fi.getType().startsWith("set")) continue;
            if (fi.getType().equals("setComplex")) {
                this.executeUpdate(this.transformTypeName(fi.getSubtable().getName()) + " this", null, "this." + this.transformTypeName(fi.getSubtable().getFieldDefinition(3).getName()) + this.getPrimaryKeyName() + "= " + this.getParameterName(), param);
                continue;
            }
            this.tp.getCRUD().deleteSet(this, ptr, fi);
        }
        this.executeUpdate(this.transformTypeName(ptrDD) + " this", null, "this." + this.getPrimaryKeyName(ptrDD) + "=" + this.getParameterName(), ptr);
    }

    protected Map<String, Object> paramsToMap(Object args) {
        if (args instanceof Map) {
            return (Map)args;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (args == null) {
            return ret;
        }
        if (args instanceof List) {
            args = ((List)args).toArray();
        }
        if (args instanceof Object[]) {
            for (int j = 0; j < args.length; ++j) {
                ret.put("" + (j + 1), args[j]);
            }
            return ret;
        }
        ret.put("1", args);
        return ret;
    }

    protected Object[] treatParam(Object args) {
        if (args == null) {
            return new Object[0];
        }
        if (args instanceof Vector) {
            Vector v = (Vector)args;
            Object[] param = new Object[v.size()];
            v.copyInto(param);
            return param;
        }
        if (args instanceof Object[]) {
            return (Object[])args;
        }
        Object[] p = new Object[]{args};
        return p;
    }

    public String transformTypeName(String name) {
        return name;
    }

    public String getParameterName() {
        return "$1";
    }

    public String getPrimaryKeyName() {
        return "";
    }

    public String getPrimaryKeyName(String ptrDD) {
        return this.ddp.getDataDefinition(ptrDD).getIndexPointerFieldName();
    }

    public abstract String getNullConstant();

    @Override
    public abstract String getDataSource();
}

