/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.Transaction;
import org.makumba.commons.NameResolver;
import org.makumba.commons.SQLPointer;
import org.makumba.db.hibernate.HibernateTransaction;
import org.makumba.providers.CRUDOperationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCRUDOperationProvider
extends CRUDOperationProvider {
    private NameResolver nr = new NameResolver();

    @Override
    public void checkInsert(Transaction t, String type, Dictionary fieldsToCheck, Dictionary fieldsToIgnore, Dictionary allFields) {
        DataDefinition dd = this.ddp.getDataDefinition(type);
        dd.checkFieldNames(fieldsToCheck);
        Enumeration e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            Object o;
            String name = (String)e.nextElement();
            if (fieldsToIgnore.get(name) != null || (o = fieldsToCheck.get(name)) == null) continue;
            dd.getFieldDefinition(name).checkInsert(fieldsToCheck);
            fieldsToCheck.put(name, dd.getFieldDefinition(name).checkValue(o));
        }
    }

    @Override
    public void checkUpdate(Transaction t, String type, Pointer pointer, Dictionary fieldsToCheck, Dictionary fieldsToIgnore, Dictionary allFields) {
        DataDefinition dd = this.checkUpdate(type, fieldsToCheck, fieldsToIgnore);
    }

    @Override
    public Pointer insert(Transaction t, String type, Dictionary data) {
        try {
            HibernateTransaction ht = (HibernateTransaction)t;
            DataDefinition dd = this.ddp.getDataDefinition(type);
            String name = this.nr.arrowToDoubleUnderscore(dd.getName());
            Class<?> recordClass = null;
            recordClass = Class.forName(name);
            Object newRecord = null;
            newRecord = recordClass.newInstance();
            this.fillObject(t, data, dd, recordClass, newRecord);
            if (data.get("TS_create") == null) {
                Class[] classes = new Class[]{Date.class};
                Object[] now = new Object[]{new Date()};
                Method m = recordClass.getMethod("setTS_create", classes);
                m.invoke(newRecord, now);
                m = recordClass.getMethod("setTS_modify", classes);
                m.invoke(newRecord, now);
            }
            ht.s.persist(newRecord);
            ht.s.flush();
            Object pointerId = null;
            Class[] noParam = new Class[]{};
            Method getId = recordClass.getMethod("getprimaryKey", noParam);
            Object[] args = new Object[]{};
            pointerId = getId.invoke(newRecord, args);
            if (pointerId != null) {
                return new SQLPointer(type, new Long(((Integer)pointerId).intValue()));
            }
            throw new MakumbaError("Unexpected return type while trying to get ID of inserted record");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void fillObject(Transaction t, Dictionary data, DataDefinition dd, Class recordClass, Object newRecord) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Enumeration fields = data.keys();
        while (fields.hasMoreElements()) {
            String fieldName = (String)fields.nextElement();
            String fieldNameInClass = this.nr.checkReserved(fieldName);
            Object fieldValue = data.get(fieldName);
            FieldDefinition fd = dd.getFieldDefinition(fieldName);
            Class fieldType = null;
            switch (fd.getIntegerType()) {
                case 4: 
                case 5: {
                    fieldType = Integer.class;
                    break;
                }
                case 15: {
                    fieldType = Double.class;
                    break;
                }
                case 6: 
                case 7: {
                    fieldType = String.class;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    fieldType = Date.class;
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    fieldType = this.getPointerClass(fd.getPointedType().getName());
                    Pointer pointer = (Pointer)fieldValue;
                    fieldValue = this.getPointedObject(t, fieldType, pointer);
                    break;
                }
                case 3: {
                    fieldType = Integer.TYPE;
                    break;
                }
                case 8: 
                case 18: {
                    fieldType = Text.class;
                    break;
                }
                default: {
                    throw new RuntimeException("Unmapped type: " + fd.getName() + "-" + fd.getType());
                }
            }
            Class[] parameterTypes = new Class[]{fieldType};
            Method m = null;
            m = recordClass.getMethod("set" + fieldNameInClass, parameterTypes);
            m.invoke(newRecord, fieldValue);
        }
    }

    private Object getPointedObject(Transaction t, Class pointerClass, Pointer pointer) {
        return ((HibernateTransaction)t).s.get(pointerClass, (Serializable)Integer.valueOf(pointer.getUid()));
    }

    private Class<?> getPointerClass(String type) throws ClassNotFoundException {
        return Class.forName(this.nr.arrowToDoubleUnderscore(type));
    }

    @Override
    public void updateSet1(Transaction t, Pointer base, FieldDefinition fi, Object val) {
        if (fi.getType().equals("set")) {
            try {
                Collection values = (Collection)val;
                if (values.isEmpty()) {
                    return;
                }
                HibernateTransaction ht = (HibernateTransaction)t;
                Class<?> c = this.getPointerClass(base.getType());
                Object baseObject = this.getPointedObject(t, c, base);
                Method m = c.getMethod("get" + fi.getName(), new Class[0]);
                HashSet<Object> col = (HashSet<Object>)m.invoke(baseObject, new Object[0]);
                if (col == null) {
                    col = new HashSet<Object>();
                    m = c.getMethod("set" + fi.getName(), Collection.class);
                    m.invoke(baseObject, col);
                }
                for (Pointer p : values) {
                    Class<?> c1 = this.getPointerClass(p.getType());
                    col.add(this.getPointedObject(t, c1, p));
                }
                ht.s.saveOrUpdate(baseObject);
                ht.s.flush();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            super.updateSet1(t, base, fi, val);
        }
    }

    @Override
    public void deleteSet(Transaction t, Pointer base, FieldDefinition fi) {
        if (fi.getType().equals("set")) {
            try {
                HibernateTransaction ht = (HibernateTransaction)t;
                Class<?> c = this.getPointerClass(base.getType());
                Object baseObject = this.getPointedObject(t, c, base);
                Method m = c.getMethod("get" + fi.getName(), new Class[0]);
                m = c.getMethod("set" + fi.getName(), Collection.class);
                m.invoke(baseObject, new ArrayList());
                ht.s.saveOrUpdate(baseObject);
                ht.s.flush();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            super.deleteSet(t, base, fi);
        }
    }

    @Override
    public void update1(Transaction t, Pointer p, DataDefinition dd, Dictionary dic) {
        if (dic.isEmpty()) {
            return;
        }
        try {
            HibernateTransaction ht = (HibernateTransaction)t;
            String name = this.nr.arrowToDoubleUnderscore(dd.getName());
            Class<?> recordClass = null;
            recordClass = Class.forName(name);
            Object record = null;
            record = ht.s.get(recordClass, (Serializable)Integer.valueOf(p.getUid()));
            this.fillObject(t, dic, dd, recordClass, record);
            Class[] classes = new Class[]{Date.class};
            Object[] now = new Object[]{new Date()};
            Method m = recordClass.getMethod("setTS_modify", classes);
            m.invoke(record, now);
            ht.s.saveOrUpdate(record);
            ht.s.flush();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

