/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.makumba.ConfigFileError;
import org.makumba.MakumbaError;
import org.makumba.Transaction;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.db.makumba.DBConnectionWrapper;
import org.makumba.db.makumba.MakumbaCRUDOperationProvider;
import org.makumba.db.makumba.sql.Database;
import org.makumba.providers.CRUDOperationProvider;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.TransactionProviderInterface;

public class MakumbaTransactionProvider
implements TransactionProviderInterface {
    private static CRUDOperationProvider singleton;
    static Class[] theProp;
    static int dbs;

    public static org.makumba.db.makumba.Database getDatabase(String name) {
        try {
            return (org.makumba.db.makumba.Database)NamedResources.getStaticCache(dbs).getResource(name);
        }
        catch (RuntimeWrappedException e) {
            if (e.getCause() instanceof MakumbaError) {
                throw (MakumbaError)e.getCause();
            }
            throw e;
        }
    }

    public Transaction getConnectionTo(String name) {
        return (DBConnectionWrapper)MakumbaTransactionProvider.getDatabase(name).getDBConnection(name);
    }

    public String getDefaultDataSourceName() {
        return TransactionProvider.findDatabaseName("MakumbaDatabase.properties");
    }

    public String getDatabaseProperty(String name, String propName) {
        return MakumbaTransactionProvider.getDatabase(name).getConfiguration(propName);
    }

    public void _copy(String sourceDB, String destinationDB, String[] typeNames, boolean ignoreDbsv) {
        MakumbaTransactionProvider.getDatabase(destinationDB).copyFrom(sourceDB, typeNames, ignoreDbsv);
    }

    public void _delete(String whereDB, String provenienceDB, String[] typeNames, boolean ignoreDbsv) {
        MakumbaTransactionProvider.getDatabase(whereDB).deleteFrom(provenienceDB, typeNames, ignoreDbsv);
    }

    public String getDataSourceName(String lookupFile) {
        return TransactionProvider.findDatabaseName(lookupFile);
    }

    public boolean supportsUTF8() {
        return org.makumba.db.makumba.Database.supportsUTF8();
    }

    public CRUDOperationProvider getCRUD() {
        if (singleton == null) {
            singleton = new MakumbaCRUDOperationProvider();
        }
        return singleton;
    }

    public static org.makumba.db.makumba.Database findDatabase(String s) {
        return MakumbaTransactionProvider.getDatabase(TransactionProvider.findDatabaseName(s));
    }

    static {
        theProp = new Class[]{Properties.class};
        dbs = NamedResources.makeStaticCache("Databases open", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            protected Object makeResource(Object nm) {
                Properties p = new Properties();
                String name = (String)nm;
                try {
                    p.load(ClassResource.get(name + ".properties").openStream());
                }
                catch (Exception e) {
                    throw new ConfigFileError(name + ".properties");
                }
                try {
                    String origName = name;
                    name = name.substring(name.lastIndexOf(47) + 1);
                    int n = name.indexOf(95);
                    String host = name.substring(0, n);
                    p.put("#host", host);
                    int m = name.indexOf(95, n + 1);
                    if (Character.isDigit(name.charAt(n + 1))) {
                        p.put("#host", host + ":" + name.substring(n + 1, m));
                        n = m;
                        m = name.indexOf(95, n + 1);
                    }
                    p.put("#sqlEngine", name.substring(n + 1, m));
                    p.put("#database", name.substring(m + 1));
                    String dbclass = (String)p.get("dbclass");
                    if (dbclass == null && (dbclass = Database.getEngineProperty(p.getProperty("#sqlEngine") + ".dbclass")) == null) {
                        dbclass = "org.makumba.db.makumba.sql.Database";
                    }
                    p.put("db.name", name);
                    Object[] pr = new Object[]{p};
                    try {
                        org.makumba.db.makumba.Database d = (org.makumba.db.makumba.Database)Class.forName(dbclass).getConstructor(theProp).newInstance(pr);
                        d.configName = name;
                        d.fullName = origName;
                        d.tables = new NamedResources("Database tables for " + name, d.tableFactory);
                        return d;
                    }
                    catch (InvocationTargetException ite) {
                        throw new MakumbaError(ite.getTargetException());
                    }
                }
                catch (Exception e) {
                    throw new MakumbaError(e);
                }
            }
        });
    }
}

