/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.devel.DataServlet;
import org.makumba.devel.DevelUtils;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;

public class DataObjectViewerServlet
extends DataServlet {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doGet(request, response);
        this.browsePath = this.contextPath + "/dataList/" + this.browsePath;
        PrintWriter writer = response.getWriter();
        DevelUtils.writePageBegin(writer);
        DevelUtils.writeStylesAndScripts(writer, this.contextPath);
        DevelUtils.writeTitleAndHeaderEnd(writer, "Data Viewer");
        DataDefinition dd = null;
        this.dataPointer = new Pointer(this.type, request.getParameter("ptr"));
        try {
            dd = new DataDefinitionProvider().getDataDefinition(this.virtualPath);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (dd != null) {
            TransactionProvider tp = new TransactionProvider();
            Transaction t = tp.getConnectionTo(tp.getDefaultDataSourceName());
            try {
                String dataBaseName = t.getName();
                this.writePageContentHeader(this.type, writer, dataBaseName, 10);
                writer.println("<br/>");
                Vector[] allFields = DataServlet.extractFields(dd, false);
                Vector fields = allFields[0];
                String OQL = "SELECT ";
                for (int i = 0; i < fields.size(); ++i) {
                    FieldDefinition fd = (FieldDefinition)fields.get(i);
                    OQL = !fd.isSetType() ? OQL + "o." + fd.getName() + " AS " + fd.getName() : OQL + "\"<i>&lt;SET&gt;</i>\" AS " + fd.getName();
                    if (i + 1 >= fields.size()) continue;
                    OQL = OQL + ", ";
                }
                Vector v = t.executeQuery(OQL = OQL + " FROM " + this.type + " o WHERE o=$1", this.dataPointer);
                if (v.size() != 1) {
                    writer.println("<span style=\"color: red;\">Problem executing query:</span><br>");
                    writer.println(OQL + "<br><br>");
                    writer.println("<span style=\"color: red;\">==&gt; found " + v.size() + " results!</span>");
                } else {
                    Dictionary values = (Dictionary)v.firstElement();
                    writer.println("<table>");
                    writer.println("  <tr>");
                    writer.println("    <th>Field</th>");
                    writer.println("    <th>Value</th>");
                    writer.println("  </tr>");
                    for (int i = 0; i < fields.size(); ++i) {
                        FieldDefinition fd = (FieldDefinition)fields.get(i);
                        writer.println("  <tr>");
                        writer.print("    <td class=\"columnHead\">" + fd.getName());
                        if (fd.isDefaultField()) {
                            writer.print(" <span style=\"color:grey;font-style:italic;\">(default field)</span>");
                        }
                        writer.println("</td>");
                        Object value = values.get(fd.getName());
                        if (value instanceof Pointer) {
                            writer.println("    <td>" + DevelUtils.writePointerValueLink(this.contextPath, (Pointer)value) + "</td>");
                        } else {
                            writer.println("    <td>" + value + "</td>");
                        }
                        writer.println("  </tr>");
                    }
                    writer.println("</table>");
                }
            }
            finally {
                t.close();
            }
        }
        DevelUtils.writePageEnd(writer);
    }
}

