/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.commons.ClassResource;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.controller.Logic;
import org.makumba.devel.CodeGenerator;
import org.makumba.devel.CodeGeneratorTemplate;
import org.makumba.devel.JspxJspAnalyzer;
import org.makumba.devel.jspViewer;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.datadefinition.makumba.RecordParser;

public class GeneratedCodeViewer
extends jspViewer {
    private static final String CODE_TYPE_DELIM = "****************************************";
    private static String defaultTemplate;
    private static final String GENERATED_CODE_DIRECTORY = "generatedCode";
    private static Hashtable<String, String> selectableCodeTypes;
    private static ArrayList selectableCodeTypesOrdered;
    private static Hashtable[] TEMPLATES;
    private static final int TEMPLATES_ALL = 0;
    private static final int TEMPLATES_BUILTIN = 1;
    private static final int TEMPLATES_USERDEFINED = 2;
    private URL classesDirectory;
    private DataDefinition dd = null;
    private File fileRoot;
    private String logicDir;
    private String logicFileName;
    private String[] selectedCodeTypes = null;
    private String templateName;
    private String typeParam;

    private static void initTemplates() {
        for (int i = 0; i < TEMPLATES.length; ++i) {
            GeneratedCodeViewer.TEMPLATES[i] = new Hashtable();
        }
        URL[] templatePaths = new URL[]{ClassResource.get("org/makumba/devel/defaultCodeTemplates/"), ClassResource.get("codeTemplates")};
        for (int i = 0; i < templatePaths.length; ++i) {
            File templatePropDirectory;
            if (templatePaths[i] == null || !(templatePropDirectory = new File(templatePaths[i].getFile())).canRead() || !templatePropDirectory.isDirectory()) continue;
            File[] files = templatePropDirectory.listFiles(CodeGenerator.getFileFilter());
            for (int j = 0; j < files.length; ++j) {
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream(files[j]));
                    String name = files[j].getName().substring(0, files[j].getName().lastIndexOf(".properties"));
                    TEMPLATES[0].put(name, props);
                    TEMPLATES[i + 1].put(name, props);
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        defaultTemplate = (String)TEMPLATES[1].keys().nextElement();
        selectableCodeTypes = new Hashtable();
        selectableCodeTypes.put("New", "mak:newForm");
        selectableCodeTypes.put("Edit", "mak:editForm");
        selectableCodeTypes.put("List", "mak:list");
        selectableCodeTypes.put("Object", "mak:object");
        selectableCodeTypes.put("Delete", "mak:delete");
        selectableCodeTypes.put("Logic", "Java Business Logics");
        selectableCodeTypes.put("All", "all");
        selectableCodeTypesOrdered = new ArrayList<String>(Arrays.asList("All", "New", "Edit", "List", "Object", "Delete", "Logic"));
    }

    public GeneratedCodeViewer(HttpServletRequest req, HttpServlet sv) throws Exception {
        super(req, sv, true);
        URL u;
        this.servletContext = this.servlet.getServletContext();
        this.contextPath = this.request.getContextPath();
        this.setSearchLevels(false, false, false, true);
        this.virtualPath = req.getPathInfo();
        this.contextPath = req.getContextPath();
        if (this.virtualPath == null) {
            this.virtualPath = "/";
        }
        if ((u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "mdd")) == null) {
            u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "idd");
        }
        this.virtualPath = this.virtualPath.substring(1);
        this.readFromURL(u);
        this.generateCode();
    }

    public void generateCode() throws IOException {
        try {
            this.dd = new DataDefinitionProvider().getDataDefinition(this.virtualPath);
            this.typeParam = this.request.getParameter("type");
            if (this.typeParam == null) {
                this.typeParam = "New";
            }
            this.selectedCodeTypes = this.typeParam.equalsIgnoreCase("all") ? CodeGenerator.ALL_PROCESSABLE_TYPES : new String[]{CodeGenerator.nameToTypeMapping.get(this.typeParam)};
            if (this.selectedCodeTypes == null) {
                this.selectedCodeTypes = new String[]{"New"};
                this.typeParam = "New";
            }
            this.templateName = this.request.getParameter("template");
            if (this.templateName == null) {
                this.templateName = defaultTemplate;
            }
            CodeGeneratorTemplate template = new CodeGeneratorTemplate((Properties)TEMPLATES[0].get(this.templateName));
            String action = CodeGenerator.getLabelNameFromDataDefinition(this.dd) + "View.jsp";
            StringBuffer allPages = new StringBuffer();
            JspParseData jspParseData = null;
            String rootPath = this.servlet.getServletContext().getRealPath("/");
            this.fileRoot = new File(rootPath + File.separator + GENERATED_CODE_DIRECTORY);
            this.fileRoot.mkdirs();
            File allPagesFile = null;
            this.logicFileName = CodeGenerator.getLogicNameFromDataDefinition(this.dd) + ".java";
            this.classesDirectory = ClassResource.get("");
            CodeGenerator codeGenerator = new CodeGenerator();
            for (int i = 0; i < this.selectedCodeTypes.length; ++i) {
                File generatedCodeFile;
                String generatingType = CodeGenerator.nameToTypeMapping.get(this.selectedCodeTypes[i]);
                StringBuffer sb = new StringBuffer();
                if (generatingType == "Logic") {
                    String packageName = Logic.findPackageName("/");
                    this.logicDir = File.separator + GENERATED_CODE_DIRECTORY + File.separator + packageName.replace('.', File.separatorChar) + File.separator;
                    String logicPath = this.classesDirectory.getPath() + this.logicDir;
                    System.out.println(new File(this.logicDir).getAbsolutePath());
                    if (new File(logicPath).mkdirs()) {
                        Logger.getLogger("org.makumba.devel.codeGenerator").info("Created logic directory " + logicPath);
                    }
                    boolean hasSuperLogic = new File(logicPath + "Logic.java").exists();
                    codeGenerator.generateJavaBusinessLogicCode(this.dd, packageName, hasSuperLogic, this.selectedCodeTypes, sb);
                    generatedCodeFile = new File(logicPath + this.logicFileName);
                    allPages.append("\n ****************************************  " + selectableCodeTypes.get(generatingType) + "  " + CODE_TYPE_DELIM + "\n\n");
                    allPages.append(sb);
                } else {
                    if (i > 0) {
                        allPages.append("\n\n\n");
                    }
                    allPages.append("\n ****************************************  " + selectableCodeTypes.get(generatingType) + "  " + CODE_TYPE_DELIM + "\n\n");
                    codeGenerator.generateCode(sb, generatingType, this.dd, action, template);
                    allPages.append(sb);
                    String pageName = CodeGenerator.getFileNameFromObject(this.dd, generatingType);
                    String fileName = GENERATED_CODE_DIRECTORY + File.separator + pageName;
                    generatedCodeFile = new File(this.fileRoot, pageName);
                    if (this.selectedCodeTypes.length == 1) {
                        this.reader = new StringReader(sb.toString());
                        jspParseData = JspParseData.getParseData(rootPath, fileName, JspxJspAnalyzer.getInstance());
                    }
                }
                FileWriter writer = new FileWriter(generatedCodeFile);
                writer.write(sb.toString());
                writer.flush();
                writer.close();
            }
            if (this.selectedCodeTypes.length > 1) {
                String allPagesName = CodeGenerator.getFileNameFromObject(this.dd, this.typeParam);
                allPagesFile = new File(this.fileRoot, allPagesName);
                FileWriter writerAllPage = new FileWriter(allPagesFile);
                writerAllPage.write(allPages.toString());
                writerAllPage.flush();
                writerAllPage.close();
                this.reader = new StringReader(allPages.toString());
                jspParseData = JspParseData.getParseData(rootPath, GENERATED_CODE_DIRECTORY + File.separator + allPagesName, JspxJspAnalyzer.getInstance());
            }
            this.getParseData(jspParseData);
            if (allPagesFile != null) {
                allPagesFile.delete();
            }
        }
        catch (DataDefinitionNotFoundError e) {
            this.caughtError = e;
        }
        catch (DataDefinitionParseError e) {
            this.caughtError = e;
        }
    }

    public void intro(PrintWriter w) {
        String browsePath = this.contextPath + "/dataDefinitions/" + this.virtualPath.replace('.', '/').substring(0, this.virtualPath.lastIndexOf(46) + 1);
        String mddViewerPath = this.contextPath + "/dataDefinitions/" + this.virtualPath;
        w.println("<td align=\"right\" valign=\"top\" style=\"padding: 5px; padding-top: 10px\" nowrap=\"nowrap\">");
        w.println("<a style=\"color: darkblue;\" href=\"" + mddViewerPath + "\">mdd</a>&nbsp;&nbsp;&nbsp;");
        if (this.dd.getValidationDefinition() != null) {
            w.print("<a style=\"color: darkblue;\" href=\"" + this.contextPath + "/validationDefinitions/" + this.virtualPath + "\">validation definition</a>&nbsp;&nbsp;&nbsp;");
        }
        w.println("<span style=\"color:lightblue; background-color: darkblue; padding: 5px;\">code generator</span>&nbsp;&nbsp;&nbsp;");
        w.println("<a style=\"color: darkblue;\"href=\"" + browsePath + "\">browse</a>&nbsp;&nbsp;&nbsp;");
        w.println("</td>");
    }

    public void printPageBeginAdditional(PrintWriter w) throws IOException {
        if (this.dd != null) {
            w.println("<form style=\"margin-top:1px; margin-bottom:0px; font-size:smaller;\">");
            w.println("<b>Code type:</b>");
            for (int i = 0; i < selectableCodeTypesOrdered.size(); ++i) {
                Object key = selectableCodeTypesOrdered.get(i);
                w.print("<input type=\"radio\" name=\"type\" value=\"" + key + "\"");
                if (key.equals(this.typeParam)) {
                    w.print("checked=\"checked\" ");
                }
                w.println(" />" + selectableCodeTypes.get(key));
            }
            w.println("<br />");
            w.println("<b>Template:</b>");
            w.println("&nbsp;<i>Built-in</i>:");
            this.printTemplates(w, 1);
            w.println("&nbsp;&nbsp;<i>User-defined</i>:");
            this.printTemplates(w, 2);
            w.println("<input type=\"submit\" value=\"Generate!\" />");
            w.println("</form>");
            this.printGeneratedCodeLinks(w);
        }
    }

    private void getParseData(JspParseData jspParseData) {
        if (jspParseData != null) {
            jspParseData.getAnalysisResult(null);
            this.syntaxPoints = jspParseData.getSyntaxPoints();
            this.sourceSyntaxPoints = jspParseData.getSyntaxPoints().getSyntaxPoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGeneratedCodeLinks(PrintWriter w) {
        TransactionProvider tp = new TransactionProvider();
        String cgiParams = "";
        w.println("<span style=\"font-size: smaller;\">");
        boolean addSeperator = false;
        boolean firstPage = true;
        for (int i = 0; i < CodeGenerator.ALL_PROCESSABLE_TYPES.length; ++i) {
            String currentType = CodeGenerator.ALL_PROCESSABLE_TYPES[i];
            if (currentType == "Edit" || currentType == "Object" || currentType == "Delete" && cgiParams.equals("")) {
                String labelName = CodeGenerator.getLabelNameFromDataDefinition(this.dd);
                Transaction db = tp.getConnectionTo(tp.getDefaultDataSourceName());
                try {
                    String query = "SELECT " + labelName + " AS " + labelName + " FROM " + this.dd.getName() + " " + labelName;
                    Vector v = db.executeQuery(query, null, 0, 1);
                    if (v.size() > 0) {
                        cgiParams = "?" + labelName + "=" + ((Pointer)((Dictionary)v.firstElement()).get(labelName)).toExternalForm();
                    }
                }
                catch (RuntimeWrappedException e) {
                    w.println("<br/> <span style=\"color: red\">" + e.getCause() + "</span>");
                }
                finally {
                    db.close();
                }
            }
            if (firstPage) {
                w.print("<b>Preview:</b>&nbsp;");
                firstPage = false;
            }
            String pageName = CodeGenerator.getFileNameFromObject(this.dd, currentType);
            String fileName = this.fileRoot.getPath() + File.separator + pageName;
            boolean fileExists = new File(fileName).exists();
            boolean selectedType = Arrays.asList(this.selectedCodeTypes).contains(currentType);
            if (!fileExists) continue;
            if (addSeperator) {
                w.println("&nbsp;|");
                addSeperator = false;
            }
            w.print("<a target=\"_blank\" ");
            if (!selectedType) {
                w.print("style=\"color: grey;\" ");
            }
            w.println("href=\"" + this.contextPath + "/" + GENERATED_CODE_DIRECTORY + File.separator + pageName + cgiParams + "\"><i>" + pageName + "</i></a>");
            addSeperator = true;
        }
        if (new File(this.classesDirectory.getPath() + this.logicDir + this.logicFileName).exists()) {
            w.println("|&nbsp;<a target=\"_blank\" href=\"" + this.contextPath + "/classes/" + this.logicDir + this.logicFileName + "\"><i>" + this.logicFileName + "</i></a>");
            w.println("</span>");
        }
    }

    private void printTemplates(PrintWriter w, int index) {
        ArrayList templates = new ArrayList(TEMPLATES[index].keySet());
        Collections.sort(templates);
        if (templates.size() > 0) {
            for (int i = 0; i < templates.size(); ++i) {
                Object key = templates.get(i);
                w.print("<input type=\"radio\" name=\"template\" value=\"" + key + "\"");
                if (key.equals(this.templateName)) {
                    w.print("checked=\"checked\" ");
                }
                w.println(" />" + key);
            }
        } else {
            w.println("none available");
        }
    }

    static {
        selectableCodeTypes = new Hashtable();
        selectableCodeTypesOrdered = new ArrayList();
        TEMPLATES = new Hashtable[3];
        GeneratedCodeViewer.initTemplates();
    }
}

