/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.LogicNotFoundException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.analyser.engine.SyntaxPoint;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.commons.ClassResource;
import org.makumba.controller.Logic;
import org.makumba.devel.ErrorControllerHandler;
import org.makumba.devel.JspxJspAnalyzer;
import org.makumba.devel.LineViewer;

public class jspViewer
extends LineViewer {
    private static final String PROPERTIES_FILE_NAME = "jspSyntax.properties";
    private static Properties defaultTaglibProperties = new Properties();
    private static Properties taglibgSytleProperties;
    private static Properties SystemStyleProperties;
    private static final String DEFAULT_JSPSYSTEMTAG_STYLE;
    private static final String DEFAULT_JSPSCRIPLET_STYLE = "background:gold;color:green; border:red thin; font-weight: bold;";
    private static final String DEFAULT_JSPCOMMENT_STYLE = "color:gray;";
    private static final String DEFAULT_JSPEXPRESSIONLANGUAGE_STYLE = "font-style:italic;";
    private static final String DEFAULT_HIBERNATEPAGE_STYLE = "background-color: #CCFFCC;";
    private static String hibernateCodeBackgroundStyle;
    private static Set syntaxKeys;
    boolean hasLogic;
    protected SyntaxPoint[] sourceSyntaxPoints;
    protected SourceSyntaxPoints syntaxPoints;
    private boolean hideComments = false;
    private boolean hideHTML = false;
    private boolean hideJSTLCore = false;
    private boolean hideJSTLFormat = false;
    private boolean hideMakumba = false;
    private boolean hideJava = false;

    private static void initProperties() {
        try {
            URLConnection connection = ClassResource.get(PROPERTIES_FILE_NAME).openConnection();
            Properties jspSyntaxProperties = new Properties();
            jspSyntaxProperties.load(connection.getInputStream());
            SystemStyleProperties.put("ExpressionLanguage", jspSyntaxProperties.getProperty("ExpressionLanguage", DEFAULT_JSPEXPRESSIONLANGUAGE_STYLE));
            SystemStyleProperties.put("JspScriptlet", jspSyntaxProperties.getProperty("JspScriptlet", DEFAULT_JSPSCRIPLET_STYLE));
            SystemStyleProperties.put("JspComment", jspSyntaxProperties.getProperty("JspComment", DEFAULT_JSPCOMMENT_STYLE));
            SystemStyleProperties.put("JSPSystemTag", jspSyntaxProperties.getProperty("JSPSystemTag", jspSyntaxProperties.getProperty("jsp", DEFAULT_JSPSYSTEMTAG_STYLE)));
            jspSyntaxProperties.remove("JspScriptlet");
            jspSyntaxProperties.remove("JspComment");
            jspSyntaxProperties.remove("JSPSystemTag");
            jspSyntaxProperties.remove("ExpressionLanguage");
            taglibgSytleProperties = jspSyntaxProperties;
            hibernateCodeBackgroundStyle = jspSyntaxProperties.getProperty("HibernatePage", DEFAULT_HIBERNATEPAGE_STYLE);
        }
        catch (Throwable t) {
            Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").fine("JSP syntax highlighting properties file 'jspSyntax.properties' not found! Using default values.");
            SystemStyleProperties.put("ExpressionLanguage", DEFAULT_JSPEXPRESSIONLANGUAGE_STYLE);
            SystemStyleProperties.put("JspScriptlet", DEFAULT_JSPSCRIPLET_STYLE);
            SystemStyleProperties.put("JspComment", DEFAULT_JSPCOMMENT_STYLE);
            SystemStyleProperties.put("JSPSystemTag", DEFAULT_JSPSYSTEMTAG_STYLE);
            taglibgSytleProperties = defaultTaglibProperties;
            hibernateCodeBackgroundStyle = DEFAULT_HIBERNATEPAGE_STYLE;
        }
    }

    private int extraLength() {
        return 1;
    }

    public jspViewer(HttpServletRequest req, HttpServlet sv, boolean printLineNumbers) throws Exception {
        super(printLineNumbers, req, sv);
        this.setSearchLevels(true, false, false, true);
        this.servlet = sv;
        this.hideLineNumbers = this.request.getParameter("hideLines") == null || this.request.getParameter("hideLines").equals("true");
    }

    public jspViewer(HttpServletRequest req, HttpServlet sv) throws Exception {
        super(true, req, sv);
        this.setSearchLevels(true, false, false, true);
        this.servlet = sv;
        this.hideComments = Boolean.valueOf(String.valueOf(req.getParameter("hideComments")));
        this.hideHTML = Boolean.valueOf(String.valueOf(req.getParameter("hideHTML")));
        this.hideJSTLCore = Boolean.valueOf(String.valueOf(req.getParameter("hideJSTLCore")));
        this.hideJSTLFormat = Boolean.valueOf(String.valueOf(req.getParameter("hideJSTLFormat")));
        this.hideMakumba = Boolean.valueOf(String.valueOf(req.getParameter("hideMakumba")));
        this.hideJava = Boolean.valueOf(String.valueOf(req.getParameter("hideJava")));
        String thisFile = TomcatJsp.getJspURI(req);
        thisFile = thisFile.substring(0, thisFile.length() - 1);
        this.contextPath = req.getContextPath();
        String _servletPath = req.getServletPath();
        this.virtualPath = _servletPath.substring(0, _servletPath.length() - this.extraLength());
        this.jspSourceViewExtension = _servletPath.substring(_servletPath.length() - this.extraLength());
        this.realPath = sv.getServletConfig().getServletContext().getRealPath(this.virtualPath);
        _servletPath = _servletPath.substring(0, _servletPath.indexOf(".")) + ".jsp";
        this.logicPath = this.contextPath + "/logic" + _servletPath;
        this.hasLogic = !(Logic.getLogic(_servletPath) instanceof LogicNotFoundException);
        JspParseData jspParseData = JspParseData.getParseData(sv.getServletContext().getRealPath("/"), thisFile, JspxJspAnalyzer.getInstance());
        try {
            jspParseData.getAnalysisResult(null);
            if (jspParseData.isUsingHibernate()) {
                this.codeBackgroundStyle = hibernateCodeBackgroundStyle;
            }
            this.syntaxPoints = jspParseData.getSyntaxPoints();
            this.sourceSyntaxPoints = jspParseData.getSyntaxPoints().getSyntaxPoints();
        }
        catch (ProgrammerError e) {
            this.caughtError = e;
        }
        this.reader = new FileReader(this.realPath);
    }

    public void intro(PrintWriter w) throws IOException {
        w.println("<td align=\"right\" style=\"color: darkblue; padding: 5px; padding-top: 10px\">");
        w.println("<a href=\"" + this.contextPath + this.virtualPath + "\">execute</a>&nbsp;&nbsp;&nbsp;");
        w.println("<span style=\"color:lightblue; background-color: darkblue; padding: 5px;\">source</span>&nbsp;&nbsp;&nbsp;");
        w.println("<a href=\"" + this.logicPath + "\">business logic" + (this.hasLogic ? "" : " (none)") + "</a>");
        String lg = ErrorControllerHandler.getLoginPage(this.request, this.virtualPath);
        if (lg != null) {
            w.println("&nbsp;&nbsp;&nbsp;<a href=\"" + this.contextPath + lg + "x\">login page</a>&nbsp;&nbsp;&nbsp;");
        }
        w.println("</td>");
        w.println("</tr>");
        w.println("<tr>");
        w.println("<td align=\"right\" style=\" font-size: smaller;\">");
        w.println("<form method=\"get\" action>");
        w.println("Hide: <input type=\"checkbox\" name=\"hideComments\" value=\"true\"" + (this.hideComments ? " checked=\"checked\"" : "") + ">Comments  ");
        w.println("<input type=\"checkbox\" name=\"hideHTML\" value=\"true\"" + (this.hideHTML ? " checked=\"checked\"" : "") + ">HML  ");
        w.println("<input type=\"checkbox\" name=\"hideJava\" value=\"true\"" + (this.hideJava ? " checked=\"checked\"" : "") + ">Java  ");
        w.println("<input type=\"checkbox\" name=\"hideJSTLCore\" value=\"true\"" + (this.hideJSTLCore ? " checked=\"checked\"" : "") + ">JSTL Core  ");
        w.println("<input type=\"checkbox\" name=\"hideJSTLFormat\" value=\"true\"" + (this.hideJSTLFormat ? " checked=\"checked\"" : "") + ">JSTL Format  ");
        w.println("<input type=\"checkbox\" name=\"hideMakumba\" value=\"true\"" + (this.hideMakumba ? " checked=\"checked\"" : "") + ">Makumba  ");
        w.println("<input type=\"submit\" value=\"apply\"> ");
        w.println("</form>");
        w.println("</td>");
    }

    public void parseText(PrintWriter writer) throws IOException {
        if (this.sourceSyntaxPoints == null) {
            super.parseText(writer);
            return;
        }
        Date begin = new Date();
        Object[] syntaxElements = syntaxKeys.toArray();
        this.printPageBegin(writer);
        SyntaxPoint lastSyntaxPoint = null;
        boolean shallWrite = true;
        boolean lastShallWrite = false;
        int inTag = 0;
        StringBuffer currentText = new StringBuffer();
        for (int j = 0; this.sourceSyntaxPoints != null && j < this.sourceSyntaxPoints.length; ++j) {
            SyntaxPoint currentSyntaxPoint = this.sourceSyntaxPoints[j];
            String type = currentSyntaxPoint.getType();
            int currentLine = currentSyntaxPoint.getLine();
            String lineText = this.syntaxPoints.getLineText(currentLine);
            int currentLineLength = lineText.length();
            if (currentSyntaxPoint.getOriginalColumn(currentLineLength) > this.syntaxPoints.getLineText(currentLine).length() + 1) {
                Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").finest("skipped syntax Point due to wrong offset: " + (currentSyntaxPoint.isBegin() ? "begin " : "end ") + currentSyntaxPoint.getType() + " " + currentSyntaxPoint.getLine() + ":" + currentSyntaxPoint.getColumn() + ":; linelength is: " + this.syntaxPoints.getLineText(currentLine).length());
                continue;
            }
            if (type.equals("TextLine") && currentSyntaxPoint.isBegin()) {
                lastSyntaxPoint = currentSyntaxPoint;
                continue;
            }
            if (type.equals("TextLine") && !currentSyntaxPoint.isBegin()) {
                if (currentSyntaxPoint.getOriginalColumn(currentLineLength) > 1 && (!this.hideHTML || inTag > 0) && shallWrite) {
                    currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                }
                if ((!currentText.toString().trim().equals("") || inTag < 1 && !this.hideHTML || inTag > 0 && shallWrite) && this.printLineNumbers) {
                    writer.print("\n");
                    if (!this.hideLineNumbers) {
                        writer.print("<a style=\"font-weight: normal; \" name=\"" + currentLine + "\" href=\"#" + currentLine + "\" class=\"lineNo\">" + currentLine + ":\t</a>");
                    }
                }
                writer.print(currentText.toString());
                currentText = new StringBuffer();
                lastSyntaxPoint = currentSyntaxPoint;
                continue;
            }
            if (!this.isTagToHighlight(type)) continue;
            if (currentSyntaxPoint.isBegin()) {
                if (++inTag > 1) {
                    lastShallWrite = shallWrite;
                    if (lastShallWrite) {
                        currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                    }
                } else if (currentSyntaxPoint.getOriginalColumn(currentLineLength) > 1 && !this.hideHTML && shallWrite) {
                    currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                }
                String tagType = lineText.substring(currentSyntaxPoint.getOriginalColumn(currentLineLength));
                if (type.equals("JspScriptlet")) {
                    if (this.hideJava) {
                        shallWrite = false;
                    } else {
                        currentText.append("<span style=\"" + SystemStyleProperties.get("JspScriptlet") + "; \">");
                    }
                } else if (type.equals("JspComment")) {
                    if (this.hideComments) {
                        shallWrite = false;
                    } else {
                        currentText.append("<span style=\"" + SystemStyleProperties.get("JspComment") + "; \">");
                    }
                } else if (type.equals("JSPSystemTag")) {
                    currentText.append("<span style=\"" + SystemStyleProperties.get("JSPSystemTag") + "; \">");
                } else if (type.equals("ExpressionLanguage")) {
                    currentText.append("<span style=\"" + SystemStyleProperties.get("ExpressionLanguage") + "; \">");
                } else {
                    if ((tagType.startsWith("mak") || tagType.startsWith("/mak")) && this.hideMakumba || (tagType.startsWith("c") || tagType.startsWith("/c")) && this.hideJSTLCore || (tagType.startsWith("fmt") || tagType.startsWith("/fmt")) && this.hideJSTLFormat) {
                        shallWrite = false;
                    }
                    if (shallWrite) {
                        for (int i = 0; i < syntaxElements.length; ++i) {
                            if (!tagType.startsWith(String.valueOf(syntaxElements[i])) && !tagType.startsWith(String.valueOf("/" + syntaxElements[i]))) continue;
                            currentText.append("<span style=\"" + taglibgSytleProperties.get(syntaxElements[i]) + "; \">");
                            break;
                        }
                    }
                }
                lastSyntaxPoint = currentSyntaxPoint;
                continue;
            }
            if (shallWrite) {
                currentText.append(this.parseLine(this.htmlEscape(lineText.substring(lastSyntaxPoint.getOriginalColumn(currentLineLength) - 1, currentSyntaxPoint.getOriginalColumn(currentLineLength) - 1))));
                currentText.append("</span>");
            }
            shallWrite = inTag > 1 ? lastShallWrite : true;
            lastSyntaxPoint = currentSyntaxPoint;
            --inTag;
        }
        this.printPageEnd(writer);
        double time = new Date().getTime() - begin.getTime();
        Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").finer("Sourcecode viewer took :" + time / 1000.0 + " seconds");
    }

    private boolean isTagToHighlight(String type) {
        return type.equals("JspTagBegin") || type.equals("JspTagEnd") || type.equals("JspTagSimple") || type.equals("ExpressionLanguage") || this.isSystemtag(type);
    }

    private boolean isSystemtag(String type) {
        return type.equals("JspComment") || type.equals("JspScriptlet") || type.equals("JSPSystemTag");
    }

    static {
        defaultTaglibProperties.put("mak", "background:#eecccc; color:green; border:red thin; font-weight: bold; ");
        defaultTaglibProperties.put("jsp", "background:lightcyan; color:green; border:red thin; font-weight: bold; ");
        defaultTaglibProperties.put("fmt", "background::chartreuse; color:green; border:red thin; font-weight: bold; ");
        defaultTaglibProperties.put("c", "background:lightblue; color:green; border:red thin; font-weight: bold; ");
        taglibgSytleProperties = new Properties();
        SystemStyleProperties = new Properties();
        DEFAULT_JSPSYSTEMTAG_STYLE = defaultTaglibProperties.getProperty("jsp");
        jspViewer.initProperties();
        syntaxKeys = taglibgSytleProperties.keySet();
    }
}

