/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.MakumbaError;
import org.makumba.ValidationDefinition;
import org.makumba.ValidationRule;
import org.makumba.devel.LineViewer;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.datadefinition.makumba.RecordParser;
import org.makumba.providers.datadefinition.makumba.validation.ComparisonValidationRule;

public class mddViewer
extends LineViewer {
    private int validationRuleCounter = 0;
    protected MakumbaError err = null;
    private static final String subFieldSeperator = "-&gt;";
    private DataDefinition dd = null;

    public mddViewer(HttpServletRequest req, HttpServlet sv) throws Exception {
        super(true, req, sv);
        URL u;
        this.setSearchLevels(false, false, false, true);
        this.virtualPath = req.getPathInfo();
        this.contextPath = req.getContextPath();
        if (this.virtualPath == null) {
            this.virtualPath = "/";
        }
        if ((u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "mdd")) == null) {
            u = RecordParser.findDataDefinitionOrDirectory(this.virtualPath, "idd");
        }
        this.readFromURL(u);
        this.virtualPath = this.virtualPath.substring(1);
        try {
            this.dd = new DataDefinitionProvider().getDataDefinition(this.virtualPath);
        }
        catch (DataDefinitionNotFoundError nf) {
        }
        catch (MakumbaError pe) {
            this.err = pe;
        }
    }

    public void footer(PrintWriter pw) throws IOException {
        if (this.err != null) {
            pw.println("<hr><a name=\"errors\"></a><pre>" + this.err.getMessage() + "</pre>");
        }
        super.footer(pw);
    }

    public String getLineTag(String s) {
        int eq;
        String ln = s.trim();
        if (!(ln.startsWith("#") || ln.startsWith("!") || ln.startsWith("=") || (eq = ln.indexOf(61)) == -1)) {
            return ln.substring(0, eq).trim();
        }
        return null;
    }

    public void printLine(PrintWriter w, String s, String toPrint) throws IOException {
        block2: {
            if (this.err != null) {
                LineNumberReader lr = new LineNumberReader(new StringReader(this.err.getMessage()));
                String e = null;
                String before = null;
                do {
                    before = e;
                    e = lr.readLine();
                    if (e == null) break block2;
                } while (e.length() <= 0 || !e.equals(s));
                w.print("<span style=\"background-color: pink;\">");
                super.printLine(w, s, e);
                w.print("</span>\t<span style=\"color:red;\">" + lr.readLine() + " " + before.substring(before.indexOf(58) + 1) + "</span>\r\n");
                return;
            }
        }
        super.printLine(w, s, toPrint);
    }

    public void intro(PrintWriter w) {
        if (this.err != null) {
            w.print("<td align=\"center\" style=\"color: red;\">errors!<br><a href=\"#errors\">details</a></td>");
        }
        String browsePath = this.virtualPath.replace('.', '/').substring(0, this.virtualPath.lastIndexOf(46) + 1);
        w.println("<td align=\"right\" valign=\"top\" style=\"padding: 5px; padding-top: 10px\">");
        w.print("<span style=\"color:lightblue; background-color: darkblue; padding: 5px;\">mdd</span>&nbsp;&nbsp;&nbsp;");
        if (this.dd != null) {
            w.print("<a style=\"color: darkblue;\" href=\"" + this.contextPath + "/codeGenerator/" + this.virtualPath + "\">code generator</a>&nbsp;&nbsp;&nbsp;");
        } else {
            w.print("<span style=\"color:gray;\" title=\"Fix the errors in the MDD first!\">code generator</span>&nbsp;&nbsp;&nbsp;");
        }
        w.print("<a style=\"color: darkblue;\" href=\"" + browsePath + "\">browse</a>&nbsp;&nbsp;&nbsp;");
        w.println("</td>");
    }

    public String parseLine(String s) {
        StringBuffer result = new StringBuffer();
        String closeLine = "";
        if (RecordParser.isValidationRule(s)) {
            return this.parseValidationLine(s);
        }
        if (RecordParser.isFunction(s)) {
            return this.parseFunctionLine(s);
        }
        s = this.htmlEscape(s);
        block5: for (int current = 0; current < s.length(); ++current) {
            switch (s.charAt(current)) {
                case '=': {
                    result.append("<span style=\"color:black\">=</span><span style=\"color:#0000AA\">");
                    closeLine = "</span>" + closeLine;
                    continue block5;
                }
                case '#': {
                    result.append("<span style=\"background:#eeeeee; color:#777777\">#");
                    closeLine = "</span>" + closeLine;
                    continue block5;
                }
                case ';': {
                    String substring = s.substring(current - subFieldSeperator.length() + 1, current + 1);
                    if (current > subFieldSeperator.length() && substring.equals(subFieldSeperator)) {
                        result.append(";<span class=\"mddSubFieldSeparator\">");
                    } else {
                        result.append(";<span class=\"mddComment\">");
                    }
                    closeLine = "</span>" + closeLine;
                    continue block5;
                }
                default: {
                    result.append(s.charAt(current));
                }
            }
        }
        return super.parseLine(result.toString() + closeLine);
    }

    private String parseFunctionLine(String s) {
        StringBuffer result = new StringBuffer();
        result.append("<span name=\"mddFunction\" class=\"mddFunction\">");
        int commentBegin = s.indexOf(";");
        if (commentBegin == -1) {
            commentBegin = s.length();
        }
        String name = this.htmlEscape(s.substring(0, s.indexOf("(")));
        String params = this.htmlEscape(s.substring(s.indexOf("("), s.indexOf(")") + 1));
        String definition = this.htmlEscape(s.substring(s.indexOf(")") + 1, s.indexOf(":")));
        String message = this.htmlEscape(s.substring(s.indexOf(":"), commentBegin));
        result.append("<span class=\"mddFunctionName\">" + name + "</span>");
        result.append("<span class=\"mddFunctionParams\">" + params + "</span>");
        result.append("<span class=\"mddFunctionDefinition\">" + definition + "</span>");
        result.append("<span class=\"mddFunctionMessage\">" + message + "</span>");
        if (s.indexOf(";") != -1) {
            result.append("<span class=\"mddComment\">" + this.htmlEscape(s.substring(commentBegin)) + "</span>");
        }
        result.append("</span>");
        return super.parseLine(result.toString());
    }

    public String parseValidationLine(String s) {
        ++this.validationRuleCounter;
        StringBuffer result = new StringBuffer();
        result.append("<span name=\"validationRule\" class=\"mddValidationLine\">");
        boolean endsWithComment = false;
        String ruleName = s.trim();
        StringTokenizer tokenizer = new StringTokenizer(s, " ", true);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            ValidationDefinition vd = this.dd.getValidationDefinition();
            if (vd != null && vd.getRulesSyntax().contains(token.trim())) {
                result.append("<span style=\"color:blue; font-weight: bold;\">" + this.htmlEscape(token) + "</span>");
                continue;
            }
            if (token.equals(";")) {
                endsWithComment = true;
                result.append("</span> <span style=\"color:green\">" + this.htmlEscape(token) + this.htmlEscape(tokenizer.nextToken("")) + "</span>");
                continue;
            }
            if (token.trim().startsWith("$now") || token.trim().startsWith("date(")) {
                ValidationRule rule;
                Object value = "Error retrieving value!";
                if (ruleName != null && this.dd != null && vd != null && (rule = vd.getValidationRule(ruleName)) != null && rule instanceof ComparisonValidationRule && ((ComparisonValidationRule)rule).isCompareToExpression()) {
                    value = ((ComparisonValidationRule)rule).evaluateExpression();
                }
                String id = "validationRule" + this.validationRuleCounter;
                result.append("<a class=\"mddDateFunction\" title=\"" + value + "\" onclick=\"javascript:toggleDateFunctionDisplay(" + id + ");\">");
                result.append(this.htmlEscape(token));
                if (token.trim().startsWith("date(")) {
                    while ((token = tokenizer.nextToken()).indexOf(")") == -1) {
                        result.append(this.htmlEscape(token));
                    }
                    result.append(this.htmlEscape(token));
                }
                result.append("</a>");
                result.append("<span id=\"" + id + "\" class=\"mddDateFunctionEvaluated\" style=\"display:none;\"> [" + value + "]</span>");
                continue;
            }
            result.append(this.htmlEscape(token));
        }
        if (!endsWithComment) {
            result.append("</span>");
        }
        result.append("</span>");
        return super.parseLine(result.toString());
    }

    protected void writeAdditionalLinks(PrintWriter w) {
        if (this.dd != null && this.dd.getValidationDefinition() != null && this.dd.getValidationDefinition().hasValidationRules()) {
            w.println("<a href=\"javascript:toggleValidtionRuleDisplay();\">Hide validation rules</a>");
        }
        if (this.dd != null && this.dd.getFunctions().size() > 0) {
            w.println("<a href=\"javascript:toggleFunctionDisplay();\">Hide functions</a>");
        }
    }
}

