/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.makumba.CompositeValidationException;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.Transaction;
import org.makumba.commons.StringUtils;
import org.makumba.forms.html.FieldEditor;
import org.makumba.forms.html.RecordEditor;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.validation.ClientsideValidationProvider;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;

public class FormResponder
extends Responder {
    private static final long serialVersionUID = 1L;
    RecordEditor editor;
    Hashtable<String, Integer> indexes = new Hashtable();
    DataDefinition dd = new DataDefinitionProvider().getVirtualDataDefinition("Form responder");
    int max = 0;
    Hashtable<String, Dictionary> fieldParameters = new Hashtable();
    Hashtable<String, String> fieldNames = new Hashtable();
    protected String action;
    protected String method = "GET";
    protected boolean multipart;
    StringBuffer extraFormatting;
    private ClientsideValidationProvider provider = MakumbaSystem.getClientsideValidationProvider();

    public Dictionary getHttpData(HttpServletRequest req, String suffix) {
        if (this.editor != null) {
            return this.editor.readFrom(req, suffix, !this.operation.equals("search"));
        }
        return new Hashtable(1);
    }

    public ArrayList getUnassignedExceptions(CompositeValidationException e, ArrayList unassignedExceptions, String suffix) {
        if (this.editor != null) {
            return this.editor.getUnassignedExceptions(e, unassignedExceptions, suffix);
        }
        return null;
    }

    public String format(String fname, FieldDefinition ftype, Object fval, Dictionary formatParams, String extraFormatting) {
        Dictionary paramCopy = (Dictionary)((Hashtable)formatParams).clone();
        FieldEditor.setSuffix(paramCopy, this.storedSuffix);
        FieldEditor.setExtraFormatting(paramCopy, extraFormatting);
        boolean display = formatParams.get("org.makumba.noDisplay") == null;
        Integer i = this.indexes.get(fname);
        if (i != null) {
            return display ? this.editor.format(i, fval, paramCopy) : "";
        }
        this.indexes.put(fname, new Integer(this.max));
        String colName = "col" + this.max;
        this.fieldNames.put(colName, fname);
        this.fieldParameters.put(colName, formatParams);
        this.dd.addField(new DataDefinitionProvider().makeFieldWithName(colName, ftype));
        this.editor = new RecordEditor(this.dd, this.fieldNames, this.database);
        this.editor.config();
        if (!this.operation.equals("search") && StringUtils.equals(this.clientSideValidation, new String[]{"true", "live"})) {
            this.provider.initField(fname, ftype, this.clientSideValidation.equals("live"));
        }
        ++this.max;
        return display ? this.editor.format(this.max - 1, fval, paramCopy) : "";
    }

    public String responderKey() {
        return "" + this.fieldNames + this.fieldParameters + super.responderKey();
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setExtraFormatting(StringBuffer extraFormatting) {
        this.extraFormatting = extraFormatting;
    }

    public void writeFormPreamble(StringBuffer sb, String basePointer) {
        if (!this.storedSuffix.equals("")) {
            return;
        }
        String sep = this.action.indexOf(63) >= 0 ? "&" : "?";
        String actionBase = this.action;
        String actionAnchor = "";
        int actionHashPos = this.action.indexOf(35);
        if (actionHashPos > -1) {
            actionBase = this.action.substring(0, actionHashPos);
            actionAnchor = this.action.substring(actionHashPos);
        }
        if (this.operation.equals("deleteLink")) {
            sb.append("<a href=\"").append(actionBase).append(sep).append("__makumba__base__").append("=").append(basePointer).append('&').append("__makumba__responder__").append("=").append(this.getPrototype()).append(actionAnchor).append("\" ").append(this.extraFormatting).append(">");
        } else if (this.operation.equals("deleteForm")) {
            sb.append("<form action=").append("\"").append(actionBase).append(actionAnchor).append("\"");
            sb.append(" method=").append("\"").append(this.method).append("\"");
            if (this.multipart) {
                sb.append(" enctype=\"multipart/form-data\" ");
            }
            sb.append(this.extraFormatting);
            sb.append(">");
            sb.append("<input type=\"submit\" ").append("value=\"");
        } else {
            StringBuffer onSubmitValidation;
            sb.append("<form action=");
            sb.append("\"" + this.action + "\"");
            sb.append(" method=");
            sb.append("\"" + this.method + "\"");
            if (this.multipart) {
                sb.append(" enctype=\"multipart/form-data\" ");
            }
            if (!this.operation.equals("search") && StringUtils.equals(this.clientSideValidation, new String[]{"true", "live"}) && (onSubmitValidation = this.provider.getOnSubmitValidation(StringUtils.equals(this.clientSideValidation, "live"))) != null && onSubmitValidation.length() > 0) {
                sb.append(" onsubmit=\"return ");
                sb.append(onSubmitValidation);
                sb.append("\"");
            }
            sb.append(this.extraFormatting);
            sb.append(">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFormPostamble(StringBuffer sb, String basePointer, HttpServletRequest request) {
        String session = request.getSession().getId();
        this.factory.setResponderWorkingDir(request);
        if (this.storedSuffix.equals("") && this.operation.equals("deleteLink")) {
            sb.append("</a>");
            return;
        }
        if (this.storedSuffix.equals("") && this.operation.equals("deleteForm")) {
            sb.append("\"/>");
        }
        if (basePointer != null) {
            this.writeInput(sb, "__makumba__base__", basePointer, this.storedSuffix);
        }
        String responderValue = this.getPrototype() + this.storedSuffix + this.storedParentSuffix;
        String formSessionValue = responderValue + session;
        if (!this.operation.equals("search") && this.reloadFormOnError) {
            String url = request.getRequestURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                if (queryString.indexOf("__makumba__originatingPage__") > 0) {
                    queryString = queryString.substring(0, queryString.indexOf("__makumba__originatingPage__") - 1);
                }
                url = url + "?" + queryString;
            }
            this.writeInput(sb, "__makumba__originatingPage__", url, "");
            sb.append('\n');
        }
        this.writeInput(sb, "__makumba__responder__", responderValue, "");
        if (this.multipleSubmitErrorMsg != null && !this.multipleSubmitErrorMsg.equals("")) {
            sb.append('\n');
            this.writeInput(sb, "__makumba__formSession__", formSessionValue, "");
            Transaction db = new TransactionProvider().getConnectionTo(this.database);
            try {
                Hashtable<String, String> p = new Hashtable<String, String>();
                ((Dictionary)p).put("formSession", formSessionValue);
                db.insert("org.makumba.controller.MultipleSubmit", p);
            }
            finally {
                db.close();
            }
        }
        if (this.storedSuffix.equals("")) {
            sb.append("\n</form>");
        }
    }

    void writeInput(StringBuffer sb, String name, String value, String suffix) {
        sb.append("<input type=\"hidden\" name=\"").append(name).append(suffix).append("\" value=\"").append(value).append("\">");
    }

    protected void postDeserializaton() {
        if (this.editor != null) {
            this.editor.initFormatters();
        }
    }

    public void writeClientsideValidation(StringBuffer sb) {
        sb.append(this.provider.getClientValidation(this.clientSideValidation.equals("live")));
    }
}

