/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.html;

import java.net.URLEncoder;
import java.util.Dictionary;
import org.makumba.HtmlUtils;
import org.makumba.MakumbaSystem;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.InvalidValueException;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.list.html.FieldViewer;

public class textViewer
extends FieldViewer {
    static String[] params = new String[]{"default", "empty", "lineSeparator", "longLineLength", "html", "format"};
    static String[][] paramValues = new String[][]{null, null, null, null, {"true", "false", "auto"}, {"raw", "htmlescape", "urlencode", "wiki", "auto"}};
    static int screenLength = 30;

    public String[] getAcceptedParams() {
        return params;
    }

    public String[][] getAcceptedValue() {
        return paramValues;
    }

    private textViewer() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String formatNotNull(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        int n;
        String txt = o.toString();
        String html = (String)formatParams.get("html");
        String format = (String)formatParams.get("format");
        if (html != null && format != null) {
            throw new InvalidValueException(rf.expr[fieldIndex], "invalid combination of parameters 'html' and 'format'. 'html' is deprecated, please use only 'format'.");
        }
        if (this.equals(html, "true") || this.equals(format, "raw") || this.equals(html, "auto") && HtmlUtils.detectHtml(txt) || this.equals(format, "auto") && HtmlUtils.detectHtml(txt)) {
            return txt;
        }
        if (this.equals(html, "wiki") || this.equals(format, "wiki")) {
            return MakumbaSystem.getWikiFormatter().wiki2html(txt);
        }
        if (this.equals(format, "urlencode")) {
            return URLEncoder.encode(txt);
        }
        String startSeparator = "<p>";
        String endSeparator = "</p>";
        String s = (String)formatParams.get("lineSeparator");
        if (s != null) {
            startSeparator = s;
            endSeparator = "";
        }
        if ((n = this.getIntParam(rf, fieldIndex, formatParams, "longLineLength")) == -1) {
            n = screenLength;
        }
        if (HtmlUtils.maxLineLength(txt) > n) {
            return HtmlUtils.text2html(txt, startSeparator, endSeparator);
        }
        if (txt.indexOf(10) < 0) {
            return HtmlUtils.string2html(txt);
        }
        return "<pre style=\"margin:0px\">" + HtmlUtils.string2html(txt) + "</pre>";
    }

    private static final class SingletonHolder {
        static final FieldFormatter singleton = new textViewer();

        private SingletonHolder() {
        }
    }
}

