/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.db.TransactionImplementation;
import org.makumba.providers.DataDefinitionProvider;

public abstract class CRUDOperationProvider {
    protected DataDefinitionProvider ddp = new DataDefinitionProvider();

    public abstract Pointer insert(Transaction var1, String var2, Dictionary var3);

    public Dictionary read(Transaction t, Pointer ptr, Object fields) {
        return t.read(ptr, fields);
    }

    public void update(Transaction t, Pointer ptr, Dictionary data) {
        t.update(ptr, data);
    }

    public void delete(Transaction t, Pointer ptr) {
        ((TransactionImplementation)t).delete1(ptr);
    }

    public void updateSet(Transaction t, Pointer base, FieldDefinition fi, Object val) {
        if (!(fi.getType().equals("set") || fi.getType().equals("setintEnum") || fi.getType().equals("setcharEnum"))) {
            throw new InvalidFieldTypeException(fi, "set");
        }
        this.deleteSet(t, base, fi);
        if (val == null || val == Pointer.NullSet || ((Vector)val).size() == 0) {
            return;
        }
        this.updateSet1(t, base, fi, val);
    }

    public void updateSet1(Transaction t, Pointer base, FieldDefinition fi, Object val) {
        Vector values = (Vector)val;
        Hashtable<String, Pointer> data = new Hashtable<String, Pointer>(10);
        ((Dictionary)data).put(fi.getSubtable().getSetOwnerFieldName(), base);
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            ((Dictionary)data).put(fi.getSubtable().getSetMemberFieldName(), (Pointer)e.nextElement());
            this.insert(t, fi.getSubtable().getName(), data);
        }
    }

    public void deleteSet(Transaction t, Pointer base, FieldDefinition fi) {
        TransactionImplementation t1 = (TransactionImplementation)t;
        t.update(t1.transformTypeName(fi.getSubtable().getName()) + " this", null, "this." + fi.getSubtable().getSetOwnerFieldName() + t1.getPrimaryKeyName() + "=" + t1.getParameterName(), base);
    }

    public abstract void checkInsert(Transaction var1, String var2, Dictionary var3, Dictionary var4, Dictionary var5);

    public abstract void checkUpdate(Transaction var1, String var2, Pointer var3, Dictionary var4, Dictionary var5, Dictionary var6);

    protected DataDefinition checkUpdate(String type, Dictionary fieldsToCheck, Dictionary fieldsToIgnore) {
        DataDefinition dd = this.ddp.getDataDefinition(type);
        dd.checkFieldNames(fieldsToCheck);
        Enumeration e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (fieldsToIgnore.get(name) != null) continue;
            dd.checkUpdate(name, fieldsToCheck);
        }
        return dd;
    }

    public abstract void update1(Transaction var1, Pointer var2, DataDefinition var3, Dictionary var4);
}

