/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.commons.ClassResource;
import org.makumba.providers.DataDefinitionProviderInterface;
import org.makumba.providers.datadefinition.makumba.FieldInfo;
import org.makumba.providers.datadefinition.makumba.RecordInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakumbaDataDefinitionFactory
implements DataDefinitionProviderInterface {
    @Override
    public DataDefinition getDataDefinition(String typeName) {
        return RecordInfo.getRecordInfo(typeName.replaceAll("__", "->"));
    }

    @Override
    public DataDefinition getVirtualDataDefinition(String name) {
        return new RecordInfo(name.replaceAll("__", "->"));
    }

    @Override
    public FieldDefinition makeFieldDefinition(String name, String definition) {
        return FieldInfo.getFieldInfo(name.replaceAll("__", "->"), definition.replaceAll("__", "->"), true);
    }

    @Override
    public FieldDefinition makeFieldOfType(String name, String type) {
        return FieldInfo.getFieldInfo(name.replaceAll("__", "->"), type.replaceAll("__", "->"), false);
    }

    @Override
    public FieldDefinition makeFieldOfType(String name, String type, String description) {
        return FieldInfo.getFieldInfo(name.replaceAll("__", "->"), type.replaceAll("__", "->"), false, description);
    }

    @Override
    public FieldDefinition makeFieldWithName(String name, FieldDefinition type) {
        return FieldInfo.getFieldInfo(name, type, false);
    }

    @Override
    public FieldDefinition makeFieldWithName(String name, FieldDefinition type, String description) {
        return FieldInfo.getFieldInfo(name, type, false, description);
    }

    @Override
    public Vector getDataDefinitionsInLocation(String location) {
        return this.mddsInDirectory(location);
    }

    private Vector mddsInDirectory(String dirInClasspath) {
        Vector<String> mdds = new Vector<String>();
        try {
            URL u = ClassResource.get(dirInClasspath);
            File dir = new File(u.toURI());
            this.fillMdds(dir.toString().length() + 1, dir, mdds);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return mdds;
    }

    private void fillMdds(int baselength, File dir, Vector<String> mdds) {
        if (dir.isDirectory()) {
            String[] list = dir.list();
            for (int i = 0; i < list.length; ++i) {
                String s = list[i];
                if (s.endsWith(".mdd")) {
                    s = dir.toString() + File.separatorChar + s;
                    s = s.substring(baselength, s.length() - 4);
                    s = s.replace(File.separatorChar, '.');
                    mdds.add(s);
                    continue;
                }
                File f = new File(dir, s);
                if (!f.isDirectory()) continue;
                this.fillMdds(baselength, f, mdds);
            }
        }
    }
}

