/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba.validation;

import java.util.regex.Pattern;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.ValidationDefinitionParseError;
import org.makumba.commons.RegExpUtils;
import org.makumba.providers.datadefinition.makumba.validation.RangeValidationRule;

public class NumberRangeValidationRule
extends RangeValidationRule {
    private static final String operator = "range";
    private static final long serialVersionUID = 1L;

    public static String getOperator() {
        return operator;
    }

    public NumberRangeValidationRule(FieldDefinition fd, String fieldName, String ruleName, String errorMessage, String lowerLimitString, String upperLimitString) throws ValidationDefinitionParseError {
        super(fd, fieldName, errorMessage, ruleName, NUMBER_TYPES, lowerLimitString, upperLimitString);
        this.lowerLimit = lowerLimitString.equals("?") ? new Double(Double.MIN_VALUE) : Double.valueOf(lowerLimitString);
        this.upperLimit = upperLimitString.equals("?") ? new Double(Double.MAX_VALUE) : Double.valueOf(upperLimitString);
    }

    private NumberRangeValidationRule() {
    }

    public boolean validate(Object value) throws InvalidValueException {
        if (!(value instanceof Number)) {
            return false;
        }
        if (this.lowerLimit.doubleValue() <= ((Number)value).doubleValue() && ((Number)value).doubleValue() <= this.upperLimit.doubleValue()) {
            return true;
        }
        this.throwException();
        return false;
    }

    public String toString() {
        return "" + this.fieldName + " " + NumberRangeValidationRule.getOperator() + " [" + this.lowerLimitString + ".." + this.upperLimitString + "]";
    }

    public static String getAcceptedRules() {
        return "\\[(\\d+|\\?)\\.\\.(\\d+|\\?)\\]";
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile(NumberRangeValidationRule.getAcceptedRules());
        String[] rules = new String[]{"someField%range=[1..20]", "someField%range=[?..500]", "someField%rrnge=[?..500]", "age%range = [12..99]"};
        rules = new String[]{"[12..99]"};
        RegExpUtils.evaluate(p, rules);
    }
}

