/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.commons.RegExpUtils;
import org.makumba.providers.datadefinition.makumba.validation.SingleFieldValidationRule;

public class RegExpValidationRule
extends SingleFieldValidationRule {
    private static final String operator = "matches";
    private static final String rule = RegExpValidationRule.compileRule("matches", "([^\\s]+)");
    private static final Pattern pattern = Pattern.compile(RegExpValidationRule.getAcceptedRules());
    private static final long serialVersionUID = 1L;
    private String regExp;
    private Pattern regExpPattern;

    public static String getOperator() {
        return operator;
    }

    public RegExpValidationRule(FieldDefinition fd, String fieldName, String ruleName, String errorMessage, String regExp) {
        super(fd, fieldName, errorMessage, ruleName, STRING_TYPES);
        this.regExp = regExp;
        this.regExpPattern = Pattern.compile(regExp);
        if (fd.getIntegerType() == 6 || fd.getIntegerType() != 8) {
            // empty if block
        }
    }

    private RegExpValidationRule() {
    }

    public boolean validate(Object value) throws InvalidValueException {
        if (!(value instanceof String)) {
            return false;
        }
        Matcher matcher = this.regExpPattern.matcher((String)value);
        if (!matcher.matches()) {
            this.throwException();
            return false;
        }
        return true;
    }

    public String toString() {
        return this.fieldName + " " + RegExpValidationRule.getOperator() + " " + this.regExp;
    }

    public static String getAcceptedRules() {
        return rule;
    }

    public static Matcher getMatcher(String rule) {
        return pattern.matcher(rule);
    }

    public static boolean matches(String rule) {
        return RegExpValidationRule.getMatcher(rule).matches();
    }

    public static void main(String[] args) {
        System.out.println(RegExpValidationRule.getAcceptedRules());
        Pattern p = Pattern.compile(RegExpValidationRule.getAcceptedRules());
        String[] rules = new String[]{"someField%matches=abc", "someField%matches=abc", "someField%matches=fsgd"};
        RegExpUtils.evaluate(p, rules);
    }

    public String getRegExp() {
        return this.regExp;
    }
}

