/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba.validation;

import java.util.regex.Pattern;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.Text;
import org.makumba.commons.RegExpUtils;
import org.makumba.providers.datadefinition.makumba.validation.RangeValidationRule;

public class StringLengthValidationRule
extends RangeValidationRule {
    private static final String operator = "length";
    private static final long serialVersionUID = 1L;

    public static String getOperator() {
        return operator;
    }

    public StringLengthValidationRule(FieldDefinition fd, String fieldName, String ruleName, String errorMessage, String lowerLimitString, String upperLimitString) {
        super(fd, fieldName, errorMessage, ruleName, STRING_TYPES, lowerLimitString, upperLimitString);
        this.lowerLimit = lowerLimitString.equals("?") ? new Integer(0) : Integer.valueOf(lowerLimitString);
        this.upperLimit = upperLimitString.equals("?") ? new Integer(Integer.MAX_VALUE) : Integer.valueOf(upperLimitString);
    }

    private StringLengthValidationRule() {
    }

    public boolean validate(Object value) throws InvalidValueException {
        if (!(value instanceof String) && !(value instanceof Text)) {
            return false;
        }
        String s = value.toString();
        if (this.lowerLimit.intValue() <= s.length() && s.length() <= this.upperLimit.intValue()) {
            return true;
        }
        this.throwException();
        return false;
    }

    public String toString() {
        return "" + this.fieldName + " " + StringLengthValidationRule.getOperator() + " [" + this.lowerLimitString + ".." + this.upperLimitString + "]";
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile(StringLengthValidationRule.getAcceptedRules());
        String[] rules = new String[]{"someField length [1..20]", "someField length [?..500]", "someField llngth [?..500]"};
        RegExpUtils.evaluate(p, rules);
    }
}

