/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.hql;

import antlr.RecognitionException;
import antlr.SemanticException;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.FieldDefinition;
import org.makumba.ProgrammerError;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.hql.ObjectType;

public class MddObjectType
implements ObjectType {
    private DataDefinitionProvider ddp = new DataDefinitionProvider();

    public Object determineType(String type, String field) throws RecognitionException, SemanticException {
        if (field == null) {
            try {
                this.ddp.getDataDefinition(type);
                return type;
            }
            catch (DataDefinitionNotFoundError err) {
                return null;
            }
        }
        DataDefinition dd = null;
        if (field.equals("id")) {
            return type;
        }
        try {
            dd = this.ddp.getDataDefinition(type);
        }
        catch (DataDefinitionNotFoundError e) {
            throw new ProgrammerError("No such MDD \"" + type + "\"");
        }
        if (field.equals("enum_") && dd.getFieldDefinition("enum") != null) {
            return dd.getFieldDefinition("enum");
        }
        FieldDefinition fi = dd.getFieldDefinition(field);
        if (fi == null) {
            throw new ProgrammerError("No such field \"" + field + "\" in Makumba type \"" + dd.getName() + "\"");
        }
        DataDefinition foreign = null;
        DataDefinition sub = null;
        try {
            foreign = fi.getForeignTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sub = fi.getSubtable();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fi.getType().equals("ptr")) {
            return foreign.getName();
        }
        if (fi.getType().equals("ptrOne")) {
            return sub.getName();
        }
        if (fi.getType().equals("setComplex") || fi.getType().equals("setintEnum") || fi.getType().equals("setcharEnum")) {
            return sub.getName();
        }
        if (fi.getType().equals("set")) {
            return this.ddp.getDataDefinition(foreign.getName()).getName();
        }
        return this.ddp.getDataDefinition(type).getFieldDefinition(field);
    }

    public int getTypeOf(Object descriptor) {
        return ((FieldDefinition)descriptor).getIntegerType();
    }
}

