/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;

public class ShowResources {
    public static void main(String[] args) throws Exception {
        List resources = ShowResources.listResources(ShowResources.class.getClassLoader());
        if (args.length == 0) {
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                System.out.println(((URL)iter.next()).toExternalForm());
            }
        } else {
            block1: for (URL url : resources) {
                String urlString = url.toExternalForm();
                for (int i = 0; i < args.length; ++i) {
                    if (urlString.indexOf(args[i]) == -1) continue;
                    System.out.println("Found resource: " + urlString);
                    System.out.println("First few chars: " + ShowResources.readAFewChars(url));
                    System.out.println();
                    continue block1;
                }
            }
        }
    }

    private static List listResources(ClassLoader cl) throws IOException, MalformedURLException {
        ArrayList resources = new ArrayList();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)cl;
                URL[] urls = ucl.getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    File file;
                    URL url = urls[i];
                    if (url.getFile().endsWith(".jar")) {
                        ShowResources.listJarResources(new URL("jar:" + url.toExternalForm() + "!/"), resources);
                        continue;
                    }
                    if (!url.getProtocol().equals("file") || !(file = new File(url.getFile())).isDirectory()) continue;
                    ShowResources.listDirResources(file, resources);
                }
            }
            cl = cl.getParent();
        }
        return resources;
    }

    private static void listDirResources(File dir, List resources) throws MalformedURLException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            resources.add(file.toURL());
            if (!file.isDirectory()) continue;
            ShowResources.listDirResources(file, resources);
        }
    }

    private static void listJarResources(URL jarUrl, List resources) throws IOException, MalformedURLException {
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        Enumeration<JarEntry> entries = jarConnection.getJarFile().entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            resources.add(new URL(jarUrl, entry.getName()));
        }
    }

    private static String readAFewChars(URL url) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer(10);
        InputStreamReader reader = new InputStreamReader(url.openStream());
        for (int i = 0; i < 10 && (c = ((Reader)reader).read()) != -1; ++i) {
            buf.append((char)c);
        }
        ((Reader)reader).close();
        return buf.toString();
    }
}

