/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MddToClass {
    public String generatedClassPath = "";
    private List mddsDone = new ArrayList();
    private LinkedList mddsToDo = new LinkedList();
    private LinkedList appendToClass = new LinkedList();
    private DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    private NameResolver nr;

    public MddToClass(Vector<String> v, String generationPath, NameResolver nr) throws CannotCompileException, NotFoundException, IOException {
        this.nr = nr;
        this.generatedClassPath = generationPath;
        for (int i = 0; i < v.size(); ++i) {
            this.generateClass(this.ddp.getDataDefinition(v.elementAt(i)));
            v.set(i, nr.arrowToDoubleUnderscore(v.get(i)));
        }
        while (!this.mddsToDo.isEmpty()) {
            DataDefinition first = (DataDefinition)this.mddsToDo.removeFirst();
            String name = nr.arrowToDoubleUnderscore(first.getName());
            if (!v.contains(name)) {
                v.add(name);
            }
            this.generateClass(first);
        }
        while (!this.appendToClass.isEmpty()) {
            Object[] append = (Object[])this.appendToClass.removeFirst();
            this.appendClass((String)append[0], (FieldDefinition)append[1]);
        }
    }

    public MddToClass(DataDefinition dd, String generationPath) throws CannotCompileException, NotFoundException, IOException {
        this.generatedClassPath = generationPath;
        this.generateClass(dd);
        while (!this.mddsToDo.isEmpty()) {
            this.generateClass((DataDefinition)this.mddsToDo.removeFirst());
        }
        while (!this.appendToClass.isEmpty()) {
            Object[] append = (Object[])this.appendToClass.removeFirst();
            this.appendClass((String)append[0], (FieldDefinition)append[1]);
        }
    }

    public void appendClass(String classname, FieldDefinition fd) throws NotFoundException, CannotCompileException, IOException {
        ClassPool cp = ClassPool.getDefault();
        cp.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
        CtClass cc = cp.get(classname);
        cc.defrost();
        String type = null;
        String name = fd.getName();
        switch (fd.getIntegerType()) {
            case 0: 
            case 2: {
                type = this.nr.arrowToDoubleUnderscore(fd.getPointedType().getName());
                break;
            }
            case 12: {
                type = "java.util.Collection";
            }
        }
        name = this.nr.checkReserved(name);
        cc.addField(CtField.make((String)("private " + type + " " + name + ";"), (CtClass)cc));
        cc.addMethod(CtNewMethod.getter((String)("get" + name), (CtField)CtField.make((String)("private " + type + " " + name + ";"), (CtClass)cc)));
        cc.addMethod(CtNewMethod.setter((String)("set" + name), (CtField)CtField.make((String)("private " + type + " " + name + ";"), (CtClass)cc)));
        cc.writeFile(this.generatedClassPath);
    }

    public void generateClass(DataDefinition dd) throws CannotCompileException, NotFoundException, IOException {
        if (!this.mddsDone.contains(dd.getName())) {
            this.mddsDone.add(dd.getName());
            File checkFile = new File(this.generatedClassPath + File.separator + this.nr.dotToUnderscore(this.nr.arrowToDoubleUnderscore(dd.getName())) + "_.class");
            if (checkFile.exists() && dd.lastModified() < checkFile.lastModified()) {
                return;
            }
            ClassPool cp = ClassPool.getDefault();
            cp.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
            CtClass cc = cp.makeClass(this.nr.arrowToDoubleUnderscore(dd.getName()));
            cc.stopPruning(true);
            String type = null;
            String name = null;
            block15: for (int i = 0; i < dd.getFieldNames().size(); ++i) {
                Object[] append = new Object[2];
                FieldDefinition fd = dd.getFieldDefinition(i);
                name = this.nr.arrowToDoubleUnderscore(fd.getName());
                switch (fd.getIntegerType()) {
                    case 4: 
                    case 5: {
                        type = "Integer";
                        break;
                    }
                    case 15: {
                        type = "Double";
                        break;
                    }
                    case 6: 
                    case 7: {
                        type = "String";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        type = "java.util.Date";
                        break;
                    }
                    case 0: 
                    case 2: {
                        this.mddsToDo.add(fd.getPointedType());
                        append[0] = this.nr.arrowToDoubleUnderscore(dd.getName());
                        append[1] = fd;
                        this.appendToClass.add(append);
                        continue block15;
                    }
                    case 1: {
                        name = fd.getName();
                        type = fd.getPointedType().getName();
                        break;
                    }
                    case 3: {
                        name = "primaryKey";
                        type = "int";
                        break;
                    }
                    case 8: 
                    case 18: {
                        type = "org.makumba.Text";
                        break;
                    }
                    case 19: {
                        type = "java.lang.Boolean";
                        break;
                    }
                    case 12: {
                        type = "java.util.Collection";
                        this.mddsToDo.add(fd.getPointedType());
                        this.mddsToDo.add(fd.getSubtable());
                        break;
                    }
                    case 13: 
                    case 16: 
                    case 17: {
                        type = "java.util.Collection";
                        this.mddsToDo.add(fd.getSubtable());
                        break;
                    }
                    default: {
                        try {
                            throw new Exception("Unmapped type: " + fd.getName() + "-" + fd.getType());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.addFields(cc, type, name);
            }
            String nm = dd.getName();
            int lst = nm.lastIndexOf("->");
            lst = lst != -1 ? ++lst : nm.lastIndexOf(".");
            cc.addConstructor(CtNewConstructor.make((String)("public " + nm.substring(lst + 1) + "() {}"), (CtClass)cc));
            cc.writeFile(this.generatedClassPath);
        }
    }

    private void generateIntEnum(CtClass cc, String name, FieldDefinition fd) throws CannotCompileException {
        String enumName = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        String enumCode = "public enum " + enumName + " {";
        for (int i = 0; i < fd.getEnumeratorSize(); ++i) {
            String currentIntEnumName = fd.getNameFor(i);
            Integer currentIntEnumValue = new Integer(fd.getIntAt(i));
            enumCode = enumCode + "I" + i + "(\"" + currentIntEnumName + "\", " + currentIntEnumValue + ")";
            if (i + 1 == fd.getEnumeratorSize()) continue;
            enumCode = enumCode + ",";
        }
        enumCode = enumCode + ";";
        enumCode = enumCode + "private String endUserPresentation;";
        enumCode = enumCode + "private int dbLevelValue;";
        enumCode = enumCode + enumName + "(String s, int n) {endUserPresentation=s; dbLevelValue=n;}";
        enumCode = enumCode + "}";
        cc.addMethod(CtNewMethod.make((String)enumCode, (CtClass)cc));
    }

    private void addFields(CtClass cc, String type, String name) throws CannotCompileException {
        type = this.nr.arrowToDoubleUnderscore(type);
        name = this.nr.checkReserved(this.nr.arrowToDoubleUnderscore(name));
        cc.addField(CtField.make((String)("private " + type + " " + name + ";"), (CtClass)cc));
        cc.addMethod(CtNewMethod.getter((String)("get" + name), (CtField)CtField.make((String)("private " + type + " " + name + ";"), (CtClass)cc)));
        cc.addMethod(CtNewMethod.setter((String)("set" + name), (CtField)CtField.make((String)("private " + type + " " + name + ";"), (CtClass)cc)));
    }
}

