/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.devel.LineViewer;
import org.makumba.providers.datadefinition.makumba.RecordParser;

public class errorViewer
extends LineViewer {
    private String hiddenBody;

    public errorViewer(HttpServletRequest request, ServletContext servletContext, String title, String body, String hiddenBody, boolean printHeaderFooter) throws IOException {
        super(false, request, servletContext);
        this.realPath = servletContext.getRealPath("/");
        this.printHeaderFooter = printHeaderFooter;
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(servletContext);
        this.title = title;
        this.hiddenBody = hiddenBody;
        this.reader = new StringReader(body);
    }

    public String parseLine(String s) {
        StringBuffer source = new StringBuffer(s);
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = this.getLineTokenizer(s);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            int indexOf = source.indexOf(token);
            int indexAfter = indexOf + token.length();
            result.append(source.substring(0, indexOf));
            if (token.indexOf(".") != -1) {
                Class javaClass;
                Integer lineNumber = null;
                if (this.searchMDD && RecordParser.findDataDefinition(token, "mdd") != null || RecordParser.findDataDefinition(token, "idd") != null) {
                    result.append(this.formatMDDLink(token));
                } else if (this.searchJavaClasses && (javaClass = this.findClassSimple(token)) != null) {
                    String substring = source.substring(indexAfter);
                    lineNumber = this.findLineNumber(substring);
                    result.append(this.formatClassLink(javaClass.getName(), token, lineNumber));
                } else {
                    String jspClass;
                    String jspPage;
                    javaClass = this.findClass(token);
                    if (javaClass != null) {
                        result.append(this.formatClassLink(javaClass, null, token));
                    } else if (this.searchJSPPages && (jspPage = this.findPage(token)) != null) {
                        lineNumber = this.findLineNumber(source.toString());
                        result.append(this.formatJSPLink(jspPage, token, lineNumber));
                    } else if (this.searchCompiledJSPClasses && (jspClass = this.findCompiledJSP(token)) != null) {
                        lineNumber = this.findLineNumber(source.toString());
                        result.append(this.formatClassLink(jspClass, token, lineNumber));
                    } else {
                        result.append(token);
                    }
                }
            } else {
                result.append(token);
            }
            source.delete(0, indexOf + token.length());
        }
        return result.append(source).toString();
    }

    private Integer findLineNumber(String s) {
        String beginToken = ":";
        Integer lineNr = null;
        int indexNumberBegin = s.indexOf(beginToken);
        if (indexNumberBegin == -1) {
            indexNumberBegin = s.indexOf("(");
        }
        if (indexNumberBegin != -1) {
            int indexNumberEnd;
            for (indexNumberEnd = ++indexNumberBegin; s.length() > indexNumberEnd && Character.isDigit(s.charAt(indexNumberEnd)); ++indexNumberEnd) {
            }
            String lineNumberText = s.substring(indexNumberBegin, indexNumberEnd).trim();
            if (lineNumberText.length() > 0) {
                try {
                    lineNr = Integer.valueOf(lineNumberText);
                }
                catch (NumberFormatException e) {
                    Logger.getLogger("org.makumba.devel").warning("Error in error viewer: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return lineNr;
    }

    public Class findClassSimple(String token) {
        int index = token.lastIndexOf(46);
        String className = token.substring(0, index);
        return super.findClassSimple(className);
    }

    public void footer(PrintWriter pw) throws IOException {
        if (this.hiddenBody != null) {
            pw.println("<!--\n" + this.hiddenBody + "\n-->");
        }
        super.footer(pw);
    }
}

