/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel.relations;

import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.devel.relations.RelationCrawler;
import org.makumba.devel.relations.RelationMiner;
import org.makumba.providers.DataDefinitionProvider;

public class MDDRelationMiner
extends RelationMiner {
    private static final String CLASSES_PATH = "WEB-INF/classes/";
    private static final String DEFAULT_DATADEFINITIONS_PATH = "WEB-INF/classes/dataDefinitions/";

    public MDDRelationMiner(RelationCrawler rc) {
        super(rc);
    }

    public void crawl(String path) {
        String mddPath;
        DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith(DEFAULT_DATADEFINITIONS_PATH)) {
            mddPath = path.substring(DEFAULT_DATADEFINITIONS_PATH.length());
        } else if (path.startsWith(CLASSES_PATH)) {
            mddPath = path.substring(CLASSES_PATH.length());
        } else {
            System.out.println("\nIgnoring MDD not in default MDD path (WEB-INF/classes/ or WEB-INF/classes/dataDefinitions/): " + path);
            return;
        }
        if (!new File(this.rc.getWebappRoot() + File.separator + path).exists()) {
            this.logger.warning("MDD " + mddPath + " does not exist in webapp " + this.rc.getWebappRoot());
            return;
        }
        String type = path.substring(DEFAULT_DATADEFINITIONS_PATH.length(), path.length() - 4).replace('/', '.');
        try {
            DataDefinition dd = ddp.getDataDefinition(type);
            Vector fields = dd.getFieldNames();
            for (String fieldName : fields) {
                FieldDefinition fd = dd.getFieldDefinition(fieldName);
                if (!fd.getType().equals("ptr") && !fd.getType().equals("set")) continue;
                this.addMDD2MDDRelation(path, this.typeToPath(fd.getPointedType().getName()), fd.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String typeToPath(String typeName) {
        return DEFAULT_DATADEFINITIONS_PATH + typeName.replace('.', '/') + ".mdd";
    }

    private void addMDD2MDDRelation(String fromFile, String toFile, String fromField) {
        Hashtable<String, Object> relationOrigin = new Hashtable<String, Object>();
        ((Dictionary)relationOrigin).put("field", fromField);
        this.rc.addRelation(fromFile, toFile, relationOrigin);
    }
}

