/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.makumba.MakumbaError;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.controller.Logic;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.responder.ResponderFactory;

public class ResponderCacheManager {
    private ResponderFactory factory;
    private static ResponderCacheManager instance = null;
    static Hashtable<Integer, Object> indexedCache = new Hashtable();
    public static String makumbaResponderBaseDirectory;
    static NamedResources cache;

    public static ResponderCacheManager getInstance() {
        if (instance == null) {
            instance = new ResponderCacheManager();
        }
        return instance;
    }

    static String validResponderFilename(int responderValue) {
        return new String(makumbaResponderBaseDirectory + "/") + String.valueOf(responderValue).replaceAll("-", "_");
    }

    public void setResponderWorkingDir(HttpServletRequest request) {
        if (makumbaResponderBaseDirectory == null) {
            System.out.println("had an empty responder dir - working dir ==> " + request.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir"));
            String baseDir = request.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir") + System.getProperty("file.separator") + "makumba-responders" + System.getProperty("file.separator");
            makumbaResponderBaseDirectory = baseDir + request.getContextPath();
            if (!new File(makumbaResponderBaseDirectory).exists()) {
                new File(baseDir).mkdir();
                new File(makumbaResponderBaseDirectory).mkdir();
            }
            System.out.println("base dir: " + makumbaResponderBaseDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Responder getResponder(String code, String suffix, String parentSuffix) {
        Integer i = new Integer(Integer.parseInt(code));
        Responder fr = (Responder)indexedCache.get(i);
        String fileName = ResponderCacheManager.validResponderFilename(i);
        if (fr == null) {
            ObjectInputStream objectIn = null;
            try {
                objectIn = new ObjectInputStream(new FileInputStream(fileName));
                fr = (Responder)objectIn.readObject();
                fr.postDeserializaton();
                fr.controller = Logic.getController(fr.controllerClassname);
            }
            catch (UnsupportedClassVersionError e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: could not read from file " + fileName, e);
                new File(fileName).delete();
                throw new MakumbaError("Responder cannot be re-used due to Makumba version change! Please reload this page.");
            }
            catch (InvalidClassException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: could not read from file " + fileName, e);
                new File(fileName).delete();
                throw new MakumbaError("Responder cannot be re-used due to Makumba version change! Please reload this page.");
            }
            catch (IOException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: could not read from file " + fileName, e);
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: class not found: " + fileName, e);
            }
            finally {
                if (objectIn != null) {
                    try {
                        objectIn.close();
                    }
                    catch (IOException e1) {}
                }
            }
            if (fr == null) {
                throw new MakumbaError("Responder cannot be found, probably due to server restart. Please reload this page.");
            }
        }
        return fr;
    }

    public ResponderFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ResponderFactory factory) {
        this.factory = factory;
    }

    static {
        cache = new NamedResources("controller.responders", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object getHashObject(Object o) {
                return ((Responder)o).responderKey();
            }

            public Object makeResource(Object name, Object hashName) {
                Responder f = (Responder)name;
                f.identity = hashName.hashCode();
                String fileName = ResponderCacheManager.validResponderFilename(f.identity);
                if (indexedCache.get(new Integer(f.identity)) == null) {
                    File file = new File(fileName);
                    try {
                        if (!file.exists()) {
                            f.controllerClassname = f.controller.getClass().getName();
                            ObjectOutputStream objectOut = new ObjectOutputStream(new FileOutputStream(file));
                            objectOut.writeObject(f);
                            objectOut.close();
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger("org.makumba.controller").log(Level.SEVERE, "Error while writing responder to HDD, deleting file " + fileName, e);
                        file.delete();
                    }
                }
                indexedCache.put(new Integer(f.identity), name);
                return name;
            }
        });
    }
}

