/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.AttributeNotFoundException;
import org.makumba.CompositeValidationException;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.commons.DbConnectionProvider;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.attributes.RequestAttributes;
import org.makumba.forms.responder.FormResponder;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.responder.ResponderCacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponderFactory {
    private ResponderCacheManager cacheManager = ResponderCacheManager.getInstance();
    private static ResponderFactory instance = null;
    private Comparator<Object> bySuffix = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ResponderFactory.this.suffix((String)o1).compareTo(ResponderFactory.this.suffix((String)o2));
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    };
    static Integer ZERO = new Integer(0);
    public static final String RESPONSE_STRING_NAME = "makumba.response";
    public static final String resultNamePrefix = "org.makumba.controller.resultOf_";

    public static ResponderFactory getInstance() {
        if (instance == null) {
            instance = new ResponderFactory();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.cacheManager.setFactory(this);
    }

    public Iterator<String> getResponderCodes(HttpServletRequest req) {
        TreeSet<Object> set = new TreeSet<Object>(this.bySuffix);
        Object o = RequestAttributes.getParameters(req).getParameter("__makumba__responder__");
        if (o != null) {
            if (o instanceof String) {
                set.add((String)o);
            } else {
                set.addAll((Vector)o);
            }
        }
        return set.iterator();
    }

    public Iterator<String> getOrderedResponderCodes(HttpServletRequest req) {
        Iterator<String> responderCodes = this.getResponderCodes(req);
        String[] order = null;
        while (responderCodes.hasNext()) {
            Responder responder;
            String responderCode = responderCodes.next();
            if (responderCode == null || (responder = this.getResponder(responderCode)).getFormOrder() == null) continue;
            order = responder.getFormOrder();
        }
        if (order != null) {
            return Arrays.asList(order).iterator();
        }
        return new ArrayList().iterator();
    }

    public void printOrderedResponders(HttpServletRequest req) {
        System.out.println("\nresponders ordered:");
        this.printResponderIterator(this.getOrderedResponderCodes(req));
        System.out.println("\nresponders normal:");
        this.printResponderIterator(this.getResponderCodes(req));
    }

    private void printResponderIterator(Iterator<String> order) {
        if (order == null) {
            return;
        }
        while (order.hasNext()) {
            String code = order.next();
            System.out.println("** responder code: " + code);
            if (code == null) break;
            Responder r = this.getResponder(code);
            System.out.println("** responder form name: " + r.getFormName());
            System.out.println("** responder form key:  " + r.responderKey());
        }
    }

    public String[] getSuffixes(String responderCode) {
        String suffix = "";
        String parentSuffix = null;
        int n = responderCode.indexOf(95);
        if (n != -1) {
            suffix = responderCode.substring(n);
            parentSuffix = "";
            n = suffix.indexOf(95, 1);
            if (n != -1) {
                parentSuffix = suffix.substring(n);
                suffix = suffix.substring(0, n);
            }
        }
        return new String[]{suffix, parentSuffix};
    }

    private Integer suffix(String code) {
        int n = code.indexOf(95);
        if (n == -1) {
            return ZERO;
        }
        if ((n = (code = code.substring(n + 1)).indexOf(95)) != -1) {
            code = code.substring(0, n);
        }
        return new Integer(Integer.parseInt(code));
    }

    public void setResponderWorkingDir(HttpServletRequest request) {
        this.cacheManager.setResponderWorkingDir(request);
    }

    public Responder getResponder(String code) {
        String suffix = this.getSuffixes(code)[0];
        String parentSuffix = this.getSuffixes(code)[1];
        if (suffix != "") {
            code = code.substring(0, code.indexOf(suffix));
        }
        return this.cacheManager.getResponder(code, suffix, parentSuffix);
    }

    public Responder getFirstResponder(ServletRequest req) {
        Iterator<String> responderCodes = this.getResponderCodes((HttpServletRequest)req);
        if (responderCodes.hasNext()) {
            String code = responderCodes.next();
            String suffix = "";
            String parentSuffix = null;
            int n = code.indexOf(95);
            if (n != -1) {
                suffix = code.substring(n);
                parentSuffix = "";
                n = suffix.indexOf(95, 1);
                if (n != -1) {
                    parentSuffix = suffix.substring(n);
                    suffix = suffix.substring(0, n);
                }
            }
            return this.getResponder(code);
        }
        return null;
    }

    public ArrayList<InvalidValueException> getUnassignedExceptions(CompositeValidationException e, HttpServletRequest req) {
        ArrayList<InvalidValueException> unassignedExceptions = e.getExceptions();
        Iterator<String> responderCodes = this.getResponderCodes(req);
        while (responderCodes.hasNext()) {
            String responderCode = responderCodes.next();
            String[] suffixes = this.getSuffixes(responderCode);
            this.getResponder(responderCode).getUnassignedExceptions(e, unassignedExceptions, suffixes[0]);
        }
        return unassignedExceptions;
    }

    public FormResponder createResponder() {
        FormResponder fr = new FormResponder();
        fr.setFactory(this);
        return fr;
    }

    public int getResponderIdentity(Responder responder) {
        return ((Responder)ResponderCacheManager.cache.getResource((Object)responder)).identity;
    }

    public Exception getResponse(HttpServletRequest req, HttpServletResponse resp) {
        this.setResponderWorkingDir(req);
        if (req.getAttribute(RESPONSE_STRING_NAME) != null) {
            return null;
        }
        req.setAttribute(RESPONSE_STRING_NAME, (Object)"");
        String message = "";
        Hashtable<String, Object> responderResults = new Hashtable<String, Object>();
        Iterator<String> responderCodes = this.getResponderCodes(req);
        while (responderCodes.hasNext()) {
            String code = responderCodes.next();
            String suffix = this.getSuffixes(code)[0];
            String parentSuffix = this.getSuffixes(code)[1];
            Responder formResponder = this.getResponder(code);
            try {
                ResponderFactory.checkMultipleSubmission(req, formResponder);
                Object result = formResponder.op.respondTo(req, formResponder, suffix, parentSuffix);
                if (formResponder instanceof FormResponder && result != null) {
                    responderResults.put(((FormResponder)formResponder).resultAttribute, result);
                }
                message = "<font color=green>" + formResponder.message + "</font>";
                if (result != null) {
                    req.setAttribute(formResponder.resultAttribute, result);
                    req.setAttribute(resultNamePrefix + suffix, result);
                }
                req.setAttribute("makumba.successfulResponse", (Object)"yes");
            }
            catch (AttributeNotFoundException anfe) {
                throw new RuntimeWrappedException(anfe);
            }
            catch (CompositeValidationException e) {
                req.setAttribute(formResponder.resultAttribute, Pointer.Null);
                req.setAttribute(resultNamePrefix + suffix, Pointer.Null);
                return e;
            }
            catch (LogicException e) {
                Logger.getLogger("org.makumba.logic.error").log(Level.INFO, "error", e);
                message = Responder.errorMessage(e);
                req.setAttribute(formResponder.resultAttribute, Pointer.Null);
                req.setAttribute(resultNamePrefix + suffix, Pointer.Null);
            }
            catch (Throwable t) {
                throw new RuntimeWrappedException(t);
            }
            if (!suffix.equals("")) continue;
            req.setAttribute(RESPONSE_STRING_NAME, (Object)message);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkMultipleSubmission(HttpServletRequest req, Responder fr) throws LogicException {
        String reqFormSession = (String)RequestAttributes.getParameters(req).getParameter("__makumba__formSession__");
        if (fr.multipleSubmitErrorMsg != null && !fr.multipleSubmitErrorMsg.equals("") && reqFormSession != null) {
            Transaction db = null;
            try {
                db = ((DbConnectionProvider)req.getAttribute("org.makumba.providerAttribute")).getTransactionProvider().getConnectionTo(RequestAttributes.getAttributes(req).getRequestDatabase());
                String param = ((DbConnectionProvider)req.getAttribute("org.makumba.providerAttribute")).getTransactionProvider().getQueryLanguage().equals("oql") ? "$1" : "?";
                Vector<Dictionary<String, Object>> v = db.executeQuery("SELECT ms" + (param.equals("$1") ? "" : ".id") + " FROM org.makumba.controller.MultipleSubmit ms WHERE ms.formSession=" + param, reqFormSession);
                if (v.size() == 0) {
                    throw new LogicException(fr.multipleSubmitErrorMsg);
                }
                if (v.size() >= 1) {
                    GregorianCalendar c = new GregorianCalendar();
                    c.add(10, -5);
                    Object[] params = new Object[]{reqFormSession, c.getTime()};
                    db.delete("org.makumba.controller.MultipleSubmit ms", "ms.formSession=" + param + " OR ms.TS_create<" + (param.equals("$1") ? "$2" : "?"), params);
                }
            }
            finally {
                db.close();
            }
        }
    }
}

