/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.DataDefinition;
import org.makumba.LogicException;
import org.makumba.MakumbaSystem;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.StringUtils;
import org.makumba.commons.attributes.RequestAttributes;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.controller.Logic;
import org.makumba.forms.responder.FormResponder;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.responder.ResponderFactory;
import org.makumba.forms.responder.ResponderOperation;
import org.makumba.forms.tags.DeleteTag;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.FormDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTagBase
extends GenericMakumbaTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    public String baseObject = null;
    String handler = null;
    String afterHandler = null;
    String formMethod = null;
    public String formAction = null;
    String formName = null;
    String formMessage = null;
    FormResponder responder = null;
    long starttime;
    String basePointer = null;
    BodyContent bodyContent = null;
    String annotation = "after";
    private static final String[] validAnnotationParams = new String[]{"none", "before", "after", "both"};
    private static final String[] validClientSideValidationParams = new String[]{"true", "false", "live"};
    String annotationSeparator;
    boolean reloadFormOnError = Configuration.getReloadFormOnErrorDefault();
    private String clientSideValidation = Configuration.getClientSideValidationDefault();
    protected FormDataProvider fdp;
    private ResponderFactory responderFactory = ResponderFactory.getInstance();
    protected DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    public static final String BASE_POINTER_TYPES = "org.makumba.basePointerTypes";
    private static final ResponderOperation simepleOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            return Logic.doOp(resp.getController(), resp.getHandler(), resp.getHttpData(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };

    public FormTagBase() {
        try {
            this.fdp = (FormDataProvider)Class.forName("org.makumba.list.ListFormDataProvider").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setBodyContent(BodyContent bc) {
        this.bodyContent = bc;
    }

    public void doInitBody() {
    }

    public void setObject(String s) {
        this.baseObject = s;
    }

    public void setAction(String s) {
        this.formAction = s;
    }

    public void setHandler(String s) {
        this.handler = s;
    }

    public void setAfterHandler(String s) {
        this.afterHandler = s;
    }

    public void setMethod(String s) {
        this.checkNoParent("method");
        this.formMethod = s;
    }

    public void setName(String s) {
        this.formName = s;
        this.extraFormattingParams.put("name", s);
    }

    public void setMessage(String s) {
        this.checkNoParent("message");
        this.formMessage = s;
    }

    public void setMultipart() {
        FormTagBase parent = this.findParentForm();
        if (parent != null) {
            parent.setMultipart();
        } else {
            this.responder.setMultipart(true);
        }
    }

    public void setFormOrder(MultipleKey[] order, Map<MultipleKey, String> responders) {
        FormTagBase parent = this.findParentForm();
        if (parent != null) {
            if (responders == null) {
                responders = new HashMap<MultipleKey, String>();
            }
            responders.put(this.getTagKey(), this.responder.getResponderValue());
            parent.setFormOrder(order, responders);
        } else if (this.responder.getFormOrder() == null) {
            if (responders == null) {
                responders = new HashMap<MultipleKey, String>();
            }
            responders.put(this.getTagKey(), this.responder.getResponderValue());
            String[] responderOrder = new String[responders.size()];
            int j = 0;
            for (int i = 0; i < order.length && j < responderOrder.length; ++i) {
                if (responders.get(order[i]) == null) continue;
                responderOrder[j++] = responders.get(order[i]);
            }
            this.responder.setResponderOrder(responderOrder);
        }
    }

    public void setTarget(String s) {
        this.checkNoParent("target");
        this.extraFormattingParams.put("target", s);
    }

    public void setOnReset(String s) {
        this.checkNoParent("onReset");
        this.extraFormattingParams.put("onReset", s);
    }

    public void setOnSubmit(String s) {
        this.checkNoParent("onSubmit");
        if (this.clientSideValidation != null) {
            throw new ProgrammerError("Forms specifying a 'clientSideValidation' attribute cannot provide an 'onSubmit' attribute");
        }
        this.extraFormattingParams.put("onSubmit", s);
    }

    public void setClientSideValidation(String clientSideValidation) {
        this.checkValidAttributeValues("clientSideValidation", clientSideValidation, validClientSideValidationParams);
        if (this.extraFormattingParams.get("onSubmit") != null) {
            throw new ProgrammerError("Forms specifying a 'clientSideValidation' attribute cannot provide an 'onSubmit' attribute");
        }
        this.clientSideValidation = clientSideValidation;
    }

    public void setAnnotation(String s) {
        this.checkNoParent("annotation");
        this.checkValidAttributeValues("annotation", s, validAnnotationParams);
        this.annotation = s;
    }

    public void setAnnotationSeparator(String s) {
        this.checkNoParent("annotationSeparator");
        this.annotationSeparator = s;
    }

    public void setReloadFormOnError(String s) {
        this.checkNoParent("reloadFormOnError");
        this.reloadFormOnError = s == null || !s.equals("false");
    }

    String getOperation() {
        String classname = ((Object)((Object)this)).getClass().getName();
        if (classname.endsWith("FormTagBase")) {
            return "simple";
        }
        int n = classname.lastIndexOf("Tag");
        if (n != classname.length() - 3) {
            throw new RuntimeException("the tag class name was expected to end with 'Tag': " + classname);
        }
        classname = classname.substring(0, n);
        int m = classname.lastIndexOf(".");
        return classname.substring(m + 1).toLowerCase();
    }

    public boolean shouldComputeBasePointer() {
        return this.baseObject != null;
    }

    @Override
    public void setTagKey(PageCache pageCache) {
        Object[] keyComponents = new Object[]{this.baseObject, this.handler, this.afterHandler, this.fdp.getParentListKey(this), ((Object)((Object)this)).getClass()};
        this.tagKey = new MultipleKey(keyComponents);
    }

    @Override
    public void doStartAnalyze(PageCache pageCache) {
        if (!this.shouldComputeBasePointer()) {
            return;
        }
        this.fdp.onFormStartAnalyze(this, pageCache, this.baseObject);
    }

    public FormTagBase findParentForm() {
        return (FormTagBase)FormTagBase.findAncestorWithClass((Tag)this, FormTagBase.class);
    }

    FormTagBase findRootForm() {
        FormTagBase parent = this.findParentForm();
        if (parent == null) {
            return this;
        }
        return parent.findRootForm();
    }

    void checkNoParent(String attrName) {
        if (this.findParentForm() != null) {
            throw new ProgrammerError("Forms included in other forms cannot have a '" + attrName + "' attribute");
        }
    }

    @Override
    public void doEndAnalyze(PageCache pageCache) {
        this.fdp.onFormEndAnalyze(this.getTagKey(), pageCache);
        if (this.formAction == null && this.findParentForm() == null && !this.getOperation().equals("search")) {
            throw new ProgrammerError("Forms must have either action= defined, or an enclosed <mak:action>...</mak:action>");
        }
        if (this.findParentForm() != null && this.formAction != null) {
            throw new ProgrammerError("Forms included in other forms cannot have action= defined, or an enclosed <mak:action>...</mak:action>");
        }
        if (this.clientSideValidation != null && StringUtils.equalsAny(this.clientSideValidation, new String[]{"true", "live"})) {
            pageCache.cacheSetValues("org.makumba.neededResources", MakumbaSystem.getClientsideValidationProvider().getNeededJavaScriptFileNames());
        }
        if (!this.shouldComputeBasePointer()) {
            return;
        }
        pageCache.cache(BASE_POINTER_TYPES, this.tagKey, this.fdp.getTypeOnEndAnalyze(this.getTagKey(), pageCache).getPointedType().getName());
    }

    @Override
    public void initialiseState() {
        super.initialiseState();
        this.responder = this.responderFactory.createResponder();
        if (this.formName != null) {
            this.responder.setResultAttribute(this.formName);
        }
        if (this.handler != null) {
            this.responder.setHandler(this.handler);
        }
        if (this.afterHandler != null) {
            this.responder.setAfterHandler(this.afterHandler);
        }
        if (this.formAction != null) {
            this.responder.setAction(this.formAction);
        }
        if (this.formMethod != null) {
            this.responder.setMethod(this.formMethod);
        }
        if (this.formMessage != null) {
            this.responder.setMessage(this.formMessage);
        }
        this.responder.setReloadFormOnError(this.reloadFormOnError);
        this.responder.setShowFormAnnotated(StringUtils.equalsAny(this.annotation, new String[]{"before", "after", "both"}));
        this.responder.setClientSideValidation(this.clientSideValidation);
        if (this.findParentForm() != null) {
            this.responder.setParentResponder(this.findParentForm().responder, this.findRootForm().responder);
        }
    }

    @Override
    public int doAnalyzedStartTag(PageCache pageCache) throws JspException, LogicException {
        this.fdp.onFormStartTag(this.getTagKey(), pageCache, this.pageContext);
        this.responder.setOperation(this.getOperation(), this.getResponderOperation(this.getOperation()));
        this.responder.setExtraFormatting(this.extraFormatting);
        this.responder.setBasePointerType((String)pageCache.retrieve(BASE_POINTER_TYPES, this.tagKey));
        this.starttime = new Date().getTime();
        if (this.shouldComputeBasePointer()) {
            this.basePointer = this.fdp.computeBasePointer(this.getTagKey(), this.pageContext);
        }
        try {
            this.responder.setHttpRequest((HttpServletRequest)this.pageContext.getRequest());
        }
        catch (LogicException e) {
            throw new RuntimeWrappedException(e);
        }
        return 2;
    }

    @Override
    public int doAnalyzedEndTag(PageCache pageCache) throws JspException {
        this.fdp.onFormEndTag(this.getTagKey(), pageCache, this.pageContext);
        try {
            HashSet<Object> resources;
            StringBuffer sb = new StringBuffer();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (this.findParentForm() == null && this.pageContext.getAttribute("firstFormPassed") == null && (resources = pageCache.retrieveSetValues("org.makumba.neededResources")) != null) {
                for (Object object : resources) {
                    String rsc = request.getContextPath() + "/" + "makumbaResources" + "/" + "javaScript/" + object;
                    sb.append("<script type=\"text/javascript\" src=\"" + rsc + "\">" + "</script>\n");
                }
                this.pageContext.setAttribute("firstFormPassed", (Object)Boolean.TRUE);
            }
            this.responder.writeFormPreamble(sb, this.basePointer);
            this.bodyContent.getEnclosingWriter().print(sb.toString());
            if (this instanceof DeleteTag && !((DeleteTag)this).getPreserveWhiteSpace()) {
                this.bodyContent.getEnclosingWriter().print(this.bodyContent.getString().trim());
            } else {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
            if (!this.getOperation().equals("search") && !(this instanceof DeleteTag) && StringUtils.equalsAny(this.clientSideValidation, new String[]{"true", "live"})) {
                sb = new StringBuffer();
                this.responder.writeClientsideValidation(sb);
                this.bodyContent.getEnclosingWriter().print(sb.toString());
            }
            sb = new StringBuffer();
            this.responder.writeFormPostamble(sb, this.basePointer, (HttpServletRequest)this.pageContext.getRequest());
            this.bodyContent.getEnclosingWriter().print(sb.toString());
            if (this.findParentForm() != null) {
                Logger.getLogger("org.makumba.taglib.performance").fine("form time: " + (new Date().getTime() - this.starttime));
            }
            MultipleKey[] sortedForms = (MultipleKey[])pageCache.retrieve("org.makumba.dependency", "org.makumba.dependency");
            this.setFormOrder(sortedForms, null);
        }
        catch (IOException e) {
            throw new JspException(e.toString());
        }
        return 6;
    }

    public String getDefaultExpr(String fieldName) {
        return null;
    }

    public DataDefinition getDataTypeAtAnalysis(PageCache pageCache) {
        return null;
    }

    public ResponderOperation getResponderOperation(String operation) {
        if (operation.equals("simple")) {
            return simepleOp;
        }
        throw new RuntimeException("Houston, problem");
    }

    @Override
    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.handler = null;
        this.formName = null;
        this.formMessage = null;
        this.formMethod = null;
        this.formAction = null;
        this.basePointer = null;
        this.baseObject = null;
        this.annotationSeparator = null;
        this.annotation = null;
        this.afterHandler = null;
        this.responder = null;
        this.bodyContent = null;
    }
}

