/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.makumba.CompositeValidationException;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.MakumbaSystem;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.StringUtils;
import org.makumba.forms.html.ChoiceSet;
import org.makumba.forms.tags.BasicValueTag;
import org.makumba.providers.Configuration;

public class InputTag
extends BasicValueTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected String display = null;
    protected String nameVar = null;
    protected String calendarEditorLink = null;
    protected String calendarEditor = Configuration.getCalendarEditorDefault();
    protected String nullOption;
    BodyContent bodyContent = null;
    ChoiceSet choiceSet;
    boolean isChoser;

    public String toString() {
        return "INPUT name=" + this.name + " value=" + this.valueExprOriginal + " dataType=" + this.dataType + "\n";
    }

    public void setDataType(String dt) {
        this.dataType = dt.trim();
    }

    public void setField(String field) {
        this.setName(field);
    }

    public void setName(String field) {
        this.name = field.trim();
    }

    public void setDisplay(String d) {
        this.display = d;
    }

    public void setNameVar(String var) {
        this.nameVar = var;
    }

    public void setNullOption(String s) {
        this.nullOption = s;
    }

    public void setAccessKey(String s) {
        this.extraFormattingParams.put("accessKey", s);
    }

    public void setDisabled(String s) {
        this.extraFormattingParams.put("disabled", s);
    }

    public void setOnChange(String s) {
        this.extraFormattingParams.put("onChange", s);
    }

    public void setOnBlur(String s) {
        this.extraFormattingParams.put("onBlur", s);
    }

    public void setOnFocus(String s) {
        this.extraFormattingParams.put("onFocus", s);
    }

    public void setOnSelect(String s) {
        this.extraFormattingParams.put("onSelect", s);
    }

    public void setTabIndex(String s) {
        this.extraFormattingParams.put("tabIndex", s);
    }

    public void setTagKey(PageCache pageCache) {
        this.expr = this.valueExprOriginal;
        if (this.getForm() == null) {
            throw new ProgrammerError("input tag must be enclosed by a form tag");
        }
        if (this.expr == null) {
            this.expr = this.getForm().getDefaultExpr(this.name);
        }
        Object[] keyComponents = new Object[]{this.name, this.getForm().tagKey};
        this.tagKey = new MultipleKey(keyComponents);
    }

    FieldDefinition getTypeFromContext(PageCache pageCache) {
        return this.fdp.getInputTypeAtAnalysis(this, this.getForm().getDataTypeAtAnalysis(pageCache), this.name, pageCache);
    }

    public void doStartAnalyze(PageCache pageCache) {
        if (this.name == null) {
            throw new ProgrammerError("name attribute is required");
        }
        if (this.getForm() == null) {
            throw new ProgrammerError("input tag must be enclosed by a form tag!");
        }
        if (this.isValue()) {
            this.fdp.onNonQueryStartAnalyze(this, this.isNull(), this.getForm().getTagKey(), pageCache, this.expr);
        }
    }

    public void doEndAnalyze(PageCache pageCache) {
        boolean contextTypeIsDate;
        if (this.nameVar != null) {
            this.setType(pageCache, this.nameVar, this.ddp.makeFieldOfType(this.nameVar, "char"));
        }
        FieldDefinition contextType = this.getTypeFromContext(pageCache);
        boolean dataTypeIsDate = this.dataType != null && this.ddp.makeFieldDefinition("dummyName", this.dataType) != null && this.ddp.makeFieldDefinition("dummyName", this.dataType).isDateType();
        boolean bl = contextTypeIsDate = contextType != null && contextType.isDateType();
        if ((dataTypeIsDate || contextTypeIsDate) && this.calendarEditor != null && this.calendarEditor.equals("true")) {
            pageCache.cacheSetValues("org.makumba.neededResources", MakumbaSystem.getCalendarProvider().getNeededJavaScriptFileNames());
        }
        super.doEndAnalyze(pageCache);
    }

    public void initialiseState() {
        super.initialiseState();
        if ("file".equals(this.params.get("type"))) {
            this.getForm().setMultipart();
        }
    }

    public void setBodyContent(BodyContent bc) {
        this.bodyContent = bc;
        this.choiceSet = new ChoiceSet();
    }

    public void doInitBody() {
    }

    public int doAnalyzedStartTag(PageCache pageCache) {
        return 2;
    }

    void checkBodyContentForNonWhitespace() throws JspException {
        if (this.bodyContent != null && this.bodyContent.getString().trim().length() > 0) {
            this.choiceSet.add(null, this.bodyContent.getString().trim(), false, false);
            try {
                this.bodyContent.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    int computedValue(Object val, FieldDefinition type) throws JspException, LogicException {
        this.checkBodyContentForNonWhitespace();
        if (this.choiceSet != null) {
            this.params.put("org.makumba.ChoiceSet", this.choiceSet);
        }
        if ("false".equals(this.display)) {
            this.params.put("org.makumba.noDisplay", "dummy");
        }
        if (this.nullOption != null) {
            FieldDefinition fd = this.getTypeFromContext(InputTag.getPageCache(this.pageContext, MakumbaJspAnalyzer.getInstance()));
            if (!fd.isEnumType() && !fd.isPointer()) {
                throw new ProgrammerError("Attribute 'nullOption' is only applicable for 'charEnum', 'intEnum' and 'ptr' types, but input '" + fd.getName() + "' is of type '" + fd.getType() + "'!");
            }
            this.params.put("nullOption", this.nullOption);
        }
        if (!type.isDateType()) {
            this.extraFormatting.append("id=\"").append(this.name).append("\" ");
        } else {
            if (this.calendarEditor != null) {
                this.params.put("calendarEditor", this.calendarEditor);
            }
            if (this.calendarEditorLink != null) {
                this.params.put("calendarEditorLink", this.calendarEditorLink);
            }
        }
        String formatted = this.getForm().responder.format(this.name, type, val, this.params, this.extraFormatting.toString());
        String fieldName = this.name + this.getForm().responder.getSuffix();
        if (this.nameVar != null) {
            this.getPageContext().setAttribute(this.nameVar, (Object)fieldName);
        }
        if (this.display == null || !this.display.equals("false")) {
            try {
                Iterator<InvalidValueException> iter;
                CompositeValidationException errors = (CompositeValidationException)this.pageContext.getRequest().getAttribute("__makumba__formValidationErrors__");
                Collection<InvalidValueException> exceptions = null;
                if (errors != null) {
                    exceptions = errors.getExceptions(fieldName);
                }
                if (StringUtils.equalsAny(this.getForm().annotation, new String[]{"before", "both"}) && exceptions != null) {
                    iter = exceptions.iterator();
                    while (iter.hasNext()) {
                        this.printAnnotation(fieldName, iter.next());
                        if (this.getForm().annotationSeparator == null) continue;
                        this.pageContext.getOut().print(this.getForm().annotationSeparator);
                    }
                }
                this.pageContext.getOut().print(formatted);
                if (StringUtils.equalsAny(this.getForm().annotation, new String[]{"after", "both"}) && exceptions != null) {
                    iter = exceptions.iterator();
                    while (iter.hasNext()) {
                        if (this.getForm().annotationSeparator != null) {
                            this.pageContext.getOut().print(this.getForm().annotationSeparator);
                        }
                        this.printAnnotation(fieldName, iter.next());
                    }
                }
            }
            catch (IOException e) {
                throw new JspException(e.toString());
            }
        }
        this.nameVar = null;
        this.expr = null;
        this.display = null;
        this.dataType = null;
        this.valueExprOriginal = null;
        this.name = null;
        return 6;
    }

    private void printAnnotation(String fieldName, InvalidValueException e) throws IOException {
        this.pageContext.getOut().print("<span class=\"LV_validation_message LV_invalid\">");
        this.pageContext.getOut().print(e.getShortMessage());
        this.pageContext.getOut().print("</span>");
    }

    public void setCalendarEditorLink(String calendarEditorLink) {
        this.calendarEditorLink = calendarEditorLink;
    }

    public void setCalendarEditor(String calendarEditor) {
        this.calendarEditor = calendarEditor;
    }

    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.bodyContent = null;
        this.choiceSet = null;
        this.calendarEditorLink = null;
        this.calendarEditor = null;
        this.display = null;
        this.nullOption = null;
        this.nameVar = null;
        this.name = null;
    }
}

