/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.lang.StringUtils;
import org.makumba.FieldDefinition;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MultipleKey;
import org.makumba.forms.tags.CriterionTag;
import org.makumba.forms.tags.InputTag;

public class SearchFieldTag
extends InputTag {
    private static final String[] allowedRoles = new String[]{"rangeBegin", "rangeEnd"};
    private static final String[] allowedSelectTypes = ATTRIBUTE_VALUES_TRUE_FALSE;
    private static final long serialVersionUID = 1L;
    private String selectMultiple = null;
    private String role = null;

    public void setSelectMultiple(String selectMultiple) {
        if (!this.getForm().getOperation().equals("search")) {
            throw new ProgrammerError("'selectMultiple' attribute is only valid inside Makumba Search Forms!");
        }
        this.checkValidAttributeValues("selectMultiple", selectMultiple, allowedSelectTypes);
        this.selectMultiple = selectMultiple;
        this.params.put("selectMultiple", selectMultiple);
    }

    protected CriterionTag getCriterionTag() {
        return (CriterionTag)SearchFieldTag.findAncestorWithClass((Tag)this, CriterionTag.class);
    }

    public void doStartAnalyze(PageCache pageCache) {
        if (this.getCriterionTag() == null) {
            throw new ProgrammerError("'criterionInput' tag must be enclosed in a 'criterion' tag");
        }
        this.name = this.getCriterionTag().getInputName();
        FieldDefinition fd = this.getCriterionTag().getFieldDefinition(pageCache);
        if (this.selectMultiple != null && fd != null && !fd.isEnumType() && !fd.isPointer()) {
            throw new ProgrammerError("'selectMultiple' attribute is only valid for 'ptr' and 'intEnum'/'charEnum' types, field is of type '" + fd.getType() + "'!");
        }
        if (this.isValue()) {
            this.fdp.onNonQueryStartAnalyze(this, this.isNull(), this.getForm().getTagKey(), pageCache, this.expr);
        }
        if (StringUtils.equals((String)this.selectMultiple, (String)"true") && this.nullOption != null) {
            throw new ProgrammerError("'selectMultiple' attribute cannot be used in combination with 'nullOption'");
        }
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws JspException, LogicException {
        this.name = this.getCriterionTag().getInputName();
        if (StringUtils.equals((String)this.role, (String)"rangeEnd")) {
            this.name = this.name + "RangeEnd";
        }
        this.getForm().responder.addMultiFieldSearchMapping(this.name, this.getCriterionTag().getFieldsSplit());
        return super.doAnalyzedEndTag(pageCache);
    }

    public void setTagKey(PageCache pageCache) {
        this.tagKey = new MultipleKey(new Object[]{this.getCriterionTag().tagKey, this.id, this.role});
    }

    public void setRole(String role) {
        this.checkValidAttributeValues("role", role, allowedRoles);
        if (!this.getCriterionTag().isRange()) {
            throw new ProgrammerError("'role' can only be specified if the criterion specific range='true'! ");
        }
        this.role = role;
    }

    public boolean allowsIdenticalKey() {
        return false;
    }
}

