/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.validation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.makumba.FieldDefinition;
import org.makumba.ValidationRule;
import org.makumba.commons.StringUtils;
import org.makumba.forms.validation.ClientsideValidationProvider;
import org.makumba.providers.datadefinition.makumba.validation.ComparisonValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.NumberRangeValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.RangeValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.RegExpValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.StringLengthValidationRule;

public class LiveValidationProvider
implements ClientsideValidationProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private StringBuffer validationObjects = new StringBuffer();
    private HashSet<String> definitionVarNames = new HashSet();

    public void initField(String inputName, FieldDefinition fieldDefinition, boolean validateLive) {
        Collection<ValidationRule> validationRules = fieldDefinition.getValidationRules();
        int size = validationRules != null ? validationRules.size() : 1;
        StringBuffer validations = new StringBuffer(100 + size * 50);
        String inputVarName = inputName.replaceAll("\\.", "__") + "Validation";
        if (fieldDefinition == null) {
            System.out.println("null def for " + inputName);
        }
        if (fieldDefinition.isNotNull()) {
            validations.append(this.getValidationLine(inputVarName, "Validate.Presence", "A non-null value is needed for notnull fields"));
        }
        if (fieldDefinition.isIntegerType()) {
            validations.append(this.getValidationLine(inputVarName, "Validate.Numericality", "invalid integer", "onlyInteger: true,"));
        } else if (fieldDefinition.isRealType()) {
            validations.append(this.getValidationLine(inputVarName, "Validate.Numericality", "invalid integer"));
        }
        if (validationRules != null) {
            for (ValidationRule rule : validationRules) {
                ComparisonValidationRule c;
                if (rule instanceof StringLengthValidationRule) {
                    validations.append(this.getValidationLine(inputVarName, "Validate.Length", rule, this.getRangeLimits(rule)));
                    continue;
                }
                if (rule instanceof NumberRangeValidationRule) {
                    validations.append(this.getValidationLine(inputVarName, "Validate.Numericality", rule, this.getRangeLimits(rule)));
                    continue;
                }
                if (rule instanceof RegExpValidationRule) {
                    validations.append(this.getValidationLine(inputVarName, "Validate.Format", rule, "pattern: /^" + ((RegExpValidationRule)rule).getRegExp() + "$/i, "));
                    continue;
                }
                if (!(rule instanceof ComparisonValidationRule) || (c = (ComparisonValidationRule)rule).getFieldDefinition().isDateType()) continue;
                String arguments = "element1: \"" + c.getFieldName() + "\", element2: \"" + c.getOtherFieldName() + "\", comparisonOperator: \"" + c.getCompareOperator() + "\", ";
                if (c.getFieldDefinition().isNumberType()) {
                    validations.append(this.getValidationLine(inputVarName, "MakumbaValidate.NumberComparison", rule, arguments));
                    continue;
                }
                if (c.getFieldDefinition().isDateType() || !c.getFieldDefinition().isStringType() || c.getFunctionName() == null || c.getFunctionName().length() <= 0) continue;
                arguments = arguments + "functionToApply: \"" + c.getFunctionName() + "\", ";
                validations.append(this.getValidationLine(inputVarName, "MakumbaValidate.StringComparison", rule, arguments));
            }
        }
        if (fieldDefinition.isUnique() && !fieldDefinition.isDateType()) {
            validations.append(this.getValidationLine(inputVarName, "MakumbaValidate.Uniqueness", "This field needs to be unique. Try another value", "table: \"" + fieldDefinition.getDataDefinition().getName() + "\", " + "field: \"" + fieldDefinition.getName() + "\", "));
        }
        if (validations.length() > 0) {
            this.definitionVarNames.add(inputVarName);
            this.validationObjects.append("var " + inputVarName + " = new LiveValidation('" + inputName + "', { validMessage: \" \" });\n");
            this.validationObjects.append(validations);
            this.validationObjects.append("\n");
        }
    }

    public StringBuffer getClientValidation(boolean validateLive) {
        StringBuffer b = new StringBuffer();
        if (this.validationObjects.length() > 0) {
            b.append("<script type=\"text/javascript\">\n");
            b.append(this.validationObjects);
            b.append("function " + this.getValidationFunction() + " {\n");
            b.append("  valid = LiveValidation.massValidate( ").append(StringUtils.toString(this.definitionVarNames)).append(" );\n");
            b.append("  if (!valid) {");
            b.append("    alert('Please correct all form errors first!');");
            b.append("  }\n");
            b.append("  return valid;\n");
            b.append("}\n");
            b.append("</script>\n");
        }
        return b;
    }

    private StringBuffer getValidationFunction() {
        return new StringBuffer("validateForm_").append(StringUtils.concatAsString(this.definitionVarNames.toArray(new Object[this.definitionVarNames.size()]))).append("()");
    }

    public StringBuffer getOnSubmitValidation(boolean validateLive) {
        if (this.definitionVarNames.size() > 0) {
            StringBuffer sb = new StringBuffer(this.getValidationFunction()).append(";");
            return sb;
        }
        return null;
    }

    public String[] getNeededJavaScriptFileNames() {
        return new String[]{"makumba-livevalidation.js", "livevalidation_1.2_standalone.js"};
    }

    private String getValidationLine(String inputVarName, String validationType, ValidationRule rule, String arguments) {
        return this.getValidationLine(inputVarName, validationType, rule.getErrorMessage(), arguments);
    }

    private String getValidationLine(String inputVarName, String validationType, String failureMessage) {
        return this.getValidationLine(inputVarName, validationType, failureMessage, "");
    }

    private String getValidationLine(String inputVarName, String validationType, String failureMessage, String arguments) {
        return inputVarName + ".add( " + validationType + " , { " + arguments + " failureMessage: \"" + failureMessage + "\" } );\n";
    }

    private String getRangeLimits(ValidationRule rule) {
        String lower = ((RangeValidationRule)rule).getLowerLimitString();
        String upper = ((RangeValidationRule)rule).getUpperLimitString();
        String s = "";
        if (!lower.equals("?")) {
            s = s + "minimum: " + lower;
        }
        if (!upper.equals("?")) {
            if (s.length() > 0) {
                s = s + ", ";
            }
            s = s + "maximum: " + upper;
        }
        if (s.length() > 0) {
            s = s + ", ";
        }
        return s;
    }
}

