/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.importer;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.Database;
import org.makumba.providers.DataDefinitionProvider;

public class ObjectToRecord {
    Method transform;
    Method clean;
    DataDefinition type;
    Hashtable fields = new Hashtable();
    boolean cleaned = false;
    static Integer zero = new Integer(0);
    static Integer one = new Integer(1);

    public ObjectToRecord(Class c, String type) {
        try {
            Class[] args = new Class[]{Hashtable.class, Database.class};
            try {
                this.transform = c.getMethod("importTransform", args);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            try {
                this.clean = c.getMethod("importClean", args);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            this.type = DataDefinitionProvider.getInstance().getDataDefinition(type);
            Field no = null;
            try {
                no = c.getField("noImport");
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
            String[] noImp = new String[]{};
            if (no != null) {
                noImp = (String[])no.get(null);
            }
            String dummy = "dummy";
            Hashtable<String, String> noImport = new Hashtable<String, String>();
            for (int i = 0; i < noImp.length; ++i) {
                noImport.put(noImp[i], dummy);
            }
            Field acc = null;
            try {
                acc = c.getField("accountedImport");
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
            String[] accountedImp = new String[]{};
            if (acc != null) {
                accountedImp = (String[])acc.get(null);
            }
            Hashtable<String, String> accountedImport = new Hashtable<String, String>();
            for (int i = 0; i < accountedImp.length; ++i) {
                accountedImport.put(accountedImp[i], dummy);
            }
            Enumeration e = this.type.getFieldNames().elements();
            for (int i = 0; i < 3; ++i) {
                e.nextElement();
            }
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                Field f = null;
                try {
                    f = c.getField(s);
                }
                catch (NoSuchFieldException nsfe1) {
                    // empty catch block
                }
                if (f != null) {
                    if (noImport.get(s) != null) continue;
                    this.fields.put(s, f);
                    continue;
                }
                if (accountedImport.get(s) != null) continue;
                Logger.getLogger("org.makumba.import").severe("No Java correspondent for " + type + "." + s + " in " + c.getName());
            }
            Field[] flds = c.getFields();
            for (int i = 0; i < flds.length; ++i) {
                try {
                    flds[i].get(null);
                    continue;
                }
                catch (NullPointerException npe) {
                    String s = flds[i].getName();
                    if (this.type.getFieldDefinition(s) != null || noImport.get(s) != null) continue;
                    Logger.getLogger("org.makumba.import").severe("No Makumba correspondent for " + c.getName() + "." + s + " in " + type);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable importObject(Object o, Database db) {
        try {
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            Object[] args = new Object[]{h, db};
            h.put(this.type.getIndexPointerFieldName(), db.getPointer(this.type.getName(), o.hashCode()));
            Enumeration e = this.fields.keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                Object value = ((Field)this.fields.get(s)).get(o);
                if (value == null) continue;
                if (!value.getClass().getName().startsWith("java")) {
                    value = db.getPointer(this.type.getFieldDefinition(s).getForeignTable().getName(), value.hashCode());
                }
                h.put(s, value);
            }
            if (!this.cleaned && this.clean != null && ((Boolean)this.clean.invoke(o, args)).booleanValue()) {
                db.deleteFrom(db.getName(), this.type.getName(), false);
                this.cleaned = true;
            }
            if (this.transform == null || ((Boolean)this.transform.invoke(o, args)).booleanValue()) {
                DBConnection dbc = db.getDBConnection();
                try {
                    dbc.insert(this.type.getName(), h);
                }
                finally {
                    dbc.close();
                }
            }
            return h;
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
        }
        catch (InvalidValueException ive) {
            Logger.getLogger("org.makumba.import").warning(ive.getMessage());
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        throw new RuntimeException();
    }

    public static void importInteger(String java, String mdd, Hashtable hjava, Hashtable hmdd) {
        String s = (String)hjava.remove(java);
        if (s == null) {
            return;
        }
        Integer i = null;
        try {
            i = new Integer(Integer.parseInt(s.trim()));
        }
        catch (NumberFormatException nfe) {
            if (s.trim().length() > 0) {
                Logger.getLogger("org.makumba.import").warning(s);
            }
            return;
        }
        hmdd.put(mdd, i);
    }

    public static void importString(String java, String mdd, Hashtable hjava, Hashtable hmdd) {
        String s = (String)hjava.remove(java);
        if (s == null) {
            return;
        }
        hmdd.put(mdd, s.trim());
    }

    public static void importBoolean(String java, String mdd, Hashtable hjava, Hashtable hmdd, String on) {
        String s = (String)hjava.remove(java);
        hmdd.put(mdd, zero);
        if (s == null) {
            return;
        }
        if (s.trim().equals(on)) {
            hmdd.put(mdd, one);
        }
    }
}

