/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.engine;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.NoSuchFieldException;
import org.makumba.commons.ArgumentReplacer;
import org.makumba.list.engine.ComposedSubquery;
import org.makumba.list.engine.Grouper;
import org.makumba.providers.QueryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedQuery {
    public QueryProvider qep = null;
    int subqueries = 0;
    Vector<Object> projections = new Vector();
    Hashtable<String, Integer> projectionExpr = new Hashtable();
    public static final int FROM = 0;
    public static final int WHERE = 1;
    public static final int GROUPBY = 2;
    public static final int ORDERBY = 3;
    public static final int VARFROM = 4;
    String[] sections;
    String[] derivedSections;
    String typeAnalyzerOQL;
    String fromAnalyzerOQL;
    Vector<Integer> keyset;
    Vector previousKeyset;
    Vector<String> keysetLabels;
    static Vector empty = new Vector();

    public ComposedQuery(String[] sections, String queryLanguage) {
        this.sections = sections;
        this.derivedSections = sections;
        this.qep = QueryProvider.makeQueryAnalzyer(queryLanguage);
    }

    public DataDefinition getResultType() {
        if (this.typeAnalyzerOQL == null) {
            return null;
        }
        return this.qep.getQueryAnalysis(this.typeAnalyzerOQL).getProjectionType();
    }

    public DataDefinition getLabelType(String s) {
        if (this.typeAnalyzerOQL == null) {
            return null;
        }
        return this.qep.getQueryAnalysis(this.typeAnalyzerOQL).getLabelType(s);
    }

    public void init() {
        this.initKeysets();
        this.fromAnalyzerOQL = "SELECT 1 ";
        if (this.getFromSection() != null) {
            this.fromAnalyzerOQL = this.fromAnalyzerOQL + "FROM " + this.getFromSection();
        }
    }

    public String getFromSection() {
        return this.derivedSections[0];
    }

    protected void initKeysets() {
        this.previousKeyset = empty;
        this.keyset = new Vector();
        this.keysetLabels = new Vector();
    }

    protected void addSubquery(ComposedSubquery q) {
        if (this.subqueries == 0) {
            this.prependFromToKeyset();
        }
        ++this.subqueries;
    }

    protected void prependFromToKeyset() {
        this.projectionExpr.clear();
        Enumeration e = ((Vector)this.projections.clone()).elements();
        this.projections.removeAllElements();
        for (int i = 0; i < this.keyset.size(); ++i) {
            this.checkProjectionInteger((String)e.nextElement());
        }
        StringTokenizer st = new StringTokenizer(this.sections[0] == null ? "" : this.sections[0], ",");
        while (st.hasMoreTokens()) {
            String label = st.nextToken().trim();
            int j = label.lastIndexOf(" ");
            if (j == -1) {
                throw new RuntimeException("invalid FROM");
            }
            label = label.substring(j + 1).trim();
            label = this.qep.getPrimaryKeyNotation(label);
            this.keysetLabels.addElement(label);
            this.keyset.addElement(this.addProjection(label));
        }
        while (e.hasMoreElements()) {
            this.checkProjectionInteger((String)e.nextElement());
        }
    }

    public String getProjectionAt(int n) {
        return (String)this.projections.elementAt(n);
    }

    Integer addProjection(String expr) {
        Integer index = new Integer(this.projections.size());
        this.projections.addElement(expr);
        this.projectionExpr.put(expr, index);
        return index;
    }

    public Integer checkProjectionInteger(String expr) {
        Integer index = this.projectionExpr.get(expr);
        if (index == null) {
            this.addProjection(expr);
            return null;
        }
        return index;
    }

    String checkProjection(String expr) {
        Integer i = this.checkProjectionInteger(expr);
        if (i == null) {
            return null;
        }
        return ComposedQuery.columnName(i);
    }

    public static String columnName(Integer n) {
        return "col" + (n + 1);
    }

    String checkExpr(String str) {
        if (!this.qep.selectGroupOrOrderAsLabels()) {
            return str;
        }
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        String sep = "";
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String p;
            ret.append(sep);
            sep = ",";
            String s = st.nextToken().trim();
            String rest = "";
            int i = s.indexOf(" ");
            if (i != -1) {
                rest = s.substring(i);
                s = s.substring(0, i);
            }
            if ((p = this.checkProjection(s)) == null) {
                p = this.checkProjection(s);
            }
            ret.append(p).append(rest);
        }
        return ret.toString();
    }

    protected String computeQuery(String[] derivedSections, boolean typeAnalysisOnly) {
        String groups = null;
        String orders = null;
        if (!typeAnalysisOnly) {
            groups = this.checkExpr(derivedSections[2]);
            orders = this.checkExpr(derivedSections[3]);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        String sep = "";
        int i = 0;
        Enumeration<Object> e = this.projections.elements();
        while (e.hasMoreElements()) {
            sb.append(sep);
            sep = ",";
            sb.append(e.nextElement()).append(" AS ").append(ComposedQuery.columnName(new Integer(i++)));
        }
        String o = derivedSections[0];
        if (o != null) {
            sb.append(" FROM ");
            sb.append((Object)o);
            if (!typeAnalysisOnly && derivedSections.length == 5 && derivedSections[4] != null && derivedSections[4].trim().length() > 0) {
                sb.append(",").append(derivedSections[4]);
            }
        }
        if (!typeAnalysisOnly) {
            o = derivedSections[1];
            if (o != null && derivedSections[1].trim().length() > 0) {
                sb.append(" WHERE ");
                sb.append((Object)o);
            }
            if (groups != null) {
                sb.append(" GROUP BY ");
                sb.append(groups);
            }
            if (orders != null) {
                sb.append(" ORDER BY ");
                sb.append(orders);
            }
        }
        String ret = sb.toString();
        if (!typeAnalysisOnly) {
            return ret;
        }
        ArgumentReplacer ar = new ArgumentReplacer(ret);
        HashMap<String, Object> d = new HashMap<String, Object>();
        int j = 1;
        Iterator<String> e2 = ar.getArgumentNames();
        while (e2.hasNext()) {
            d.put(e2.next(), "$" + j++);
        }
        return ar.replaceValues(d);
    }

    public Grouper execute(QueryProvider qep, Map args, Evaluator v, int offset, int limit) throws LogicException {
        this.analyze();
        String[] vars = new String[5];
        vars[0] = this.getFromSection();
        for (int i = 1; i < 5; ++i) {
            vars[i] = this.derivedSections[i] == null ? null : v.evaluate(this.derivedSections[i]);
        }
        return new Grouper(this.previousKeyset, qep.execute(this.computeQuery(vars, false), args, offset, limit).elements());
    }

    public synchronized void analyze() {
        if (this.projections.isEmpty()) {
            this.prependFromToKeyset();
        }
        if (this.typeAnalyzerOQL == null) {
            this.typeAnalyzerOQL = this.computeQuery(this.derivedSections, true);
        }
    }

    public Object checkExprSetOrNullable(String expr) {
        if (expr.toLowerCase().indexOf(" from ") != -1) {
            return null;
        }
        int n = 0;
        int m = 0;
        while (true) {
            if (n < expr.length() && !ComposedQuery.isMakId(expr.charAt(n))) {
                ++n;
                continue;
            }
            if (n == expr.length()) {
                return null;
            }
            m = n;
            while (n < expr.length() && ComposedQuery.isMakId(expr.charAt(n))) {
                ++n;
            }
            Object nl = this.checkLabelSetOrNullable(expr.substring(m, n));
            if (nl != null) {
                return nl;
            }
            if (n == expr.length()) break;
        }
        return null;
    }

    static boolean isMakId(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    public Object checkLabelSetOrNullable(String referenceSequence) {
        int dot = referenceSequence.indexOf(".");
        if (dot == -1) {
            return null;
        }
        String substring = referenceSequence.substring(0, dot);
        try {
            Integer.parseInt(substring);
            return null;
        }
        catch (NumberFormatException e) {
            DataDefinition dd = this.qep.getQueryAnalysis(this.fromAnalyzerOQL).getLabelType(substring);
            if (dd == null) {
                throw new InvalidValueException("no such label " + substring);
            }
            while (true) {
                int dot1;
                if ((dot1 = referenceSequence.indexOf(".", dot + 1)) == -1) {
                    String fn = referenceSequence.substring(dot + 1);
                    FieldDefinition fd = dd.getFieldDefinition(fn);
                    if (fd == null && (fd = this.qep.getAlternativeField(dd, fn)) == null) {
                        throw new NoSuchFieldException(dd, fn);
                    }
                    if (fd.getType().equals("set")) {
                        return fd;
                    }
                    return null;
                }
                FieldDefinition fd = dd.getFieldDefinition(referenceSequence.substring(dot + 1, dot1));
                if (fd == null) {
                    throw new NoSuchFieldException(dd, referenceSequence.substring(dot + 1, dot1));
                }
                if (!fd.getType().startsWith("ptr")) {
                    throw new InvalidFieldTypeException(fd, "pointer");
                }
                if (!fd.isNotNull()) {
                    return referenceSequence.substring(0, dot1);
                }
                dd = fd.getPointedType();
                dot = dot1;
            }
        }
    }

    public void addProjection(Object o) {
        this.projections.add(o);
    }

    public String toString() {
        return "Composed query: " + this.typeAnalyzerOQL;
    }

    public String getTypeAnalyzerQuery() {
        return this.typeAnalyzerOQL;
    }

    public Vector<Object> getProjections() {
        return this.projections;
    }

    public DataDefinition getProjectionTypes() {
        return this.qep.getQueryAnalysis(this.typeAnalyzerOQL).getProjectionType();
    }

    public DataDefinition getTypeOfExprField(String expr) {
        return this.qep.getQueryAnalysis(this.typeAnalyzerOQL).getTypeOfExprField(expr);
    }

    public String getFieldOfExpr(String expr) {
        return this.qep.getQueryAnalysis(this.typeAnalyzerOQL).getFieldOfExpr(expr);
    }

    public Map<String, DataDefinition> getFromLabelTypes() {
        return this.qep.getQueryAnalysis(this.fromAnalyzerOQL).getLabelTypes();
    }

    static {
        empty.addElement(new Vector());
    }

    public static interface Evaluator {
        public String evaluate(String var1);
    }
}

