/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.tags;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.ProgrammerError;
import org.makumba.analyser.AnalysableTag;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.list.engine.ComposedQuery;
import org.makumba.list.engine.ComposedSubquery;
import org.makumba.list.engine.QueryExecution;
import org.makumba.list.html.RecordViewer;
import org.makumba.list.tags.GenericListTag;
import org.makumba.list.tags.MakumbaJspException;
import org.makumba.list.tags.ObjectTag;

public class QueryTag
extends GenericListTag
implements IterationTag {
    private static final long serialVersionUID = 1L;
    String[] queryProps = new String[5];
    String separator = "";
    String countVar;
    String maxCountVar;
    String offset;
    String limit;
    private int defaultOffset = 0;
    private String defaultLimit = "-1";
    static String standardCountVar = "org_makumba_view_jsptaglib_countVar";
    static String standardMaxCountVar = "org_makumba_view_jsptaglib_maxCountVar";
    static String standardLastCountVar = "org_makumba_view_jsptaglib_lastCountVar";
    static String standardMaxResultsVar = "org_makumba_view_jsptaglib_MaxResultsVar";
    static String standardMaxResultsContext = "org_makumba_view_jsptaglib_MaxResultsContext";
    static String standardMaxResultsKey = "org_makumba_view_jsptaglib_MaxResultsKey";
    QueryExecution execution;
    static final Integer zero = new Integer(0);
    static final Integer one = new Integer(1);
    Object upperCount = null;
    Object upperMaxCount = null;
    private static ThreadLocal<ServletRequest> servletRequestThreadLocal = new ThreadLocal();

    public void setFrom(String s) {
        this.queryProps[0] = s;
    }

    public void setVariableFrom(String s) {
        this.queryProps[4] = s;
    }

    public void setWhere(String s) {
        this.queryProps[1] = s;
    }

    public void setOrderBy(String s) {
        this.queryProps[3] = s;
    }

    public void setGroupBy(String s) {
        this.queryProps[2] = s;
    }

    public void setSeparator(String s) {
        this.separator = s;
    }

    public void setCountVar(String s) {
        this.countVar = s;
    }

    public void setMaxCountVar(String s) {
        this.maxCountVar = s;
    }

    public void setOffset(String s) throws JspException {
        this.onlyOuterListArgument("offset");
        this.onlyInt("offset", s);
        this.offset = s.trim();
    }

    public void setLimit(String s) throws JspException {
        this.onlyOuterListArgument("limit");
        this.onlyInt("limit", s);
        this.limit = s.trim();
    }

    public void setDefaultLimit(String s) throws JspException {
        this.onlyOuterListArgument("defaultLimit");
        this.onlyInt("defaultLimit", s);
        this.defaultLimit = s.trim();
    }

    public int getLimitInt() {
        int limitInt = -1;
        try {
            limitInt = QueryExecution.computeLimit(this.pageContext, this.limit, Integer.parseInt(this.defaultLimit), limitInt);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return limitInt;
    }

    public int getOffsetInt() {
        int defaultOffsetInt = 0;
        try {
            defaultOffsetInt = QueryExecution.computeLimit(this.pageContext, this.offset, this.defaultOffset, defaultOffsetInt);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return defaultOffsetInt;
    }

    protected void onlyOuterListArgument(String s) throws JspException {
        QueryTag t = (QueryTag)QueryTag.findAncestorWithClass((Tag)this, QueryTag.class);
        while (t != null && t instanceof ObjectTag) {
            t = (QueryTag)QueryTag.findAncestorWithClass((Tag)t, QueryTag.class);
        }
        if (t instanceof QueryTag) {
            throw new RuntimeWrappedException((Throwable)((Object)new MakumbaJspException(this, "the " + s + " parameter can only be set for the outermost mak:list tag")));
        }
    }

    public void setTagKey(PageCache pageCache) {
        this.tagKey = new MultipleKey(this.queryProps.length + 2);
        for (int i = 0; i < this.queryProps.length; ++i) {
            this.tagKey.setAt(this.queryProps[i], i);
        }
        this.tagKey.setAt(QueryTag.getParentListKey(this, pageCache), this.queryProps.length);
        this.tagKey.setAt(this.id, this.queryProps.length + 1);
    }

    public boolean allowsIdenticalKey() {
        return false;
    }

    public void doStartAnalyze(PageCache pageCache) {
        String orderBy = this.queryProps[3];
        if (orderBy != null && orderBy.indexOf("$") != -1) {
            throw new ProgrammerError("Illegal use of an $attribute orderBy: '" + orderBy + "' ==> only JSP Expression Language using #{..} is allowed!");
        }
        QueryTag.cacheQuery(pageCache, this.tagKey, this.queryProps, QueryTag.getParentListKey(this, pageCache));
        if (this.countVar != null) {
            this.setType(pageCache, this.countVar, MakumbaSystem.makeFieldOfType(this.countVar, "int"));
        }
        if (this.maxCountVar != null) {
            this.setType(pageCache, this.maxCountVar, MakumbaSystem.makeFieldOfType(this.maxCountVar, "int"));
        }
    }

    public void doEndAnalyze(PageCache pageCache) {
        ComposedQuery cq = QueryTag.getQuery(pageCache, this.tagKey);
        cq.analyze();
        pageCache.cache("org.makumba.formatters", this.tagKey, new RecordViewer(cq));
    }

    public int doAnalyzedStartTag(PageCache pageCache) throws LogicException, JspException {
        servletRequestThreadLocal.set(this.pageContext.getRequest());
        if (QueryTag.getParentList(this) == null) {
            QueryExecution.startListGroup(this.pageContext);
        } else {
            this.upperCount = this.pageContext.getRequest().getAttribute(standardCountVar);
            this.upperMaxCount = this.pageContext.getRequest().getAttribute(standardMaxCountVar);
        }
        this.execution = QueryExecution.getFor(this.tagKey, this.pageContext, this.offset, this.limit, this.defaultLimit);
        int n = this.execution.onParentIteration();
        this.setNumberOfIterations(n);
        int maxResults = Integer.MIN_VALUE;
        int limitEval = QueryExecution.computeLimit(this.pageContext, this.limit, Integer.parseInt(this.defaultLimit), -1);
        int offsetEval = QueryExecution.computeLimit(this.pageContext, this.offset, this.defaultOffset, 0);
        if (offsetEval == 0 && limitEval == -1 || offsetEval == 0 && limitEval > 0 && limitEval < n) {
            maxResults = n;
        } else {
            ComposedQuery query = null;
            String[] simpleQueryProps = (String[])this.queryProps.clone();
            simpleQueryProps[3] = "";
            MultipleKey maxResultsKey = this.getMaxResultsKey(this.tagKey);
            MultipleKey parentKey = QueryTag.getParentListKey(this, pageCache);
            String ql = MakumbaJspAnalyzer.getQueryLanguage(pageCache);
            query = parentKey == null ? new ComposedQuery(simpleQueryProps, ql) : new ComposedSubquery(simpleQueryProps, QueryTag.getQuery(pageCache, parentKey), ql);
            query.addProjection((Object)"count(*)");
            query.init();
            pageCache.cache("org.makumba.query", maxResultsKey, query);
            this.pageContext.getRequest().setAttribute(standardMaxResultsContext, (Object)this.pageContext);
            this.pageContext.getRequest().setAttribute(standardMaxResultsKey, (Object)maxResultsKey);
        }
        this.pageContext.getRequest().setAttribute(standardMaxResultsVar, (Object)maxResults);
        if (n > 0) {
            if (this.countVar != null) {
                this.pageContext.setAttribute(this.countVar, (Object)one);
            }
            this.pageContext.getRequest().setAttribute(standardCountVar, (Object)one);
            return 1;
        }
        if (this.countVar != null) {
            this.pageContext.setAttribute(this.countVar, (Object)zero);
        }
        this.pageContext.getRequest().setAttribute(standardCountVar, (Object)zero);
        return 0;
    }

    private MultipleKey getMaxResultsKey(MultipleKey tagKey) {
        MultipleKey totalKey = (MultipleKey)tagKey.clone();
        totalKey.add(standardMaxResultsVar);
        return totalKey;
    }

    protected void setNumberOfIterations(int n) throws JspException {
        Integer cnt = new Integer(n);
        if (this.maxCountVar != null) {
            this.pageContext.setAttribute(this.maxCountVar, (Object)cnt);
        }
        this.pageContext.getRequest().setAttribute(standardMaxCountVar, (Object)cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doAfterBody() throws JspException {
        runningTag.set(this.tagData);
        try {
            int n = this.execution.nextGroupIteration();
            if (n != -1) {
                try {
                    this.pageContext.getOut().print(this.separator);
                }
                catch (Exception e) {
                    throw new MakumbaJspException(e);
                }
                Integer cnt = new Integer(n + 1);
                if (this.countVar != null) {
                    this.pageContext.setAttribute(this.countVar, (Object)cnt);
                }
                this.pageContext.getRequest().setAttribute(standardCountVar, (Object)cnt);
                int n2 = 2;
                return n2;
            }
            int n3 = 0;
            return n3;
        }
        finally {
            runningTag.set(null);
        }
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws JspException {
        this.pageContext.getRequest().setAttribute(standardLastCountVar, this.pageContext.getRequest().getAttribute(standardMaxCountVar));
        this.pageContext.getRequest().setAttribute(standardCountVar, this.upperCount);
        this.pageContext.getRequest().setAttribute(standardMaxCountVar, this.upperMaxCount);
        this.execution.endIterationGroup();
        if (QueryTag.getParentList(this) == null) {
            QueryExecution.endListGroup(this.pageContext);
        }
        return 6;
    }

    public static AnalysableTag getParentList(AnalysableTag tag) {
        return (AnalysableTag)QueryTag.findAncestorWithClass((Tag)tag, QueryTag.class);
    }

    public static MultipleKey getParentListKey(AnalysableTag tag, PageCache pageCache) {
        AnalysableTag parentList = QueryTag.getParentList(tag);
        return parentList == null ? null : parentList.getTagKey();
    }

    public static ComposedQuery getQuery(PageCache pc, MultipleKey key) {
        ComposedQuery ret = (ComposedQuery)pc.retrieve("org.makumba.query", key);
        if (ret == null) {
            throw new MakumbaError("unknown query for key " + key);
        }
        return ret;
    }

    public static ComposedQuery cacheQuery(PageCache pc, MultipleKey key, String[] sections, MultipleKey parentKey) {
        ComposedQuery ret = (ComposedQuery)pc.retrieve("org.makumba.query", key);
        if (ret != null) {
            return ret;
        }
        String ql = MakumbaJspAnalyzer.getQueryLanguage(pc);
        ret = parentKey == null ? new ComposedQuery(sections, ql) : new ComposedSubquery(sections, QueryTag.getQuery(pc, parentKey), ql);
        ret.init();
        pc.cache("org.makumba.query", key, ret);
        return ret;
    }

    public static int count() {
        Object countAttr = servletRequestThreadLocal.get().getAttribute(standardCountVar);
        if (countAttr == null) {
            return -1;
        }
        return (Integer)countAttr;
    }

    public static int maxCount() {
        Object maxAttr = servletRequestThreadLocal.get().getAttribute(standardMaxCountVar);
        if (maxAttr == null) {
            return -1;
        }
        return (Integer)maxAttr;
    }

    public static int maxResults() {
        ServletRequest servletRequest = servletRequestThreadLocal.get();
        Object totalAttr = servletRequest.getAttribute(standardMaxResultsVar);
        if (totalAttr == null) {
            return -1;
        }
        Integer total = (Integer)totalAttr;
        if (total == Integer.MIN_VALUE) {
            PageContext pageContext = (PageContext)servletRequest.getAttribute(standardMaxResultsContext);
            MultipleKey keyMaxResults = (MultipleKey)servletRequest.getAttribute(standardMaxResultsKey);
            try {
                QueryExecution exec = QueryExecution.getFor(keyMaxResults, pageContext, null, null);
                exec.getIterationGroupData();
                total = (Integer)exec.currentListData().get("col1");
                servletRequest.setAttribute(standardMaxResultsVar, (Object)total);
            }
            catch (LogicException e) {
                e.printStackTrace();
                throw new RuntimeWrappedException(e);
            }
        }
        return total;
    }

    public static int lastCount() {
        if (servletRequestThreadLocal.get() == null) {
            return -1;
        }
        return (Integer)servletRequestThreadLocal.get().getAttribute(standardLastCountVar);
    }

    public boolean canHaveBody() {
        return true;
    }

    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.execution = null;
        this.queryProps[3] = null;
        this.queryProps[2] = null;
        this.queryProps[1] = null;
        this.queryProps[0] = null;
        this.limit = null;
        this.offset = null;
        this.maxCountVar = null;
        this.countVar = null;
        this.separator = "";
    }
}

