/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.tags;

import javax.servlet.jsp.JspException;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.commons.MultipleKey;
import org.makumba.list.tags.QueryTag;

public class ResultListTag
extends QueryTag {
    private static final long serialVersionUID = 1L;
    private String resultsFrom;

    public void setResultsFrom(String s) {
        this.resultsFrom = s;
    }

    public int doAnalyzedStartTag(PageCache pageCache) throws LogicException, JspException {
        this.setFieldsFromSearchFormInfo(pageCache);
        String[] attributesToCheck = new String[]{"VariableFrom", "Where"};
        for (int i = 0; i < attributesToCheck.length; ++i) {
            String thisAttribute = this.resultsFrom + attributesToCheck[i];
            if (this.pageContext.getRequest().getAttribute(thisAttribute) != null) continue;
            throw new ProgrammerError("Attribute '" + thisAttribute + "' not found. Please make sure you have a correct 'searchForm' tag before this 'resultList' tag.");
        }
        return super.doAnalyzedStartTag(pageCache);
    }

    public void doStartAnalyze(PageCache pageCache) {
        this.setFieldsFromSearchFormInfo(pageCache);
        super.doStartAnalyze(pageCache);
    }

    private void setFieldsFromSearchFormInfo(PageCache pageCache) {
        TagData tag = (TagData)pageCache.retrieve("org.makumba.tagData", new MultipleKey(new Object[]{this.resultsFrom}));
        if (tag != null) {
            this.setFrom(tag.attributes.get("in") + " " + "o");
            tag.attributes.put("from", this.queryProps[0]);
        } else if (this.queryProps[0] == null) {
            throw new ProgrammerError("Could not find search form '" + this.resultsFrom + "' in this page. Please check the name is correct, or if the search form is on a different page, please specify the type to be searched with the from=\"\" attribute.");
        }
        this.setVariableFrom("#{" + this.resultsFrom + "VariableFrom" + "}");
        this.setWhere("#{" + this.resultsFrom + "Where" + "}");
        if (tag != null) {
            tag.attributes.put("where", this.queryProps[1]);
            tag.attributes.put("variableFrom", this.queryProps[4]);
        }
    }

    public void setTagKey(PageCache pageCache) {
        this.setFieldsFromSearchFormInfo(pageCache);
        super.setTagKey(pageCache);
    }
}

