/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import org.makumba.commons.ClassResource;

public class Configuration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String defaultDataDefinitionProvider = "org.makumba.providers.datadefinition.makumba.MakumbaDataDefinitionFactory";
    private String defaultTransactionProvider = "org.makumba.db.makumba.MakumbaTransactionProvider";
    private static Properties controllerConfig = new Properties();
    private String dataDefinitionProvider = null;

    public Configuration() {
        String defaultTransactionProvider;
        if (controllerConfig != null && (defaultTransactionProvider = (String)controllerConfig.get("defaultTransactionProvider")) != null) {
            this.defaultTransactionProvider = defaultTransactionProvider;
        }
    }

    private String getDefaultDataDefinitionProviderClass() {
        return defaultDataDefinitionProvider;
    }

    public String getDataDefinitionProviderClass() {
        return this.dataDefinitionProvider == null ? this.getDefaultDataDefinitionProviderClass() : this.dataDefinitionProvider;
    }

    public String getDefaultTransactionProviderClass() {
        return this.defaultTransactionProvider;
    }

    public void setDataDefinitionProvider(String ddp) {
        this.dataDefinitionProvider = ddp;
    }

    public void setDefaultTransactionProvider(String defaultTransactionProvider) {
        this.defaultTransactionProvider = defaultTransactionProvider;
    }

    public static String getClientSideValidationDefault() {
        return "live";
    }

    public static boolean getReloadFormOnErrorDefault() {
        return false;
    }

    public static String getCalendarEditorDefault() {
        return "false";
    }

    static {
        try {
            URL controllerURL = ClassResource.get("MakumbaController.properties");
            controllerConfig.load(controllerURL.openStream());
        }
        catch (Exception e) {
            controllerConfig = null;
        }
    }
}

