/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AndQueryExp;
import javax.management.AttributeValueExp;
import javax.management.BetweenQueryExp;
import javax.management.BinaryOpValueExp;
import javax.management.BinaryRelQueryExp;
import javax.management.BooleanValueExp;
import javax.management.ClassAttributeValueExp;
import javax.management.InQueryExp;
import javax.management.MatchQueryExp;
import javax.management.NotQueryExp;
import javax.management.NumericValueExp;
import javax.management.OrQueryExp;
import javax.management.QualifiedAttributeValueExp;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class Query {
    public static final int DIV = 3;
    public static final int EQ = 4;
    public static final int GE = 2;
    public static final int GT = 0;
    public static final int LE = 3;
    public static final int LT = 1;
    public static final int MINUS = 1;
    public static final int PLUS = 0;
    public static final int TIMES = 2;

    public static QueryExp and(QueryExp first, QueryExp second) {
        return new AndQueryExp(first, second);
    }

    public static QueryExp anySubString(AttributeValueExp attr, StringValueExp string) {
        return new MatchQueryExp(attr, "*" + string.getValue() + "*");
    }

    public static AttributeValueExp attr(String value) {
        return new AttributeValueExp(value);
    }

    public static AttributeValueExp attr(String className, String value) {
        return new QualifiedAttributeValueExp(className, value);
    }

    public static QueryExp between(ValueExp test, ValueExp lower, ValueExp higher) {
        return new BetweenQueryExp(test, lower, higher);
    }

    public static AttributeValueExp classattr() {
        return new ClassAttributeValueExp();
    }

    public static ValueExp div(ValueExp first, ValueExp second) {
        return new BinaryOpValueExp(3, first, second);
    }

    public static QueryExp eq(ValueExp first, ValueExp second) {
        return new BinaryRelQueryExp(4, first, second);
    }

    public static QueryExp finalSubString(AttributeValueExp attr, StringValueExp string) {
        return new MatchQueryExp(attr, "*" + string.getValue());
    }

    public static QueryExp geq(ValueExp first, ValueExp second) {
        return new BinaryRelQueryExp(2, first, second);
    }

    public static QueryExp gt(ValueExp first, ValueExp second) {
        return new BinaryRelQueryExp(0, first, second);
    }

    public static QueryExp in(ValueExp test, ValueExp[] list) {
        return new InQueryExp(test, list);
    }

    public static QueryExp initialSubString(AttributeValueExp attr, StringValueExp string) {
        return new MatchQueryExp(attr, string.getValue() + "*");
    }

    public static QueryExp leq(ValueExp first, ValueExp second) {
        return new BinaryRelQueryExp(3, first, second);
    }

    public static QueryExp lt(ValueExp first, ValueExp second) {
        return new BinaryRelQueryExp(1, first, second);
    }

    public static QueryExp match(AttributeValueExp attr, StringValueExp string) {
        return new MatchQueryExp(attr, string.getValue());
    }

    public static ValueExp minus(ValueExp first, ValueExp second) {
        return new BinaryOpValueExp(1, first, second);
    }

    public static QueryExp not(QueryExp expression) {
        return new NotQueryExp(expression);
    }

    public static QueryExp or(QueryExp first, QueryExp second) {
        return new OrQueryExp(first, second);
    }

    public static ValueExp plus(ValueExp first, ValueExp second) {
        return new BinaryOpValueExp(0, first, second);
    }

    public static ValueExp times(ValueExp first, ValueExp second) {
        return new BinaryOpValueExp(2, first, second);
    }

    public static ValueExp value(boolean value) {
        return new BooleanValueExp(new Boolean(value));
    }

    public static ValueExp value(double value) {
        return new NumericValueExp(new Double(value));
    }

    public static ValueExp value(float value) {
        return new NumericValueExp(new Double(value));
    }

    public static ValueExp value(int value) {
        return new NumericValueExp(new Long(value));
    }

    public static ValueExp value(long value) {
        return new NumericValueExp(new Long(value));
    }

    public static ValueExp value(Number value) {
        return new NumericValueExp(value);
    }

    public static StringValueExp value(String value) {
        return new StringValueExp(value);
    }
}

