/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.xml.transform.TransformerConfigurationException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.makumba.ConfigFileError;
import org.makumba.MakumbaSystem;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NameResolver;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.db.hibernate.MddToClass;
import org.makumba.db.hibernate.MddToMapping;
import org.makumba.providers.TransactionProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSFManager {
    private static final String PREFIX = "makumbaGeneratedMappings";
    private static final String SEED = "SEED.txt";
    private static Vector<String> externalConfigurationResources = new Vector();
    private static Configuration configuredConfiguration;
    private static SessionFactory sf;
    private static Vector<String> generatedClasses;
    public static int sessionFactories;

    public static String findClassesRootFolder(String locatorSeed) {
        String rootFolder = "";
        try {
            rootFolder = new File(ClassResource.get(locatorSeed).getFile()).getParentFile().getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rootFolder;
    }

    public static SessionFactory getSF(String cfgFilePath) {
        return (SessionFactory)NamedResources.getStaticCache(sessionFactories).getResource(cfgFilePath);
    }

    private static SessionFactory makeSF(String cfgFilePath) {
        StringTokenizer st;
        if (sf != null) {
            return sf;
        }
        cfgFilePath = cfgFilePath + ".cfg.xml";
        Logger.getLogger("org.makumba.hibernate.sf").info("Makumba Hibernate SessionFactory manager, Hibernate " + MakumbaSystem.getHibernateVersionNumber() + ", configuration in " + cfgFilePath);
        Configuration cfg = new Configuration().configure(cfgFilePath);
        for (String res : externalConfigurationResources) {
            cfg.addResource(res);
        }
        String seed = cfg.getProperty("makumba.seed");
        if (seed == null) {
            seed = SEED;
        }
        String seedDir = HibernateSFManager.findClassesRootFolder(seed);
        Logger.getLogger("org.makumba.hibernate.sf").info("Generating classes under " + seedDir);
        String prefix = cfg.getProperty("makumba.prefix");
        if (prefix == null) {
            prefix = PREFIX;
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("Generating mappings under " + seedDir + File.separator + prefix);
        Vector<Object> dds = new Vector();
        String mddList = cfg.getProperty("makumba.mdd.list");
        if (mddList != null) {
            dds = new Vector();
            Logger.getLogger("org.makumba.hibernate.sf").info("Working with the MDDs " + mddList);
            st = new StringTokenizer(mddList, ",");
            while (st.hasMoreTokens()) {
                dds.addElement(st.nextToken().trim());
            }
        } else {
            mddList = cfg.getProperty("makumba.mdd.additionalList");
            if (mddList != null) {
                dds = HibernateSFManager.getDefaultMDDs(cfg);
                Logger.getLogger("org.makumba.hibernate.sf").info("Working with additional MDDs " + mddList);
                st = new StringTokenizer(mddList, ",");
                while (st.hasMoreTokens()) {
                    dds.addElement(st.nextToken().trim());
                }
            } else {
                dds = HibernateSFManager.getDefaultMDDs(cfg);
            }
        }
        dds.add("org.makumba.controller.ErrorLog");
        dds.add("org.makumba.controller.MultipleSubmit");
        Logger.getLogger("org.makumba.hibernate.sf").info("Generating classes");
        String databaseProperties = cfgFilePath.substring(0, cfgFilePath.indexOf(".cfg.xml")) + ".properties";
        Properties p = new Properties();
        try {
            p.load(ClassResource.get(databaseProperties).openStream());
        }
        catch (Exception e) {
            throw new ConfigFileError(databaseProperties);
        }
        NameResolver nr = new NameResolver(p);
        try {
            MddToClass jot = new MddToClass(dds, seedDir, nr);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("Generating mappings");
        try {
            MddToMapping xot = new MddToMapping(dds, cfg, HibernateSFManager.findClassesRootFolder(seed), prefix, nr);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("building session factory");
        SessionFactory sessionFactory = cfg.buildSessionFactory();
        if ("true".equals(cfg.getProperty("makumba.schemaUpdate"))) {
            Logger.getLogger("org.makumba.hibernate.sf").info("Peforming schema update");
            SchemaUpdate schemaUpdate = new SchemaUpdate(cfg);
            schemaUpdate.execute(true, true);
            Logger.getLogger("org.makumba.hibernate.sf").info("Schema update finished");
        } else {
            Logger.getLogger("org.makumba.hibernate.sf").info("skipping schema update");
        }
        configuredConfiguration = cfg;
        generatedClasses = dds;
        Logger.getLogger("org.makumba.hibernate.sf").info("Generated the classes " + dds);
        return sessionFactory;
    }

    private static Vector<String> getDefaultMDDs(Configuration cfg) {
        String mddRoot = cfg.getProperty("makumba.mdd.root");
        if (mddRoot == null) {
            mddRoot = "dataDefinitions";
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("Working with the MDDs under " + mddRoot);
        Vector<String> dds = MakumbaSystem.mddsInDirectory(mddRoot);
        return dds;
    }

    public static synchronized SessionFactory getSF() {
        String defaultDataSourceName = TransactionProvider.getInstance().getDefaultDataSourceName();
        String configFile = defaultDataSourceName == null ? "default" : defaultDataSourceName;
        Logger.getLogger("org.makumba.hibernate.sf").info("Initializing configuration from " + configFile);
        return HibernateSFManager.getSF(configFile);
    }

    public static Configuration getConfiguration(String cfgFilePath) {
        Configuration cfg = new Configuration().configure(cfgFilePath);
        return cfg;
    }

    public static Configuration getConfiguredConfiguration() {
        return configuredConfiguration;
    }

    public static void setExternalConfigurationResources(Vector<String> resources) {
        externalConfigurationResources = resources;
    }

    public static void setHibernateSessionFactory(SessionFactory sessionFactory) {
        sf = sessionFactory;
    }

    public static String getFullyQualifiedName(String className) {
        return (String)configuredConfiguration.getImports().get(className);
    }

    public static Vector<String> getGeneratedClasses() {
        return generatedClasses;
    }

    static {
        sessionFactories = NamedResources.makeStaticCache("hibernate session factory", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            protected Object makeResource(Object nm, Object hashName) throws Exception {
                return HibernateSFManager.makeSF((String)nm);
            }
        }, false);
    }
}

