/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import org.apache.commons.lang.StringUtils;
import org.makumba.FieldDefinition;
import org.makumba.Pointer;

public class InvalidValueException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected String field;
    private FieldDefinition fieldDefinition;
    protected String shortMessage;

    public InvalidValueException(String message) {
        super(message);
    }

    public InvalidValueException(String field, String message) {
        super("Invalid value for " + field + ": " + message);
        this.field = field;
        this.shortMessage = message;
    }

    public InvalidValueException(FieldDefinition fi, String message) {
        this(fi.getDataDefinition().getName() + "#" + fi.getName(), message);
        this.fieldDefinition = fi;
        this.shortMessage = message;
    }

    public InvalidValueException(FieldDefinition fi, Class requiredClass, Object value) {
        this(fi, "Required Java type:" + requiredClass.getName() + " ; given value: " + value + " of type " + value.getClass().getName());
        this.fieldDefinition = fi;
    }

    public InvalidValueException(FieldDefinition fi, String requiredType, Pointer wrongPointer) {
        this(fi, "Required poiter type:" + requiredType + " ; given value: " + wrongPointer);
        this.fieldDefinition = fi;
    }

    public InvalidValueException(Pointer comparedPointer, Pointer wrongPointer) {
        super("Compared pointer: " + comparedPointer + " ; given value: " + wrongPointer);
    }

    public String getFieldName() {
        if (this.fieldDefinition != null) {
            return this.fieldDefinition.getName();
        }
        if (this.field != null) {
            return this.field;
        }
        return null;
    }

    public String getShortMessage() {
        if (StringUtils.isNotEmpty((String)this.shortMessage)) {
            return this.shortMessage;
        }
        return this.getMessage();
    }
}

