/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.HibernateSFManager;
import org.makumba.MakumbaError;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.Transaction;
import org.makumba.commons.NameResolver;
import org.makumba.commons.SQLPointer;
import org.makumba.db.hibernate.HibernateTransaction;
import org.makumba.providers.CRUDOperationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCRUDOperationProvider
extends CRUDOperationProvider {
    private NameResolver nr = new NameResolver();

    @Override
    public void checkInsert(Transaction t, String type, Dictionary fieldsToCheck, Dictionary fieldsToIgnore, Dictionary allFields) {
        DataDefinition dd = this.ddp.getDataDefinition(type);
        dd.checkFieldNames(fieldsToCheck);
        Enumeration<String> e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            Object o;
            String name = e.nextElement();
            if (fieldsToIgnore.get(name) != null || (o = fieldsToCheck.get(name)) == null) continue;
            dd.getFieldDefinition(name).checkInsert(fieldsToCheck);
            fieldsToCheck.put(name, dd.getFieldDefinition(name).checkValue(o));
        }
    }

    @Override
    public void checkUpdate(Transaction t, String type, Pointer pointer, Dictionary fieldsToCheck, Dictionary fieldsToIgnore, Dictionary allFields) {
        DataDefinition dd = this.checkUpdate(type, fieldsToCheck, fieldsToIgnore);
    }

    @Override
    public Pointer insert(Transaction t, String type, Dictionary data) {
        try {
            Object baseObject;
            HibernateTransaction ht = (HibernateTransaction)t;
            DataDefinition dd = this.ddp.getDataDefinition(type);
            String name = this.nr.arrowToDoubleUnderscore(dd.getName());
            if (dd.getName().indexOf("->") > -1 && HibernateSFManager.getFullyQualifiedName(name) == null) {
                FieldDefinition fi = dd.getParentField();
                Pointer base = (Pointer)data.get(dd.getParentField().getDataDefinition().getName());
                Class<?> c = this.getPointerClass(base.getType());
                baseObject = this.getPointedObject(t, c, base);
                String fieldNameInClass = this.getFieldNameInClass(c, fi.getName());
                Method m = c.getMethod("get" + fieldNameInClass, new Class[0]);
                HashSet col = (HashSet)m.invoke(baseObject, new Object[0]);
                if (col == null) {
                    col = new HashSet();
                    m = c.getMethod("set" + fieldNameInClass, Collection.class);
                    m.invoke(baseObject, col);
                }
                Enumeration e = data.elements();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (o instanceof Pointer && ((Pointer)o).equals(base)) continue;
                    if (o instanceof Text) {
                        o = ((Text)o).toString();
                    }
                    col.add(o);
                }
            } else {
                Class<?> recordClass = null;
                recordClass = Class.forName(HibernateSFManager.getFullyQualifiedName(name));
                Object newRecord = null;
                newRecord = recordClass.newInstance();
                this.fillObject(t, data, dd, recordClass, newRecord);
                if (this.isGenerated(recordClass) && data.get("TS_create") == null) {
                    Class[] classes = new Class[]{Date.class};
                    Object[] now = new Object[]{new Date()};
                    Method m = recordClass.getMethod("setTS_create", classes);
                    m.invoke(newRecord, now);
                    m = recordClass.getMethod("setTS_modify", classes);
                    m.invoke(newRecord, now);
                }
                ht.s.persist(newRecord);
                ht.s.flush();
                Object pointerId = null;
                Class[] noParam = new Class[]{};
                String idMethodName = "getprimaryKey";
                if (!this.isGenerated(recordClass)) {
                    idMethodName = "getId";
                }
                Method getId = recordClass.getMethod(idMethodName, noParam);
                Object[] args = new Object[]{};
                pointerId = getId.invoke(newRecord, args);
                String returnType = getId.getReturnType().getName();
                if (pointerId != null) {
                    return new SQLPointer(type, HibernateCRUDOperationProvider.isInteger(returnType) ? new Long(((Integer)pointerId).intValue()) : (Long)pointerId);
                }
                throw new MakumbaError("Unexpected return type while trying to get ID of inserted record");
            }
            ht.s.saveOrUpdate(baseObject);
            ht.s.flush();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void fillObject(Transaction t, Dictionary data, DataDefinition dd, Class recordClass, Object newRecord) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Enumeration fields = data.keys();
        while (fields.hasMoreElements()) {
            String fieldName = (String)fields.nextElement();
            String fieldNameInClass = this.nr.checkReserved(fieldName);
            Object fieldValue = data.get(fieldName);
            FieldDefinition fd = dd.getFieldDefinition(fieldName);
            Class fieldType = null;
            switch (fd.getIntegerType()) {
                case 4: 
                case 5: {
                    fieldType = Integer.class;
                    if (fieldValue != Pointer.NullInteger) break;
                    fieldValue = null;
                    break;
                }
                case 15: {
                    fieldType = Double.class;
                    if (fieldValue != Pointer.NullReal) break;
                    fieldValue = null;
                    break;
                }
                case 6: 
                case 7: {
                    fieldType = String.class;
                    if (fieldValue != Pointer.NullString) break;
                    fieldValue = null;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    fieldType = Date.class;
                    if (fieldValue != Pointer.NullDate) break;
                    fieldValue = null;
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    fieldType = this.getPointerClass(fd.getPointedType().getName());
                    if (fieldValue == Pointer.Null) {
                        fieldValue = null;
                        break;
                    }
                    Pointer pointer = (Pointer)fieldValue;
                    fieldValue = this.getPointedObject(t, fieldType, pointer);
                    break;
                }
                case 3: {
                    fieldType = Integer.TYPE;
                    if (fieldValue != Pointer.Null) break;
                    fieldValue = null;
                    break;
                }
                case 8: {
                    if (!this.isGenerated(recordClass)) {
                        fieldType = String.class;
                        if ((fieldValue = ((Text)fieldValue).toString()) != Pointer.NullText) break;
                        fieldValue = null;
                        break;
                    }
                }
                case 18: {
                    fieldType = Text.class;
                    if (fieldValue != Pointer.NullText) break;
                    fieldValue = null;
                    break;
                }
                case 19: {
                    fieldType = Boolean.class;
                    if (fieldValue != Pointer.NullBoolean) break;
                    fieldValue = null;
                    break;
                }
                default: {
                    throw new RuntimeException("Unmapped type: " + fd.getName() + "-" + fd.getType());
                }
            }
            Class[] parameterTypes = new Class[]{fieldType};
            Method m = null;
            if (!this.isGenerated(recordClass)) {
                for (Method met : recordClass.getMethods()) {
                    if (!met.getName().toLowerCase().equals("set" + fieldNameInClass.toLowerCase())) continue;
                    fieldNameInClass = met.getName().substring(3);
                    parameterTypes = new Class[]{met.getParameterTypes()[0]};
                    break;
                }
            }
            m = recordClass.getMethod("set" + fieldNameInClass, parameterTypes);
            m.invoke(newRecord, fieldValue);
        }
    }

    private Object getPointedObject(Transaction t, Class pointerClass, Pointer pointer) {
        return ((HibernateTransaction)t).s.get(pointerClass, this.getTypedId(pointerClass, pointer));
    }

    private Class<?> getPointerClass(String type) throws ClassNotFoundException {
        return Class.forName(this.nr.arrowToDoubleUnderscore(HibernateSFManager.getFullyQualifiedName(type)));
    }

    @Override
    public void updateSet1(Transaction t, Pointer base, FieldDefinition fi, Object val) {
        if (fi.getType().equals("set")) {
            try {
                Collection values = (Collection)val;
                if (values.isEmpty()) {
                    return;
                }
                HibernateTransaction ht = (HibernateTransaction)t;
                Class<?> c = this.getPointerClass(base.getType());
                Object baseObject = this.getPointedObject(t, c, base);
                Method m = c.getMethod("get" + this.getFieldNameInClass(c, fi.getName()), new Class[0]);
                HashSet<Object> col = (HashSet<Object>)m.invoke(baseObject, new Object[0]);
                if (col == null) {
                    col = new HashSet<Object>();
                    m = c.getMethod("set" + fi.getName(), Collection.class);
                    m.invoke(baseObject, col);
                }
                for (Pointer p : values) {
                    Class<?> c1 = this.getPointerClass(p.getType());
                    col.add(this.getPointedObject(t, c1, p));
                }
                ht.s.saveOrUpdate(baseObject);
                ht.s.flush();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            super.updateSet1(t, base, fi, val);
        }
    }

    @Override
    public void deleteSet(Transaction t, Pointer base, FieldDefinition fi) {
        if (fi.getType().equals("set")) {
            try {
                HibernateTransaction ht = (HibernateTransaction)t;
                Class<?> c = this.getPointerClass(base.getType());
                Object baseObject = this.getPointedObject(t, c, base);
                String fieldNameInClass = fi.getName();
                Class[] parameterTypes = new Class[]{Collection.class};
                if (!this.isGenerated(c)) {
                    for (Method met : c.getMethods()) {
                        if (!met.getName().toLowerCase().equals("set" + fieldNameInClass.toLowerCase())) continue;
                        fieldNameInClass = met.getName().substring(3);
                        parameterTypes = new Class[]{met.getParameterTypes()[0]};
                        break;
                    }
                }
                Method m = c.getMethod("set" + fieldNameInClass, parameterTypes);
                m.invoke(baseObject, new ArrayList());
                ht.s.saveOrUpdate(baseObject);
                ht.s.flush();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            super.deleteSet(t, base, fi);
        }
    }

    @Override
    public void update1(Transaction t, Pointer p, DataDefinition dd, Dictionary dic) {
        if (dic.isEmpty()) {
            return;
        }
        try {
            HibernateTransaction ht = (HibernateTransaction)t;
            String name = this.nr.arrowToDoubleUnderscore(dd.getName());
            Class<?> recordClass = null;
            recordClass = Class.forName(HibernateSFManager.getFullyQualifiedName(name));
            Object record = null;
            record = ht.s.get(recordClass, this.getTypedId(recordClass, p));
            this.fillObject(t, dic, dd, recordClass, record);
            if (this.isGenerated(recordClass)) {
                Class[] classes = new Class[]{Date.class};
                Object[] now = new Object[]{new Date()};
                Method m = recordClass.getMethod("setTS_modify", classes);
                m.invoke(record, now);
            }
            ht.s.saveOrUpdate(record);
            ht.s.flush();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private boolean isGenerated(Class clazz) {
        for (String s : HibernateSFManager.getGeneratedClasses()) {
            if (!s.equals(clazz.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private String getFieldNameInClass(Class clazz, String fieldName) {
        if (!this.isGenerated(clazz)) {
            for (Method met : clazz.getMethods()) {
                if (!met.getName().toLowerCase().equals("get" + fieldName.toLowerCase())) continue;
                return met.getName().substring(3);
            }
        }
        return fieldName;
    }

    private Serializable getTypedId(Class clazz, Pointer p) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals("getId") && !m.getName().equals("getprimaryKey")) continue;
            if (HibernateCRUDOperationProvider.isInteger(m.getReturnType().getName())) {
                return Integer.valueOf(p.getId());
            }
            if (!HibernateCRUDOperationProvider.isLong(m.getReturnType().getName())) continue;
            return Long.valueOf(p.longValue());
        }
        return Integer.valueOf(p.getId());
    }

    public static boolean isInteger(String name) {
        return name.equals("int") || name.indexOf("Integer") > -1;
    }

    public static boolean isLong(String name) {
        return name.equals("long") || name.indexOf("Long") > -1;
    }
}

