/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.makumba.commons.ClassResource;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.SourceViewer;
import org.makumba.devel.javaViewer;
import org.makumba.devel.mddViewer;
import org.makumba.devel.relations.FileRelations;
import org.makumba.devel.relations.RelationCrawler;
import org.makumba.providers.datadefinition.makumba.RecordParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LineViewer
implements SourceViewer {
    private static final String TYPE_JAVA = "Java";
    private static final String TYPE_JSP = "JSPs";
    private static final String TYPE_MDD = "MDD";
    private static final Pattern patternUrl = Pattern.compile("[http:|/|\\w]+\\.\\w+[\\.\\w]*[/|\\w]*");
    protected static final String PARAM_HIDE_LINES = "hideLines";
    protected ServletContext servletContext;
    protected String realPath;
    protected String virtualPath;
    protected String contextPath;
    protected Reader reader;
    protected boolean printLineNumbers;
    private File dir;
    protected String title;
    protected boolean searchJSPPages = true;
    protected boolean searchCompiledJSPClasses = true;
    protected boolean searchJavaClasses = true;
    protected boolean searchMDD = true;
    protected String jspSourceViewExtension = "x";
    protected String jspClasspath;
    protected HttpServletRequest request;
    protected HttpServlet servlet;
    protected String servletPath;
    protected String logicPath;
    protected String codeBackgroundStyle = "";
    protected boolean hideLineNumbers = false;
    protected String[] importedPackages = new String[]{"java.lang."};
    protected Hashtable importedClasses = new Hashtable();
    protected Error caughtError;
    protected boolean printHeaderFooter = true;
    private String versionControlRepositoryURL;
    private String versionControlRepositoryLinkText = "CVS";

    protected void addImportedPackages(HashSet<String> newPackages) {
        newPackages.addAll(Arrays.asList(this.importedPackages));
        this.importedPackages = newPackages.toArray(new String[newPackages.size()]);
    }

    @Override
    public File getDirectory() {
        if (this.dir != null && this.dir.isDirectory()) {
            return this.dir;
        }
        return null;
    }

    public Reader getReader() {
        return this.reader;
    }

    void readFromURL(URL u) throws IOException {
        if (u == null) {
            throw new FileNotFoundException(this.virtualPath);
        }
        this.realPath = u.getFile();
        try {
            this.dir = new File(this.realPath);
            if (!this.dir.isDirectory()) {
                this.reader = new InputStreamReader(new FileInputStream(this.dir));
            }
        }
        catch (FileNotFoundException fnfe) {
            this.realPath = null;
            this.reader = new InputStreamReader((InputStream)u.getContent());
        }
    }

    public LineViewer(boolean printLineNumbers, HttpServletRequest request, HttpServlet servlet) {
        this.request = request;
        this.servlet = servlet;
        this.printLineNumbers = printLineNumbers;
        this.versionControlRepositoryURL = servlet.getServletConfig().getInitParameter("repositoryURL");
        if (this.versionControlRepositoryURL != null && !this.versionControlRepositoryURL.endsWith("/")) {
            this.versionControlRepositoryURL = this.versionControlRepositoryURL + "/";
        }
        if (servlet.getServletConfig().getInitParameter("repositoryLinkText") != null) {
            this.versionControlRepositoryLinkText = servlet.getServletConfig().getInitParameter("repositoryLinkText");
        }
        this.servletContext = servlet.getServletContext();
        this.contextPath = request.getContextPath();
        this.hideLineNumbers = request.getParameter(PARAM_HIDE_LINES) != null && request.getParameter(PARAM_HIDE_LINES).equals("true");
    }

    public LineViewer(boolean printLineNumbers, HttpServletRequest request, ServletContext servletContext) {
        this.request = request;
        this.printLineNumbers = printLineNumbers;
        this.servletContext = servletContext;
        this.contextPath = request.getContextPath();
        this.hideLineNumbers = request.getParameter(PARAM_HIDE_LINES) != null && request.getParameter(PARAM_HIDE_LINES).equals("true");
    }

    @Override
    public void parseText(PrintWriter writer) throws IOException {
        long begin = System.currentTimeMillis();
        this.printPageBegin(writer);
        if (this.caughtError != null) {
            this.setSearchLevels(true, true, true, true);
            writer.println(this.parseLine("There were errors analyzing the page - the page analysis reports an <i>" + this.caughtError.getClass().getName() + "</i>") + "\n");
            writer.println("<span style=\"color: red    ; \">" + this.caughtError.getMessage() + "</span>");
            writer.print("<hr color:\"red\" style=\"background-color: red; border-width: 0px;\">");
        }
        LineNumberReader lr = new LineNumberReader(this.reader);
        String s = null;
        while ((s = lr.readLine()) != null) {
            if (this.printLineNumbers && !this.hideLineNumbers) {
                int n = lr.getLineNumber();
                writer.print("<a name=\"" + n + "\" href=\"#" + n + "\" class=\"lineNo\">" + n + ":\t</a>");
            }
            if (this instanceof mddViewer) {
                this.printLine(writer, s, this.parseLine(s));
                continue;
            }
            this.printLine(writer, s, this.parseLine(this.htmlEscape(s)));
        }
        this.printPageEnd(writer);
        this.reader.close();
        double timeTaken = System.currentTimeMillis() - begin;
        Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").fine("Sourcecode viewer took :" + timeTaken / 1000.0 + " seconds");
    }

    public void printPageEnd(PrintWriter writer) throws IOException {
        writer.println("\n</pre>");
        this.footer(writer);
        if (this.printHeaderFooter) {
            writer.println("\n</body></html>");
        }
    }

    public void printPageBegin(PrintWriter writer) throws IOException {
        if (this.realPath != null && this.virtualPath != null) {
            this.title = this.virtualPath + "";
        } else if (StringUtils.isBlank((String)this.title)) {
            this.title = "";
        }
        if (this.printHeaderFooter) {
            DevelUtils.writePageBegin(writer);
            DevelUtils.writeStylesAndScripts(writer, this.contextPath);
            if (this.printLineNumbers && !this.hideLineNumbers) {
                writer.println("<style type=\"text/css\">");
                writer.println("A.lineNo {color:navy; background-color:lightblue; text-decoration:none; cursor:default;}");
                writer.println("pre.code {margin-top:0; " + this.codeBackgroundStyle + "}");
                writer.println("a.classLink {border-bottom:thin dotted; text-decoration: none; color: #000066}");
                writer.println("</style>\n");
            }
            DevelUtils.writeTitleAndHeaderEnd(writer, this.title);
            DevelUtils.printPageHeader(writer, this.title, this.virtualPath, this.realPath, this.printVersionControlLink());
            this.printPageBeginAdditional(writer);
            if (this.printLineNumbers) {
                String urlParams = "";
                Enumeration e = this.request.getParameterNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = this.request.getParameter(key);
                    if (key.equals(PARAM_HIDE_LINES)) continue;
                    if (!urlParams.equals("")) {
                        urlParams = urlParams + "&";
                    }
                    urlParams = urlParams + key + "=" + value;
                }
                if (!urlParams.equals("")) {
                    urlParams = urlParams + "&";
                }
                if (!(urlParams = urlParams + "hideLines=" + !this.hideLineNumbers).equals("")) {
                    urlParams = "?" + urlParams;
                }
                String link = this.request.getRequestURI() + urlParams;
                writer.println("<div style=\"font-size: smaller; vertical-align: bottom;\">");
                writer.print("<a href=\"" + link + "\">");
                if (this.hideLineNumbers) {
                    writer.print("Show");
                } else {
                    writer.print("Hide");
                }
                writer.println(" line numbers</a>");
                this.writeAdditionalLinks(writer);
                writer.println("</div>");
            }
            writer.println("</td>");
            this.intro(writer);
            writer.println("</tr>");
            writer.println("</table>");
        }
        writer.print("<pre class=\"code\">");
    }

    protected void printFileRelations(PrintWriter writer) {
        writer.println("<a href=\"javascript:toggleFileRelationsDisplay();\">Relations</a>");
        writer.println("<div id=\"fileRelations\" style=\"display:none; padding: 5px; position: absolute; top: 88px; background-color: lightblue\">");
        String webAppRoot = this.servletContext.getRealPath("/");
        int maxDisplay = 10;
        if (webAppRoot.endsWith("/")) {
            webAppRoot = webAppRoot.substring(0, webAppRoot.length() - 1);
        }
        RelationCrawler relationCrawler = RelationCrawler.getRelationCrawler(webAppRoot, "", false, "", "");
        if (this.realPath.startsWith(webAppRoot)) {
            String filePath = this.realPath.substring(webAppRoot.length());
            FileRelations fileDependents = relationCrawler.getFileDependents(filePath);
            this.printRelations(writer, fileDependents.getMddRelations(), TYPE_MDD, maxDisplay);
            this.printRelations(writer, fileDependents.getJspRelations(), TYPE_JSP, maxDisplay);
            this.printRelations(writer, fileDependents.getJavaRelations(), TYPE_JAVA, maxDisplay);
            if (fileDependents.isEmpty()) {
                writer.println("No relations found for this file!");
            }
        } else {
            writer.println("Could not crawl relations, file not in webapp root!");
        }
        writer.println("</div>");
    }

    private void printRelations(PrintWriter writer, Map<String, Vector<FileRelations.RelationOrigin>> map, String fileType, int maxDisplay) {
        if (map.size() > 0) {
            writer.println("<b>" + fileType + "</b><br>");
            int count = 0;
            for (String key : map.keySet()) {
                if (maxDisplay != -1 && ++count > maxDisplay) {
                    writer.print("<a href=\"\" style=\"color:grey; font-size:smaller\">" + (map.size() - maxDisplay) + " more ...</a><br>");
                    break;
                }
                Vector<FileRelations.RelationOrigin> occurrences = map.get(key);
                FileRelations.RelationOrigin firstElement = occurrences.firstElement();
                String path = this.getPath(key, fileType);
                String display = this.getDisplay(key, fileType);
                if (fileType.equals(TYPE_JSP)) {
                    writer.println("<a href=\"" + path + "#" + firstElement.getStartLine() + "\" style=\"font-size:smaller\">" + display + " #" + firstElement.getStartLine() + "</a>");
                    for (int i = 1; i < occurrences.size(); ++i) {
                        FileRelations.RelationOrigin origin = occurrences.elementAt(i);
                        writer.println("<a href=\"" + path + "#" + origin.getStartLine() + "\" style=\"font-size:smaller\">" + "#" + origin.getStartLine() + "</a>");
                    }
                } else {
                    writer.println("<a href=\"" + path + "\" style=\"font-size:smaller\">" + display + "</a> (" + occurrences.size() + "x)");
                }
                writer.println("<br>");
            }
        }
    }

    private String getPath(String fileName, String fileType) {
        if (fileType.equals(TYPE_JSP)) {
            return this.contextPath + "/" + fileName + "x";
        }
        if (fileType.equals(TYPE_MDD)) {
            fileName = this.removeFilenamePrefixes(fileName);
            return this.contextPath + "/dataDefinitions/" + fileName.replaceAll(".mdd", "").replaceAll("/", ".");
        }
        if (fileType.equals(TYPE_JAVA)) {
            fileName = this.removeFilenamePrefixes(fileName);
            return this.contextPath + "/classes/" + fileName;
        }
        return fileName;
    }

    private String getDisplay(String fileName, String fileType) {
        if (fileType.equals("JSP")) {
            return fileName;
        }
        if (fileType.equals(TYPE_MDD)) {
            fileName = this.removeFilenamePrefixes(fileName);
            return fileName.replaceAll(".mdd", "").replaceAll("/", ".");
        }
        if (fileType.equals(TYPE_JAVA)) {
            fileName = this.removeFilenamePrefixes(fileName);
            return fileName.replaceAll(".java", "").replaceAll("/", ".");
        }
        return fileName;
    }

    private String removeFilenamePrefixes(String fileName) {
        if (fileName.startsWith("WEB-INF/")) {
            fileName = fileName.substring("WEB-INF/".length());
        }
        if (fileName.startsWith("classes/")) {
            fileName = fileName.substring("classes/".length());
        }
        if (fileName.startsWith("dataDefinitions/")) {
            fileName = fileName.substring("dataDefinitions/".length());
        }
        return fileName;
    }

    protected void intro(PrintWriter printWriter) throws IOException {
    }

    protected void printPageBeginAdditional(PrintWriter printWriter) throws IOException {
    }

    protected String printVersionControlLink() {
        if (this.versionControlRepositoryURL != null) {
            String path = this.virtualPath;
            if (this instanceof javaViewer) {
                path = "WEB-INF/classes/" + path.replace('.', '/') + ".java";
            } else if (this instanceof mddViewer) {
                String additionalPath = "WEB-INF/classes/";
                if (this.realPath.contains("classes/dataDefinitions")) {
                    additionalPath = additionalPath + "dataDefinitions/";
                }
                path = additionalPath + path.replace('.', '/') + ".mdd";
            }
            return " (<a title=\"See this file in the version control repository\" href=\"" + this.versionControlRepositoryURL + path + "\">" + this.versionControlRepositoryLinkText + "</a>)";
        }
        return "";
    }

    protected void writeAdditionalLinks(PrintWriter writer) {
    }

    public void footer(PrintWriter printWriter) throws IOException {
        DevelUtils.printDeveloperSupportFooter(printWriter);
    }

    public void printLine(PrintWriter printWriter, String s, String toPrint) throws IOException {
        String t = this.getLineTag(s);
        if (t != null) {
            printWriter.print("<a name=\"" + t + "\"></a>");
        }
        printWriter.print(toPrint);
        printWriter.print("\n");
    }

    public String getLineTag(String s) {
        return null;
    }

    public void setSearchLevels(boolean searchJSPPages, boolean searchCompiledJSPClasses, boolean searchJavaClasses, boolean searchMDD) {
        this.searchJSPPages = searchJSPPages;
        this.searchCompiledJSPClasses = searchCompiledJSPClasses;
        this.searchJavaClasses = searchJavaClasses;
        this.searchMDD = searchMDD;
    }

    public String parseLine(String s) {
        StringBuffer source = new StringBuffer(s);
        StringBuffer result = new StringBuffer();
        Matcher matcher = patternUrl.matcher(s);
        while (matcher.find()) {
            String jspClass;
            String jspPage;
            Class javaClass;
            String token = matcher.group();
            int indexOf = source.indexOf(token);
            int indexAfter = indexOf + token.length();
            result.append(source.substring(0, indexOf));
            if (token.indexOf("www.makumba.org") != -1) {
                result.append(this.formatMakumbaLink(token));
            } else if (token.indexOf("java.sun.com") != -1) {
                result.append(this.formatSunTaglibLink(token));
            } else if (this.searchMDD && RecordParser.findDataDefinition(token, "mdd") != null || RecordParser.findDataDefinition(token, "idd") != null) {
                result.append(this.formatMDDLink(token));
            } else if (this.searchJavaClasses && (javaClass = this.findClassSimple(token)) != null) {
                result.append(this.formatClassLink(javaClass.getName(), token, null));
            } else if (this.searchJavaClasses && (javaClass = this.findClass(token)) != null) {
                result.append(this.formatClassLink(javaClass, null, token));
            } else if (this.searchJSPPages && (jspPage = this.findPage(token)) != null) {
                result.append(this.formatJSPLink(jspPage, token, null));
            } else if (this.searchCompiledJSPClasses && (jspClass = this.findCompiledJSP(token)) != null) {
                result.append(this.formatClassLink(jspClass, token, null));
            } else {
                result.append(token);
            }
            source.delete(0, indexAfter);
        }
        return result.append(source).toString();
    }

    public String formatJSPLink(String jspPage, String token, Integer lineNumber) {
        StringBuffer result = new StringBuffer();
        result.append("<a href=\"" + jspPage);
        if (jspPage.endsWith("jsp")) {
            result.append(this.jspSourceViewExtension);
        }
        if (lineNumber != null) {
            result.append("#" + lineNumber);
        }
        result.append("\">").append(token).append("</a>");
        return result.toString();
    }

    public String formatClassLink(String qualifiedClassName, String className, Integer lineNumber) {
        if (lineNumber != null) {
            return "<a href=\"" + this.contextPath + "/classes/" + qualifiedClassName + "#" + lineNumber + "\">" + className + "</a>";
        }
        return "<a href=\"" + this.contextPath + "/classes/" + qualifiedClassName + "\">" + className + "</a>";
    }

    public String formatMDDLink(String mddName) {
        return "<a class=\"classlink\" title=\"DataDefinition '" + mddName + "'\" href=\"" + this.contextPath + "/dataDefinitions/" + mddName + "\">" + mddName + "</a>";
    }

    public String formatMakumbaLink(String token) {
        return "<a href=\"http://www.makumba.org\" target=\"_blank\">" + token + "</a>";
    }

    public String formatSunTaglibLink(String token) {
        if (token.indexOf("java.sun.com/jstl/") != -1 || token.indexOf("http://java.sun.com/jsp/jstl/") != -1) {
            return "<a href=\"http://java.sun.com/products/jsp/jstl/1.1/docs/tlddocs/\" target=\"_blank\">" + token + "</a>";
        }
        return "<a href=\"http://java.sun.com\" target=\"_blank\">" + token + "</a>";
    }

    public StringTokenizer getLineTokenizer(String s) {
        return new StringTokenizer(s, "\"' (){}[]<>,;-?#:", true);
    }

    public String findPage(String s) {
        File file;
        if (s.startsWith("/")) {
            file = new File(this.servletContext.getRealPath(s));
            if (file.exists()) {
                return this.contextPath + s;
            }
            file = new File(s);
            if (file.exists()) {
                return s;
            }
        }
        if (s.startsWith("/")) {
            s = s.substring(s.lastIndexOf("/") + 1);
        }
        if (!s.startsWith("/") && this.realPath != null && (file = new File(this.realPath.substring(0, this.realPath.lastIndexOf(File.separatorChar)) + File.separatorChar + s.replace('/', File.separatorChar))).exists()) {
            return s;
        }
        return null;
    }

    public Class findClassSimple(String s) {
        Class<?> c = null;
        try {
            c = Class.forName(s);
        }
        catch (Throwable t) {
            return null;
        }
        if (ClassResource.get(c.getName().replace('.', '/') + ".java") != null) {
            return c;
        }
        return null;
    }

    public String findCompiledJSP(String s) {
        if (this.jspClasspath != null && s.indexOf("_jsp") != -1) {
            try {
                String newClassName = s.substring(0, s.indexOf("_jsp") + 4);
                String filePath = this.jspClasspath + "/" + newClassName.replace('.', '/') + ".java";
                File file = new File(filePath);
                if (file.exists()) {
                    return newClassName;
                }
                return null;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public String htmlEscape(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }

    public Class findClass(String className) {
        Class<?> c = null;
        String classNameTrial = (String)this.importedClasses.get(className);
        if (classNameTrial != null) {
            try {
                c = Class.forName(classNameTrial);
                return c;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (c == null) {
            for (int i = 0; i < this.importedPackages.length; ++i) {
                try {
                    classNameTrial = this.importedPackages[i] + className;
                    c = Class.forName(classNameTrial);
                    return c;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
        }
        if (className.indexOf(".") != -1) {
            classNameTrial = className.substring(0, className.lastIndexOf("."));
            try {
                int i = 0;
                if (i < this.importedPackages.length) {
                    classNameTrial = this.importedPackages[i] + classNameTrial;
                    c = Class.forName(classNameTrial);
                    return c;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public String formatClassLink(Class c, String methodName, String displayName) {
        if (c != null) {
            String s = "<a class=\"classLink\" href=\"";
            if (c.getName().startsWith("java")) {
                s = s + "http://java.sun.com/j2se/1.4.2/docs/api/" + c.getName().replaceAll("\\.", "/") + ".html";
                if (methodName != null) {
                    s = s + "#" + methodName + "()";
                }
            } else if (c.getName().startsWith("org.makumba")) {
                s = s + "http://www.makumba.org/api/" + c.getName().replaceAll("\\.", "/") + ".html";
                if (methodName != null) {
                    s = s + "#" + methodName + "()";
                }
            } else if (c.getName().startsWith("org.hibernate")) {
                s = s + "http://www.hibernate.org/hib_docs/v3/api/" + c.getName().replaceAll("\\.", "/") + ".html";
                if (methodName != null) {
                    s = s + "#" + methodName + "()";
                }
            } else {
                s = s + this.contextPath + "/classes/" + c.getName().replace('.', '/');
            }
            return s + "\" title=\"" + (methodName != null ? "Method in " : "") + c.getName() + "\">" + displayName + "</a>";
        }
        return null;
    }

    public static void main(String[] args) {
        LineViewer.testLinkDetection();
    }

    private static void testLinkDetection() {
        String p1 = "http://www.makumba.org/presentation";
        String p2 = "mak:object from=\"general.survey.Survey survey\" where=\"survey=$survey\">";
        String p3 = "/layout/header.jsp?title=Statistics for ";
        String p4 = "c:set var=\"viewStatsPage\" value=\"viewStatistics.jsp?survey=";
        String[] patterns = new String[]{p1, p2, p3, p4};
        System.out.println("pattern: " + patternUrl.pattern());
        for (int i = 0; i < patterns.length; ++i) {
            System.out.println("\n!!!trying\n---" + patterns[i] + " ---");
            Matcher m = patternUrl.matcher(patterns[i]);
            while (m.find()) {
                System.out.print(m.group() + " - ");
            }
            System.out.println();
        }
    }
}

