/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.GeneratedCodeViewer;
import org.makumba.devel.LineViewer;
import org.makumba.devel.javaViewer;
import org.makumba.devel.jspViewer;
import org.makumba.devel.logicViewer;
import org.makumba.devel.mddViewer;

public class SourceViewServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_REPOSITORY_URL = "repositoryURL";
    public static final String PARAM_REPOSITORY_LINK_TEXT = "repositoryLinkText";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        PrintWriter w = res.getWriter();
        LineViewer sw = null;
        String servletPath = req.getServletPath();
        try {
            if (servletPath.equals("/dataDefinitions")) {
                sw = new mddViewer(req, this);
            } else if (servletPath.endsWith(".jspx") || servletPath.endsWith(".jsps") || servletPath.endsWith(".jspxp")) {
                sw = new jspViewer(req, this);
            } else if (servletPath.equals("/classes")) {
                sw = new javaViewer(req, this);
            } else if (servletPath.equals("/logic")) {
                sw = new logicViewer(req, this);
            } else if (servletPath.equals("/codeGenerator")) {
                sw = new GeneratedCodeViewer(req, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            res.sendError(404, e.toString());
            return;
        }
        if (sw != null) {
            File dir = sw.getDirectory();
            if (dir == null) {
                res.setContentType("text/html");
                try {
                    sw.parseText(w);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (SourceViewServlet.redirected(req, res, servletPath)) {
                    return;
                }
                if (sw instanceof GeneratedCodeViewer && req.getPathInfo().endsWith("/")) {
                    res.sendRedirect(req.getContextPath() + "/dataDefinitions" + req.getPathInfo());
                    return;
                }
                String relativeDirectory = dir.getName();
                if (dir.getAbsolutePath().indexOf("classes/") != -1) {
                    relativeDirectory = dir.getAbsolutePath().substring(dir.getAbsolutePath().indexOf("classes"));
                } else if (dir.getAbsolutePath().indexOf("dataDefinitions/") != -1) {
                    relativeDirectory = dir.getAbsolutePath().substring(dir.getAbsolutePath().indexOf("dataDefinitions"));
                }
                res.setContentType("text/html");
                SourceViewServlet.printDirlistingHeader(w, dir.getCanonicalPath(), relativeDirectory);
                if (!relativeDirectory.equals("classes") && !relativeDirectory.equals("classes/dataDefinitions")) {
                    w.println("<b><a href=\"../\">../</a></b> (up one level)");
                }
                if (sw instanceof javaViewer) {
                    SourceViewServlet.processDirectory(w, dir, ".java");
                    Object[] list = dir.list();
                    Arrays.sort(list);
                    for (int i = 0; i < list.length; ++i) {
                        Object s = list[i];
                        File f = new File(dir.getAbsolutePath() + File.separator + (String)s);
                        if (!f.isFile() || !f.getName().endsWith(".java")) continue;
                        w.println("<b><a href=\"" + (String)s + "\">" + (String)s + "</a></b>");
                    }
                } else if (sw instanceof mddViewer) {
                    SourceViewServlet.processDirectory(w, dir, "dd");
                    Object[] list = dir.list();
                    Arrays.sort(list);
                    for (int i = 0; i < list.length; ++i) {
                        Object s = list[i];
                        if (((String)s).indexOf(".") == -1 || !((String)s).endsWith("dd")) continue;
                        String dd = req.getPathInfo() + (String)s;
                        dd = dd.substring(1, dd.lastIndexOf(".")).replace('/', '.');
                        String addr = req.getContextPath() + "/dataDefinitions/" + dd;
                        w.println("<a href=\"" + addr + "\">" + (String)s + "</a>");
                    }
                } else {
                    Logger.getLogger("org.makumba.devel").warning("Don't know how to handle viewer: " + sw + "(" + sw.getClass() + ")");
                }
                w.println("</pre>");
                DevelUtils.printDeveloperSupportFooter(w);
                w.println("</body></html>");
            }
        } else {
            res.setContentType("text/html");
            w.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            w.println("<html><head><title>Error in source viewer</title><body>");
            w.println("Error in source viewer servlet '" + ((Object)((Object)this)).getClass().getName() + "' - unknown source type: " + servletPath);
            DevelUtils.printDeveloperSupportFooter(w);
            w.println("</body></html>");
        }
    }

    public static boolean redirected(HttpServletRequest req, HttpServletResponse res, String servletPath) throws IOException {
        if (req.getPathInfo() == null) {
            if (servletPath.startsWith("/")) {
                servletPath = servletPath.substring(1);
            }
            res.sendRedirect(servletPath + "/");
            return true;
        }
        if (!req.getPathInfo().endsWith("/")) {
            res.sendRedirect(servletPath + req.getPathInfo() + "/");
            return true;
        }
        return false;
    }

    public static void printDirlistingHeader(PrintWriter w, String dir, String relativeDirectory) throws IOException {
        w.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        w.println("<html><head><title>" + relativeDirectory + "</title>");
        w.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" >");
        w.println("</head><body bgcolor=white><table width=\"100%\" bgcolor=\"lightblue\"><tr><td rowspan=\"2\">");
        w.print("<font size=\"+2\"><a href=\".\"><font color=\"darkblue\">" + relativeDirectory + "</font></a></font>");
        w.print("<font size=\"-1\"><br>" + dir + "</font>");
        w.print("</td>");
        w.print("</tr></table>\n<pre style=\"margin-top:0\">");
    }

    public static void processDirectory(PrintWriter w, File dir, String extension) {
        Object[] list = dir.list();
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            Object s = list[i];
            File f = new File(dir.getAbsolutePath() + File.separator + (String)s);
            if (!f.isDirectory() || f.getName().equals("CVS") || f.getName().equals(".svn") || extension != null && !SourceViewServlet.containsFilesWithExtension(f, extension)) continue;
            w.println("<b><a href=\"" + (String)s + "/\">" + (String)s + "/</a></b>");
        }
    }

    static boolean containsFilesWithExtension(File dir, String extension) {
        File f;
        int i;
        String[] list = dir.list();
        for (i = 0; i < list.length; ++i) {
            f = new File(dir.getAbsolutePath() + File.separator + list[i]);
            if (!f.isFile() || !f.getName().endsWith(extension)) continue;
            return true;
        }
        for (i = 0; i < list.length; ++i) {
            f = new File(dir.getAbsolutePath() + File.separator + list[i]);
            if (!f.isDirectory() || !SourceViewServlet.containsFilesWithExtension(f, extension)) continue;
            return true;
        }
        return false;
    }
}

