/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.devel.LineViewer;
import org.makumba.providers.datadefinition.makumba.RecordParser;

public class errorViewer
extends LineViewer {
    private static final String patternLineNumber1 = "\\(.+:(\\d+)\\).*";
    private static final String patternLineNumber2 = ":(\\d+).*";
    private static final String patternLineNumber3 = "\\((\\d+),\\d+\\).*";
    private static final String[] patternLineNumberStrings = new String[]{"\\(.+:(\\d+)\\).*", ":(\\d+).*", "\\((\\d+),\\d+\\).*"};
    Pattern[] patternLineNumbers = new Pattern[]{Pattern.compile(patternLineNumberStrings[0]), Pattern.compile(patternLineNumberStrings[1]), Pattern.compile(patternLineNumberStrings[2])};
    private String hiddenBody;

    public errorViewer(HttpServletRequest request, ServletContext servletContext, String title, String body, String hiddenBody, boolean printHeaderFooter) throws IOException {
        super(false, request, servletContext);
        this.realPath = servletContext.getRealPath(request.getServletPath());
        this.printHeaderFooter = printHeaderFooter;
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(servletContext);
        this.title = title;
        this.hiddenBody = hiddenBody;
        this.reader = new StringReader(body);
    }

    public String parseLine(String s) {
        StringBuffer source = new StringBuffer(s);
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = this.getLineTokenizer(s);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            int indexOf = source.indexOf(token);
            int indexAfter = indexOf + token.length();
            result.append(source.substring(0, indexOf));
            if (token.indexOf(".") != -1) {
                String substring;
                Class javaClass;
                Integer lineNumber = null;
                if (this.searchMDD && RecordParser.findDataDefinition(token, "mdd") != null || RecordParser.findDataDefinition(token, "idd") != null) {
                    result.append(this.formatMDDLink(token));
                } else if (this.searchJavaClasses && (javaClass = this.findClassSimple(token)) != null) {
                    substring = source.substring(indexAfter).trim();
                    lineNumber = this.findLineNumber(substring);
                    result.append(this.formatClassLink(javaClass.getName(), token, lineNumber));
                } else {
                    String jspClass;
                    String jspPage;
                    javaClass = this.findClass(token);
                    if (javaClass != null) {
                        result.append(this.formatClassLink(javaClass, null, token));
                    } else if (this.searchJSPPages && (jspPage = this.findPage(token)) != null) {
                        substring = source.substring(indexAfter).trim();
                        lineNumber = this.findLineNumber(substring);
                        result.append(this.formatJSPLink(jspPage, token, lineNumber));
                    } else if (this.searchCompiledJSPClasses && (jspClass = this.findCompiledJSP(token)) != null) {
                        substring = source.substring(indexAfter).trim();
                        lineNumber = this.findLineNumber(substring);
                        result.append(this.formatClassLink(jspClass, token, lineNumber));
                    } else {
                        result.append(token);
                    }
                }
            } else {
                result.append(token);
            }
            source.delete(0, indexOf + token.length());
        }
        return result.append(source).toString();
    }

    private Integer findLineNumber(String s) {
        for (int i = 0; i < this.patternLineNumbers.length; ++i) {
            Matcher m = this.patternLineNumbers[i].matcher(s);
            if (!m.matches()) continue;
            return Integer.parseInt(m.group(1));
        }
        return null;
    }

    public Class findClassSimple(String token) {
        int index = token.lastIndexOf(46);
        String className = token.substring(0, index);
        return super.findClassSimple(className);
    }

    public void footer(PrintWriter pw) throws IOException {
        if (this.hiddenBody != null) {
            pw.println("<!--\n" + this.hiddenBody + "\n-->");
        }
        super.footer(pw);
    }
}

