/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.analyser.engine.JavaParseData;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.analyser.engine.SyntaxPoint;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.commons.ClassResource;
import org.makumba.commons.StringUtils;
import org.makumba.devel.JavaSourceAnalyzer;
import org.makumba.devel.LineViewer;
import org.makumba.providers.DataDefinitionProvider;

public class javaViewer
extends LineViewer {
    public static final String PROPERTIES_FILE_NAME = "javaSyntax.properties";
    public static Hashtable<String, String> javaSyntaxProperties = new Hashtable();
    private static final String DEFAULT_JAVACOMMENT_STYLE = "color: #1BA55F; font-family: monospace; ";
    private static final String DEFAULT_JAVADOC_STYLE = "color: #3F5FBF; font-family: monospace; ";
    private static final String DEFAULT_JAVAMODIFIER_STYLE = "color: blue; font-weight: bold; font-family: monospace; ";
    private static final String DEFAULT_JAVARESERVEDWORD_STYLE = "color: #7F0055; font-weight: bold; font-family: monospace; ";
    private static final String DEFAULT_JAVASTRINGLITERAL_STYLE = "color: #FF0000; font-style: italic; font-family: monospace; ";
    private boolean compiledJSP = false;
    private boolean haveFile = false;
    private SourceSyntaxPoints syntaxPoints;
    private SyntaxPoint[] sourceSyntaxPoints;
    private JavaParseData javaParseData;
    private DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    private URL url;

    private static void initProperties() {
        try {
            URLConnection connection = ClassResource.get(PROPERTIES_FILE_NAME).openConnection();
            Properties readProperties = new Properties();
            readProperties.load(connection.getInputStream());
            javaSyntaxProperties.put("JavaBlockComment", readProperties.getProperty("JavaBlockComment", DEFAULT_JAVACOMMENT_STYLE));
            javaSyntaxProperties.put("JavaDocComment", readProperties.getProperty("javaDocComment", DEFAULT_JAVADOC_STYLE));
            javaSyntaxProperties.put("JavaLineComment", readProperties.getProperty("javaLineComment", DEFAULT_JAVACOMMENT_STYLE));
            javaSyntaxProperties.put("JavaModifier", readProperties.getProperty("JavaReservedWord", DEFAULT_JAVAMODIFIER_STYLE));
            javaSyntaxProperties.put("JavaReservedWord", readProperties.getProperty("JavaReservedWord", DEFAULT_JAVARESERVEDWORD_STYLE));
            javaSyntaxProperties.put("JavaStringLiteral", readProperties.getProperty("JavaStringLiteral", DEFAULT_JAVASTRINGLITERAL_STYLE));
        }
        catch (Throwable t) {
            Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").fine("Java syntax highlighting properties file 'javaSyntax.properties' not found! Using default values.");
            javaSyntaxProperties.put("JavaDocComment", DEFAULT_JAVADOC_STYLE);
            javaSyntaxProperties.put("JavaBlockComment", DEFAULT_JAVACOMMENT_STYLE);
            javaSyntaxProperties.put("JavaLineComment", DEFAULT_JAVACOMMENT_STYLE);
            javaSyntaxProperties.put("JavaModifier", DEFAULT_JAVAMODIFIER_STYLE);
            javaSyntaxProperties.put("JavaReservedWord", DEFAULT_JAVARESERVEDWORD_STYLE);
            javaSyntaxProperties.put("JavaStringLiteral", DEFAULT_JAVASTRINGLITERAL_STYLE);
        }
    }

    public javaViewer(HttpServletRequest req, HttpServlet sv) throws Exception {
        super(true, req, sv);
        this.servletContext = sv.getServletContext();
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(sv.getServletContext());
        this.contextPath = req.getContextPath();
        this.virtualPath = req.getPathInfo();
        this.virtualPath = this.virtualPath == null ? "/" : this.virtualPath.substring(1);
        this.url = this.virtualPath.endsWith(".java") ? ClassResource.get(this.virtualPath) : ClassResource.get(this.virtualPath.replace('.', '/') + ".java");
        if (this.url != null) {
            this.setSearchLevels(false, false, false, true);
            this.haveFile = true;
        } else {
            String filePath = this.jspClasspath + "/" + this.virtualPath.replace('.', '/') + ".java";
            File jspClassFile = new File(filePath);
            if (jspClassFile.exists()) {
                this.url = new URL("file://" + filePath);
                this.setSearchLevels(false, false, false, true);
                this.compiledJSP = true;
                this.haveFile = true;
            } else {
                String s = this.virtualPath;
                if (s.startsWith("/")) {
                    s = s.substring(1);
                }
                this.url = ClassResource.get(s.replace('.', '/'));
            }
        }
        if (this.haveFile) {
            this.javaParseData = JavaParseData.getParseData("/", this.url.getFile(), JavaSourceAnalyzer.getInstance());
            this.javaParseData.getAnalysisResult(null);
            this.syntaxPoints = this.javaParseData.getSyntaxPoints();
            this.sourceSyntaxPoints = this.javaParseData.getSyntaxPoints().getSyntaxPoints();
            this.addImportedPackages(this.javaParseData.getImportedPackages());
            this.importedClasses = this.javaParseData.getImportedClasses();
        }
        this.readFromURL(this.url);
    }

    public String parseLine(String s) {
        String result = super.parseLine(s);
        if (this.compiledJSP) {
            return result;
        }
        for (String keyWord : javaSyntaxProperties.keySet()) {
            if (javaSyntaxProperties.get(keyWord) == null) continue;
            result = result.replaceAll(keyWord + " ", "<span style=\"" + javaSyntaxProperties.get(keyWord) + "\">" + keyWord + "</span> ");
        }
        return result;
    }

    public void parseText(PrintWriter writer) throws IOException {
        long begin = System.currentTimeMillis();
        this.printPageBegin(writer);
        SyntaxPoint lastSyntaxPoint = null;
        int insideComment = 0;
        for (int j = 0; this.sourceSyntaxPoints != null && j < this.sourceSyntaxPoints.length; ++j) {
            SyntaxPoint currentSyntaxPoint = this.sourceSyntaxPoints[j];
            String type = currentSyntaxPoint.getType();
            int currentLine = currentSyntaxPoint.getLine();
            if (type.equals("TextLine") && currentSyntaxPoint.isBegin()) {
                if (this.printLineNumbers) {
                    writer.print("\n");
                    if (!this.hideLineNumbers) {
                        writer.print("<a style=\"font-style: normal; \" name=\"" + currentLine + "\" href=\"#" + currentLine + "\" class=\"lineNo\">" + currentLine + ":\t</a>");
                    }
                }
            } else {
                String beforeSyntaxPoint = this.syntaxPoints.getLineText(currentLine).substring(lastSyntaxPoint.getColumn() - 1, currentSyntaxPoint.getColumn() - 1);
                if (type.equals("TextLine") && !currentSyntaxPoint.isBegin()) {
                    writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                } else if (currentSyntaxPoint.isBegin()) {
                    if (JavaParseData.isCommentSyntaxPoint(currentSyntaxPoint.getType())) {
                        ++insideComment;
                    }
                    writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                    if (!(JavaParseData.isClassUsageSyntaxPoint(currentSyntaxPoint.getType()) || insideComment > 0 && currentSyntaxPoint.getType().equals("JavaStringLiteral") || javaSyntaxProperties.get(type) == null)) {
                        writer.print("<span style=\"" + javaSyntaxProperties.get(type) + "; \">");
                    }
                } else {
                    if (JavaParseData.isCommentSyntaxPoint(currentSyntaxPoint.getType())) {
                        --insideComment;
                    }
                    if (JavaParseData.isClassUsageSyntaxPoint(currentSyntaxPoint.getType())) {
                        Class webappClass = this.findClass(beforeSyntaxPoint);
                        String classLink = null;
                        if (webappClass == null) {
                            webappClass = this.findClassSimple(beforeSyntaxPoint);
                        }
                        if (webappClass != null) {
                            classLink = this.formatClassLink(webappClass, null, beforeSyntaxPoint);
                        }
                        if (classLink != null) {
                            writer.print(classLink);
                        } else {
                            writer.print(beforeSyntaxPoint);
                        }
                        writer.print("</a>");
                    } else if (currentSyntaxPoint.getType().equals("JavaMethodInvocation")) {
                        String object = null;
                        String method = null;
                        String[] parts = null;
                        parts = beforeSyntaxPoint.indexOf(".") != -1 ? beforeSyntaxPoint.split("\\.") : this.syntaxPoints.getLineText(currentLine).substring(this.sourceSyntaxPoints[j - 2].getColumn() - 1, currentSyntaxPoint.getColumn() - 1).split("\\.");
                        if (parts.length > 1) {
                            object = parts[0];
                            method = parts[1];
                        }
                        Class variableClass = null;
                        String classLink = null;
                        if (object.equals("super")) {
                            variableClass = this.findClass(this.javaParseData.getSuperClass());
                            classLink = this.formatClassLink(variableClass, method, beforeSyntaxPoint);
                        } else if (!object.equals("this")) {
                            String className = this.javaParseData.getDefinedObjectClassName(object, currentSyntaxPoint.getPosition());
                            if (className == null) {
                                className = object;
                            }
                            if (className != null) {
                                variableClass = this.findClass(className);
                                classLink = variableClass != null ? object + "." + this.formatClassLink(variableClass, method, method) : object + "." + method;
                            }
                        }
                        if (classLink != null) {
                            writer.print(classLink);
                        } else {
                            writer.print(beforeSyntaxPoint);
                        }
                        this.javaParseData.getViewedClass();
                    } else if (currentSyntaxPoint.getType().equals("MakumbaFormHandler")) {
                        String[] parts = this.splitHandlerMethodName(beforeSyntaxPoint);
                        DataDefinition dd = null;
                        if (parts != null) {
                            String mddName = this.findMddNameFromHandler(parts[1]);
                            try {
                                dd = this.ddp.getDataDefinition(mddName);
                                writer.print(parts[0] + "<a href=\"" + this.contextPath + "/dataDefinitions/" + dd.getName() + "\" title=\"'" + parts[2] + "'-handler for " + dd.getName() + "\" class=\"classLink\">" + parts[1] + "</a>");
                            }
                            catch (DataDefinitionNotFoundError e) {
                                mddName = this.findMddNameFromHandler(parts[1], true);
                                try {
                                    dd = this.ddp.getDataDefinition(mddName);
                                    DataDefinition parentDd = dd.getParentField().getDataDefinition();
                                    writer.print(parts[0] + "<a href=\"" + this.contextPath + "/dataDefinitions/" + parentDd.getName() + "\" title=\"'" + parts[2] + "'-handler for " + dd.getName() + "\" class=\"classLink\">" + parts[1] + "</a>");
                                }
                                catch (DataDefinitionNotFoundError e1) {
                                }
                                catch (NullPointerException e1) {
                                    // empty catch block
                                }
                            }
                        }
                        if (dd == null) {
                            writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                        }
                    } else {
                        writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                        if (!(insideComment > 0 && currentSyntaxPoint.getType().equals("JavaStringLiteral") || javaSyntaxProperties.get(type) == null)) {
                            writer.print("</span>");
                        }
                    }
                }
            }
            lastSyntaxPoint = currentSyntaxPoint;
        }
        this.printPageEnd(writer);
        double timeTaken = System.currentTimeMillis() - begin;
        Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").info("Java sourcecode viewer took :" + timeTaken / 1000.0 + " seconds");
    }

    private String findMddNameFromHandler(String encodedMddName) {
        return this.findMddNameFromHandler(encodedMddName, false);
    }

    private String findMddNameFromHandler(String encodedMddName, boolean upperCaseSecondButLast) {
        String mddName = "";
        ArrayList<String> partList = new ArrayList<String>();
        Pattern camelCase = Pattern.compile("[A-Z]");
        Matcher m = camelCase.matcher(encodedMddName);
        int currentPos = 0;
        while (m.find()) {
            if (m.start() <= currentPos) continue;
            String s = encodedMddName.substring(currentPos, m.start());
            partList.add(s);
            currentPos = m.start();
        }
        partList.add(encodedMddName.substring(currentPos));
        String[] parts = partList.toArray(new String[partList.size()]);
        for (int i = 0; i < parts.length; ++i) {
            if (upperCaseSecondButLast) {
                if (i + 2 < parts.length) {
                    mddName = mddName + StringUtils.lowerCaseBeginning(parts[i]) + ".";
                    continue;
                }
                if (i + 2 == parts.length) {
                    mddName = mddName + parts[i] + ".";
                    continue;
                }
                mddName = mddName + StringUtils.lowerCaseBeginning(parts[i]);
                continue;
            }
            mddName = i + 1 < parts.length ? mddName + StringUtils.lowerCaseBeginning(parts[i]) + "." : mddName + parts[i];
        }
        return mddName;
    }

    private String[] splitHandlerMethodName(String handlerName) {
        String encodedMddName = null;
        String[] formTypes = new String[]{"on_new", "on_edit", "on_add", "on_delete"};
        for (int i = 0; encodedMddName == null && i < formTypes.length; ++i) {
            if (handlerName.indexOf(formTypes[i]) == -1) continue;
            encodedMddName = handlerName.substring(formTypes[i].length());
        }
        String type = handlerName.substring(handlerName.indexOf("on_") + "on_".length(), handlerName.indexOf(encodedMddName));
        return new String[]{handlerName.substring(0, handlerName.indexOf(encodedMddName)), encodedMddName, type.substring(0, 1).toUpperCase() + type.substring(1)};
    }

    public void intro(PrintWriter w) {
        w.println("<td align=\"center\" bgcolor=\"darkblue\">");
        this.printFileRelations(w);
        w.println("&nbsp;&nbsp;&nbsp;");
        w.println("<font color=\"lightblue\">Java</font></td>");
        String path = this.contextPath + "/classes/" + this.virtualPath.substring(0, this.virtualPath.lastIndexOf(47) + 1);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        w.print("<td align=\"center\"><a href=\"/" + path + "\"><font color=\"darkblue\">browse</font></a></td>");
    }

    static {
        javaViewer.initProperties();
    }
}

