/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel.relations;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMDDParser {
    private File file;
    private String content;
    private Pattern MakumbaQuery;
    private Vector<String> queries = new Vector();

    public static void main(String[] args) {
        JavaMDDParser jqp = new JavaMDDParser("/home/manu/workspace/karamba/public_html/WEB-INF/classes/org/eu/best/general/AccessControlLogic.java");
    }

    public JavaMDDParser(String path) {
        this.file = new File(path);
        this.content = this.readFile(this.file);
        String spaces = "[\\s]*";
        String minOneSpaces = "\\s" + spaces;
        this.MakumbaQuery = Pattern.compile("\"SELECT" + minOneSpaces + ".*(\"" + spaces + "," + spaces + ")");
        this.parse();
    }

    public Vector<String> getQueries() {
        return this.queries;
    }

    private void parse() {
        this.handleSelectQuery();
    }

    private void handleSelectQuery() {
        Matcher m = this.MakumbaQuery.matcher(this.content);
        while (m.find()) {
            String match = this.content.substring(m.start(), m.end());
            if (match.indexOf("+") != -1) continue;
            match = match.substring(1, match.lastIndexOf(34));
            this.queries.add(match);
        }
    }

    private String readFile(File file) {
        StringBuffer sb = new StringBuffer();
        try {
            int n;
            BufferedReader rd = new BufferedReader(new FileReader(file));
            char[] buffer = new char[2048];
            while ((n = rd.read(buffer)) != -1) {
                sb.append(buffer, 0, n);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

